/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.datagen.standard.data_pack;

import com.google.gson.JsonElement;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.datagen.DuplicateDataPolicy;
import com.mememan.nexus.datagen.NexusProviderTypes;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.datagen.standard.ModDataProvider;
import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.specialised.tag.TagBasedPropertyWrapper;
import com.mememan.nexus.property_wrapper.def.tag.TagPropertyWrapper;
import com.mememan.nexus.util.DataGenUtil;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class StandardTagProvider
extends TagsProvider<Object>
implements ModDataProvider {
    protected final PackOutput rootOutput;
    protected final String modId;
    protected final boolean validateAllEntries;
    protected final DuplicateDataPolicy dupeStrat;
    protected final List<TagBasedPropertyWrapper<?, ?, ?>> mappedTagPWs;
    protected final Map<ResourceKey<? extends Registry<?>>, Map<ResourceLocation, TagBuilder>> registryMappedBuilders = new Object2ObjectOpenHashMap();

    public StandardTagProvider(PackOutput targetOutput, CompletableFuture<HolderLookup.Provider> regLookup, String modId, boolean validateAllEntries, DuplicateDataPolicy dupeStrat) {
        super(targetOutput, DataGenPropertyWrapper.RegistryLookupContainer.UNMAPPED_REGISTRY, regLookup);
        this.rootOutput = targetOutput;
        this.modId = modId;
        this.validateAllEntries = validateAllEntries;
        this.dupeStrat = dupeStrat;
        this.mappedTagPWs = PropertyWrapper.PropertyWrappersContainer.getInferrableDataGennableWrappersOfType(TagBasedPropertyWrapper.class, modId);
    }

    public StandardTagProvider(PackOutput targetOutput, CompletableFuture<HolderLookup.Provider> regLookup, CompletableFuture<TagsProvider.TagLookup<Object>> tagLookupFuture, String modId, boolean validateAllEntries, DuplicateDataPolicy dupeStrat) {
        super(targetOutput, DataGenPropertyWrapper.RegistryLookupContainer.UNMAPPED_REGISTRY, regLookup, tagLookupFuture);
        this.rootOutput = targetOutput;
        this.modId = modId;
        this.validateAllEntries = validateAllEntries;
        this.dupeStrat = dupeStrat;
        this.mappedTagPWs = PropertyWrapper.PropertyWrappersContainer.getInferrableDataGennableWrappersOfType(TagBasedPropertyWrapper.class, modId);
    }

    @Override
    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput output) {
        record CombinedData<T>(HolderLookup.Provider currentContents, TagsProvider.TagLookup<T> parentTagLookup) {
        }
        return ((CompletableFuture)((CompletableFuture)this.m_274574_().thenApply(contentProvider -> {
            this.f_275754_.complete(null);
            return contentProvider;
        })).thenCombineAsync((CompletionStage)this.f_273855_, (parentContentProvider, currentTag) -> new CombinedData((HolderLookup.Provider)parentContentProvider, currentTag))).thenCompose(combinedTagLookupData -> this.serializeTagEntries(output, combinedTagLookupData.currentContents, combinedTagLookupData.parentTagLookup));
    }

    protected void m_6577_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.registryMappedBuilders.clear();
        this.addObjectTags(provider);
    }

    protected <T> void addObjectTags(HolderLookup.Provider provider) {
        if (!this.mappedTagPWs.isEmpty()) {
            this.mappedTagPWs.stream().map(curPW -> curPW).forEach(curPW -> {
                List<Supplier<TagKey<Supplier>>> objectTags = curPW.getObjectTags();
                List<Supplier<TagKey<?>>> additionalTags = curPW.getAdditionalTags();
                Supplier parentObject = curPW.getParentObject();
                String objectDescId = curPW.getObjectDescriptionId();
                String objectClassName = parentObject.get().getClass().getSimpleName();
                AtomicBoolean isTag = new AtomicBoolean();
                AtomicBoolean tagHasNoExclusiveData = new AtomicBoolean();
                if (curPW instanceof TagPropertyWrapper) {
                    TagPropertyWrapper curTPW;
                    TagPropertyWrapper curTagPW = curTPW = (TagPropertyWrapper)curPW;
                    Supplier parentTag = curTagPW.getParentObject();
                    TagKey parentTagObj = (TagKey)parentTag.get();
                    List<Supplier<Supplier>> taggedObjects = curTagPW.getTaggedObjects();
                    List tagKeys = curTagPW.getChildTags();
                    if (taggedObjects.isEmpty() && tagKeys.isEmpty()) {
                        tagHasNoExclusiveData.set(true);
                    } else {
                        taggedObjects.forEach(curTaggedObject -> {
                            ResourceLocation childObjLoc;
                            Object taggedObject = curTaggedObject.get();
                            String taggedObjClassName = taggedObject.getClass().getSimpleName();
                            if (this.validateDupeObjectTag(parentTagObj, taggedObjClassName, childObjLoc = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(taggedObject))) {
                                NexusConstants.LOGGER.debug("[{}] [Tagging {}]: {} -> {}", new Object[]{this.getModId(), taggedObjClassName, childObjLoc, parentTagObj});
                                this.trackTag(parentTagObj).m_215900_(childObjLoc);
                            }
                        });
                        tagKeys.forEach(curTagKey -> {
                            ResourceLocation taggedTagKeyLoc;
                            TagKey taggedTagKey = (TagKey)curTagKey.get();
                            if (this.validateDupeObjectTag(taggedTagKey, objectClassName, taggedTagKeyLoc = taggedTagKey.f_203868_())) {
                                NexusConstants.LOGGER.debug("[{}] [Tagging TagKey]: {} -> {}", new Object[]{this.getModId(), taggedTagKeyLoc, parentTagObj});
                                this.trackTag(parentTagObj).m_215907_(taggedTagKeyLoc);
                            }
                        });
                    }
                    isTag.set(true);
                }
                if ((!isTag.get() || tagHasNoExclusiveData.get()) && objectTags.isEmpty() && additionalTags.isEmpty() && (this.validateAllEntries() || curPW.getProviderTypeRequisites().getOrDefault(this.getProviderType(), false).booleanValue())) {
                    throw new NullPointerException(String.format("Missing tag entry for %s: %s, required by mod: %s, either because validateAllEntries is set to true for this provider or the object itself requires validation through DataGenBasedPropertyWrapper#getProviderTypeRequisites().", objectClassName, curPW.getObjectDescriptionId(), this.modId));
                }
                ResourceLocation parentObjLoc = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentObject.get());
                objectTags.forEach(tK -> {
                    TagKey parentTagKey = (TagKey)tK.get();
                    if (this.validateDupeObjectTag(parentTagKey, objectClassName, parentObjLoc)) {
                        NexusConstants.LOGGER.debug("[{}] [Tagging {}]: {} -> {}", new Object[]{this.getModId(), objectClassName, parentObjLoc, parentTagKey});
                        if (isTag.get()) {
                            this.trackTag(parentTagKey).m_215907_(parentObjLoc);
                        } else {
                            this.trackTag(parentTagKey).m_215900_(parentObjLoc);
                        }
                    }
                });
                additionalTags.forEach(tK -> {
                    TagKey parentTagKey = (TagKey)tK.get();
                    if (this.validateDupeObjectTag(parentTagKey, objectClassName, parentObjLoc)) {
                        NexusConstants.LOGGER.debug("[{}] [Tagging {}]: {} -> {} (Additional Tag for Registry: {})", new Object[]{this.getModId(), objectClassName, parentObjLoc, parentTagKey, parentTagKey.f_203867_()});
                        if (isTag.get()) {
                            this.trackTag(parentTagKey).m_215907_(parentObjLoc);
                        } else {
                            this.trackTag(parentTagKey).m_215900_(parentObjLoc);
                        }
                    }
                });
            });
        }
    }

    protected <T> CompletableFuture<?> serializeTagEntries(CachedOutput targetOutput, HolderLookup.Provider currentContents, TagsProvider.TagLookup<T> parentTagLookup) {
        return CompletableFuture.allOf((CompletableFuture[])this.registryMappedBuilders.entrySet().stream().flatMap(curEntry -> {
            ResourceKey registryKey = (ResourceKey)curEntry.getKey();
            Map tagBuilders = (Map)curEntry.getValue();
            HolderLookup.RegistryLookup regBasedContentLookup = currentContents.m_255025_(registryKey);
            Predicate<ResourceLocation> elementPresenceWithinRegistryValidator = tagLoc -> regBasedContentLookup.m_254902_(ResourceKey.m_135785_((ResourceKey)registryKey, (ResourceLocation)tagLoc)).isPresent();
            Predicate<ResourceLocation> tagLocalOrParentPresenceValidator = tagLoc -> this.f_126543_.containsKey(tagLoc) || parentTagLookup.m_274455_(TagKey.m_203882_((ResourceKey)registryKey, (ResourceLocation)tagLoc));
            return tagBuilders.entrySet().stream().map(curTagEntry -> {
                boolean shouldCrash;
                ResourceLocation tagLoc = (ResourceLocation)curTagEntry.getKey();
                TagBuilder tagBuilder = (TagBuilder)curTagEntry.getValue();
                List serializedTagEntries = tagBuilder.m_215904_();
                List<TagEntry> missingSerializedTags = serializedTagEntries.stream().filter(tagEntry -> !tagEntry.m_215940_(elementPresenceWithinRegistryValidator, tagLocalOrParentPresenceValidator)).toList();
                boolean bl = shouldCrash = this.validateAllEntries() && !missingSerializedTags.isEmpty();
                if (shouldCrash) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Couldn't define tag %s as it is missing following references: %s (required by mod of ID %s). Please ensure that these tags are registered and/or that their JSON files are generated beforehand (they don't have to be physically present, this primarily refers to generation order).", tagLoc, missingSerializedTags.stream().map(Objects::toString).collect(Collectors.joining(",")), this.modId));
                }
                DataResult serializedTagResult = TagFile.f_215958_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new TagFile(serializedTagEntries, false));
                JsonElement serializedTagJson = (JsonElement)serializedTagResult.getOrThrow(false, arg_0 -> ((Logger)f_126541_).error(arg_0));
                PackOutput.PathProvider actualPathProvider = this.rootOutput.m_245269_(PackOutput.Target.DATA_PACK, TagManager.m_203918_((ResourceKey)registryKey));
                Path targetTagPath = actualPathProvider.m_245731_(tagLoc);
                return DataGenUtil.saveStableAndMerge(targetOutput, serializedTagJson, targetTagPath, DataGenUtil.TAG_FILE_MERGER);
            });
        }).toArray(CompletableFuture[]::new));
    }

    protected <T> TagBuilder trackTag(TagKey<T> tagKeyToTrack) {
        return this.registryMappedBuilders.computeIfAbsent(tagKeyToTrack.f_203867_(), tkRegLoc -> new Object2ObjectOpenHashMap()).computeIfAbsent(tagKeyToTrack.f_203868_(), tkLoc -> TagBuilder.m_215899_());
    }

    protected <T> boolean validateDupeObjectTag(TagKey<T> tagKeyToTrack, String objectClassName, ResourceLocation objectLoc) {
        Map<ResourceLocation, TagBuilder> mappedTagBuilders = this.registryMappedBuilders.get(tagKeyToTrack.f_203867_());
        if (mappedTagBuilders != null) {
            boolean objectAlreadyTaggedWithSameTag;
            boolean bl = objectAlreadyTaggedWithSameTag = mappedTagBuilders.get(tagKeyToTrack.f_203868_()) != null && mappedTagBuilders.get(tagKeyToTrack.f_203868_()).m_215904_().stream().anyMatch(curEntry -> curEntry.m_215940_(arg_0 -> ((ResourceLocation)objectLoc).equals(arg_0), arg_0 -> ((ResourceLocation)objectLoc).equals(arg_0)));
            if (objectAlreadyTaggedWithSameTag) {
                String objectName = objectLoc.toString();
                switch (this.getDuplicateDataPolicy()) {
                    case CRASH: {
                        throw new IllegalStateException(String.format("Attempted to tag %s %s with duplicate tag key %s (from mod of ID %s), specified DuplicateDataPolicy is CRASH.", objectClassName, objectName, tagKeyToTrack.f_203868_(), this.getModId()));
                    }
                    case EXCLUDE_WARN: {
                        NexusConstants.LOGGER.warn("Attempted to tag {} {} with duplicate tag key {} (from mod of ID {}), specified DuplicateDataPolicy is EXCLUDE_WARN. Skipping...", new Object[]{objectClassName, objectName, tagKeyToTrack.f_203868_(), this.getModId()});
                        return false;
                    }
                    case EXCLUDE_SILENT: {
                        return false;
                    }
                    case OVERRIDE_WARN: {
                        NexusConstants.LOGGER.warn("Overriding duplicate tag key {} for {} {} (from mod of ID {}), specified DuplicateDataPolicy is OVERRIDE_WARN.", new Object[]{tagKeyToTrack.f_203868_(), objectClassName, objectName, this.getModId()});
                        mappedTagBuilders.put(tagKeyToTrack.f_203868_(), TagBuilder.m_215899_());
                        return true;
                    }
                    case OVERRIDE_SILENT: {
                        mappedTagBuilders.put(tagKeyToTrack.f_203868_(), TagBuilder.m_215899_());
                        return true;
                    }
                }
            } else {
                return true;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public String m_6055_() {
        return String.format("Tags [%s]", this.getModId());
    }

    @Override
    @NotNull
    public String getModId() {
        return this.modId;
    }

    @Override
    public boolean validateAllEntries() {
        return this.validateAllEntries;
    }

    @Override
    @NotNull
    public ProviderType getProviderType() {
        return NexusProviderTypes.TAG_PROVIDER;
    }

    @Override
    @NotNull
    public DuplicateDataPolicy getDuplicateDataPolicy() {
        return this.dupeStrat;
    }
}

