/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.datagen.standard.resource_pack;

import com.google.gson.JsonElement;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.client.block.BlockStateDefinition;
import com.mememan.nexus.datagen.DuplicateDataPolicy;
import com.mememan.nexus.datagen.NexusProviderTypes;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.datagen.standard.ModDataProvider;
import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.def.block.BlockPropertyWrapper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class StandardBlockStateProvider
implements ModDataProvider {
    protected final PackOutput.PathProvider blockStatePathProvider;
    protected final String modId;
    protected final boolean validateAllEntries;
    protected final DuplicateDataPolicy dupeStrat;
    protected final List<BlockPropertyWrapper<? extends Block>> mappedBlockPWs;
    protected final ObjectOpenHashSet<ResourceLocation> trackedBlockStates = new ObjectOpenHashSet();

    public StandardBlockStateProvider(PackOutput targetOutput, String modId, boolean validateAllEntries, DuplicateDataPolicy dupeStrat) {
        this.blockStatePathProvider = targetOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.modId = modId;
        this.validateAllEntries = validateAllEntries;
        this.dupeStrat = dupeStrat;
        this.mappedBlockPWs = PropertyWrapper.PropertyWrappersContainer.getInferrableDataGennableWrappersOfType(BlockPropertyWrapper.class, modId);
    }

    @Override
    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        ObjectArrayList savedStateFutures = new ObjectArrayList();
        return CompletableFuture.allOf((CompletableFuture[])this.mappedBlockPWs.stream().peek(curPW -> this.generateBlockState(cachedOutput, (BlockPropertyWrapper)curPW, (ObjectArrayList<CompletableFuture<?>>)savedStateFutures)).flatMap(curPW -> savedStateFutures.stream()).toArray(CompletableFuture[]::new));
    }

    protected <B extends Block> void generateBlockState(CachedOutput targetOutput, BlockPropertyWrapper<B> targetBPW, ObjectArrayList<CompletableFuture<?>> savedStateFutures) {
        Supplier parentObjSup = targetBPW.getParentObject();
        String blockClassName = ((Block)parentObjSup.get()).getClass().getSimpleName();
        String blockName = targetBPW.getObjectDescriptionId();
        ResourceLocation blockStateRL = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow((Block)parentObjSup.get());
        targetBPW.getBlockStateDefinition().ifPresentOrElse(bsdMappingFunc -> {
            BlockStateDefinition mappedBSD = (BlockStateDefinition)bsdMappingFunc.apply(parentObjSup);
            JsonElement generatedState = StandardBlockStateProvider.serializeBlockStateJson(mappedBSD, blockClassName, blockName);
            Runnable stateSaveTask = () -> {
                NexusConstants.LOGGER.info("[{}] [Generating Block State for {}]: {}", new Object[]{this.getModId(), blockClassName, blockStateRL});
                savedStateFutures.add((Object)DataProvider.m_253162_((CachedOutput)targetOutput, (JsonElement)generatedState, (Path)this.blockStatePathProvider.m_245731_(blockStateRL)));
            };
            this.handleDuplicateState(blockStateRL, blockClassName, stateSaveTask);
        }, () -> {
            if (this.validateAllEntries() || targetBPW.getProviderTypeRequisites().getOrDefault(this.getProviderType(), false).booleanValue()) {
                throw new NullPointerException(String.format("Missing block state mapper for %s: %s, required by mod: %s, either because validateAllEntries is set to true for this provider or the object itself requires validation through DataGenBasedPropertyWrapper#getProviderTypeRequisites().", blockClassName, blockName, this.modId));
            }
        });
    }

    protected void handleDuplicateState(ResourceLocation targetBlockId, String blockClassName, Runnable stateSaveTask) {
        if (!this.trackedBlockStates.add((Object)targetBlockId)) {
            switch (this.getDuplicateDataPolicy()) {
                case CRASH: {
                    throw new IllegalArgumentException(String.format("Duplicate block state entry for: %s", targetBlockId));
                }
                case EXCLUDE_WARN: {
                    NexusConstants.LOGGER.warn("Attempted to generate duplicate block state for {} {} (from mod of ID {}), specified DuplicateDataPolicy is EXCLUDE_WARN. Skipping...", new Object[]{blockClassName, targetBlockId, this.getModId()});
                    break;
                }
                case EXCLUDE_SILENT: {
                    break;
                }
                case OVERRIDE_WARN: {
                    NexusConstants.LOGGER.warn("Overriding duplicate block state for {} from mod of ID {}, specified DuplicateDataPolicy is OVERRIDE_WARN.", (Object)targetBlockId, (Object)this.getModId());
                    stateSaveTask.run();
                    break;
                }
                case OVERRIDE_SILENT: {
                    stateSaveTask.run();
                }
            }
        } else {
            stateSaveTask.run();
        }
    }

    @Override
    @NotNull
    public String m_6055_() {
        return String.format("BlockStates [%s]", this.getModId());
    }

    @Override
    @NotNull
    public String getModId() {
        return this.modId;
    }

    @Override
    public boolean validateAllEntries() {
        return this.validateAllEntries;
    }

    @Override
    @NotNull
    public ProviderType getProviderType() {
        return NexusProviderTypes.BLOCK_STATE_PROVIDER;
    }

    @Override
    @NotNull
    public DuplicateDataPolicy getDuplicateDataPolicy() {
        return this.dupeStrat;
    }

    protected static JsonElement serializeBlockStateJson(BlockStateDefinition mappedBSD, String blockClassName, String blockName) {
        BlockStateGenerator stateGen = Optional.ofNullable(mappedBSD.getBlockStateSupplier()).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to retrieve block state generator for %s: %s (No generator present via %s#getBlockStateSupplier())", blockClassName, blockName, mappedBSD.getClass().getSimpleName())));
        return Optional.ofNullable((JsonElement)stateGen.get()).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to serialize block state JSON for %s: %s (%s#get() returned null)", blockClassName, blockName, stateGen.getClass().getSimpleName())));
    }
}

