/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.datagen.standard.resource_pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.datagen.DuplicateDataPolicy;
import com.mememan.nexus.datagen.NexusProviderTypes;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.datagen.standard.ModDataProvider;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.specialised.language.LanguageBasedPropertyWrapper;
import com.mememan.nexus.util.StringUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectRBTreeMap;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class StandardLanguageProvider
implements ModDataProvider {
    protected final Object2ObjectRBTreeMap<String, String> localizationEntries = new Object2ObjectRBTreeMap();
    protected final PackOutput output;
    protected final String modId;
    protected final String locale;
    protected final boolean validateAllEntries;
    protected final DuplicateDataPolicy dupeStrat;
    protected final Path outputPath;
    protected final List<LanguageBasedPropertyWrapper<?, ?, ?>> mappedLanguagePWs;

    public StandardLanguageProvider(PackOutput output, String modId, String locale, boolean validateAllEntries, DuplicateDataPolicy dupeStrat) {
        this.output = output;
        this.modId = modId;
        this.locale = locale;
        this.validateAllEntries = validateAllEntries;
        this.dupeStrat = dupeStrat;
        this.outputPath = output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve(modId).resolve("lang").resolve(locale + ".json");
        this.mappedLanguagePWs = PropertyWrapper.PropertyWrappersContainer.getInferrableDataGennableWrappersOfType(LanguageBasedPropertyWrapper.class, modId);
    }

    @Override
    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        this.addTranslations();
        if (!this.localizationEntries.isEmpty()) {
            JsonObject targetJson = new JsonObject();
            this.localizationEntries.forEach((arg_0, arg_1) -> ((JsonObject)targetJson).addProperty(arg_0, arg_1));
            return DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)targetJson, (Path)this.outputPath);
        }
        return CompletableFuture.allOf(new CompletableFuture[0]);
    }

    protected void addTranslations() {
        if (!this.mappedLanguagePWs.isEmpty()) {
            this.mappedLanguagePWs.forEach(curPW -> {
                AtomicReference locValRef = new AtomicReference();
                AtomicReference postMappedValueRef = new AtomicReference();
                Optional<String> localizedValue = curPW.getLocalizedObjectKey((locVal, postMappedVal) -> {
                    locValRef.set(locVal);
                    postMappedValueRef.set(postMappedVal);
                });
                String objectDescId = curPW.getObjectDescriptionId();
                String objectClassName = curPW.getParentObject().get().getClass().getSimpleName();
                localizedValue.ifPresentOrElse(locVal -> {
                    String prevLocVal = (String)locValRef.get();
                    NexusConstants.LOGGER.debug("[{}] [Generating Translation for {}]: '{}' -> '{}'", new Object[]{this.modId, objectClassName, objectDescId, prevLocVal != null ? prevLocVal : locVal});
                    String postMappedVal = (String)postMappedValueRef.get();
                    if (prevLocVal != null && postMappedVal != null) {
                        NexusConstants.LOGGER.debug("[{}] [Applying Post-Translation Mapping for {}]: '{}' -> '{}' -> '{}'", new Object[]{this.modId, objectClassName, objectDescId, prevLocVal, postMappedVal});
                    }
                    this.add(objectDescId, (String)locVal);
                }, () -> {
                    if (this.validateAllEntries() || curPW.getProviderTypeRequisites().getOrDefault(this.getProviderType(), false).booleanValue()) {
                        throw new NullPointerException(String.format("Missing localized key for %s: %s, required by mod: %s, either because validateAllEntries is set to true for this provider or the object itself requires validation through DataGenBasedPropertyWrapper#getProviderTypeRequisites().", objectClassName, objectDescId, this.modId));
                    }
                });
                Map<String, Function<String, String>> additionalAssociatedTranslations = curPW.getAdditionalLocalizationKeys();
                if (!additionalAssociatedTranslations.isEmpty()) {
                    additionalAssociatedTranslations.forEach((unlocalizedKey, customTranslationMapper) -> {
                        String localizedAdditionalValue = customTranslationMapper == null ? StringUtil.literallyLocalize(unlocalizedKey, curPW.getCustomSeparatorWords()) : (String)customTranslationMapper.apply(unlocalizedKey);
                        NexusConstants.LOGGER.debug("[{}] [Generating Translation for Additional Key Associated with {}]: '{}' -> '{}'", new Object[]{this.modId, objectClassName, unlocalizedKey, localizedAdditionalValue});
                        this.add((String)unlocalizedKey, localizedAdditionalValue);
                    });
                }
            });
        }
    }

    @Override
    @NotNull
    public String getModId() {
        return this.modId;
    }

    @Override
    @NotNull
    public String m_6055_() {
        return String.format("Language [%s] [%s]", this.getLocale(), this.getModId());
    }

    @Override
    public boolean validateAllEntries() {
        return this.validateAllEntries;
    }

    @Override
    @NotNull
    public ProviderType getProviderType() {
        return NexusProviderTypes.LANGUAGE_PROVIDER;
    }

    @Override
    @NotNull
    public DuplicateDataPolicy getDuplicateDataPolicy() {
        return this.dupeStrat;
    }

    public String getLocale() {
        return this.locale;
    }

    protected void addBlock(Supplier<? extends Block> targetBlockSup, String localizedBlockName) {
        this.addBlock(targetBlockSup.get(), localizedBlockName);
    }

    protected void addBlock(Block targetBlock, String localizedBlockName) {
        this.add(targetBlock.m_7705_(), localizedBlockName);
    }

    protected void addEnchantment(Supplier<? extends Enchantment> targetEnchantmentSup, String localizedEnchantmentName) {
        this.addEnchantment(targetEnchantmentSup.get(), localizedEnchantmentName);
    }

    protected void addEnchantment(Enchantment targetEnchantment, String localizedEnchantmentName) {
        this.add(targetEnchantment.m_44704_(), localizedEnchantmentName);
    }

    protected void addEntityType(Supplier<? extends EntityType<?>> targetEntityTypeSup, String localizedEntityTypeName) {
        this.addEntityType(targetEntityTypeSup.get(), localizedEntityTypeName);
    }

    protected void addEntityType(EntityType<?> targetEntityType, String localizedEntityTypeName) {
        this.add(targetEntityType.m_20675_(), localizedEntityTypeName);
    }

    protected void addItem(Supplier<? extends Item> targetItemSup, String localizedItemName) {
        this.addItem(targetItemSup.get(), localizedItemName);
    }

    protected void addItem(Item targetItem, String localizedItemName) {
        this.add(targetItem.m_5524_(), localizedItemName);
    }

    protected void addMobEffect(Supplier<? extends MobEffect> targetMobEffectSup, String localizedMobEffectName) {
        this.addMobEffect(targetMobEffectSup.get(), localizedMobEffectName);
    }

    protected void addMobEffect(MobEffect targetMobEffect, String localizedMobEffectName) {
        this.add(targetMobEffect.m_19481_(), localizedMobEffectName);
    }

    protected void add(String unlocalizedKey, String localizedValue) {
        boolean isAlreadyMapped = this.localizationEntries.containsKey((Object)unlocalizedKey);
        if (isAlreadyMapped) {
            switch (this.getDuplicateDataPolicy()) {
                case CRASH: {
                    throw new IllegalStateException(String.format("Attempted to localize duplicate translation key (original: %s -> %s | duplicate: %s -> %s) from mod of ID %s, specified DuplicateDataPolicy is CRASH.", unlocalizedKey, this.localizationEntries.get((Object)unlocalizedKey), unlocalizedKey, localizedValue, this.getModId()));
                }
                case EXCLUDE_WARN: {
                    NexusConstants.LOGGER.warn("Attempted to localize duplicate translation key (original: {} -> {} | duplicate: {} -> {}) from mod of ID {}, specified DuplicateDataPolicy is EXCLUDE_WARN. Skipping...", new Object[]{unlocalizedKey, this.localizationEntries.get((Object)unlocalizedKey), unlocalizedKey, localizedValue, this.getModId()});
                    break;
                }
                case EXCLUDE_SILENT: {
                    break;
                }
                case OVERRIDE_WARN: {
                    NexusConstants.LOGGER.warn("Overriding duplicate translation key (original: {} -> {} | duplicate (new): {} -> {}) from mod of ID {}, specified DuplicateDataPolicy is OVERRIDE_WARN.", new Object[]{unlocalizedKey, this.localizationEntries.get((Object)unlocalizedKey), unlocalizedKey, localizedValue, this.getModId()});
                    this.localizationEntries.put((Object)unlocalizedKey, (Object)localizedValue);
                    break;
                }
                case OVERRIDE_SILENT: {
                    this.localizationEntries.put((Object)unlocalizedKey, (Object)localizedValue);
                }
            }
        } else {
            this.localizationEntries.put((Object)unlocalizedKey, (Object)localizedValue);
        }
    }
}

