/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.datagen.standard.resource_pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.datagen.DuplicateDataPolicy;
import com.mememan.nexus.datagen.NexusProviderTypes;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.datagen.standard.ModDataProvider;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.specialised.model.ModelBasedPropertyWrapper;
import com.mememan.nexus.util.ModelUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.ModelProvider;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class StandardModelProvider
extends ModelProvider
implements ModDataProvider {
    protected final String modId;
    protected final boolean validateAllEntries;
    protected final DuplicateDataPolicy dupeStrat;
    protected final List<? extends ModelBasedPropertyWrapper<?, ?, ?>> mappedModelPWs;
    protected final ObjectOpenHashSet<ResourceLocation> trackedModels = new ObjectOpenHashSet();

    public StandardModelProvider(PackOutput targetPackOutput, String modId, boolean validateAllEntries, DuplicateDataPolicy dupeStrat) {
        super(targetPackOutput);
        this.modId = modId;
        this.validateAllEntries = validateAllEntries;
        this.dupeStrat = dupeStrat;
        this.mappedModelPWs = PropertyWrapper.PropertyWrappersContainer.getInferrableDataGennableWrappersOfType(ModelBasedPropertyWrapper.class, modId);
    }

    @Override
    @NotNull
    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        ObjectArrayList constructedChunkedModelDefinitions = new ObjectArrayList();
        this.populateModelDefinitions(cachedOutput, (List<CompletableFuture<?>>)constructedChunkedModelDefinitions);
        return CompletableFuture.allOf((CompletableFuture[])constructedChunkedModelDefinitions.toArray(CompletableFuture[]::new));
    }

    protected <T> void populateModelDefinitions(CachedOutput cachedOutput, List<CompletableFuture<?>> serializedModelDefinitions) {
        this.mappedModelPWs.stream().map(curPW -> curPW).forEach(curPW -> {
            Supplier parentObj = curPW.getParentObject();
            String objectClassName = parentObj.get().getClass().getSimpleName();
            curPW.getModelDefinition().ifPresentOrElse(modelDefMapper -> {
                ModelBasedPropertyWrapper.ModelDefinition convertedDefinition = (ModelBasedPropertyWrapper.ModelDefinition)modelDefMapper.apply(parentObj);
                List<ModelBasedPropertyWrapper.ModelDefinition> flattenedModelDefinitions = convertedDefinition.getFlattenedModelDefinitions();
                String descId = curPW.getObjectDescriptionId();
                ResourceLocation primaryModelRL = this.formatModelResourceLocation(descId, convertedDefinition);
                Function<ModelBasedPropertyWrapper.ModelDefinition, ResourceLocation> rlFormatter = modelDef -> this.formatModelResourceLocation(descId, (ModelBasedPropertyWrapper.ModelDefinition)modelDef);
                Consumer<ModelBasedPropertyWrapper.ModelDefinition> serializationAction = modelDef -> serializedModelDefinitions.add(DataProvider.m_253162_((CachedOutput)cachedOutput, (JsonElement)this.constructModelJson(descId, (ModelBasedPropertyWrapper.ModelDefinition)modelDef), (Path)this.f_236326_.m_245731_((ResourceLocation)rlFormatter.apply((ModelBasedPropertyWrapper.ModelDefinition)modelDef))));
                this.handleModelGeneration(primaryModelRL, descId, objectClassName, () -> serializationAction.accept(convertedDefinition));
                if (!flattenedModelDefinitions.isEmpty()) {
                    flattenedModelDefinitions.forEach(curDef -> this.handleModelGeneration((ResourceLocation)rlFormatter.apply((ModelBasedPropertyWrapper.ModelDefinition)curDef), descId, objectClassName, () -> serializationAction.accept((ModelBasedPropertyWrapper.ModelDefinition)curDef)));
                }
            }, () -> {
                if (this.validateAllEntries() || curPW.getProviderTypeRequisites().getOrDefault(this.getProviderType(), false).booleanValue()) {
                    throw new NullPointerException(String.format("Missing model mapper for %s: %s, required by mod: %s, either because validateAllEntries is set to true for this provider or the object itself requires validation through DataGenBasedPropertyWrapper#getProviderTypeRequisites().", objectClassName, curPW.getObjectDescriptionId(), this.modId));
                }
            });
        });
    }

    protected void handleModelGeneration(ResourceLocation modelRL, String objectDescId, String objectClassName, Runnable serializationAction) {
        NexusConstants.LOGGER.debug("[{}] [Generating Model for {}]: {} (Model File ResourceLocation: {})", new Object[]{this.getModId(), objectClassName, objectDescId, modelRL});
        if (!this.trackedModels.add((Object)modelRL)) {
            switch (this.getDuplicateDataPolicy()) {
                case CRASH: {
                    throw new IllegalStateException(String.format("Attempted to generate duplicate %s model %s (from mod of ID %s), specified DuplicateDataPolicy is CRASH.", objectClassName, modelRL, this.getModId()));
                }
                case EXCLUDE_WARN: {
                    NexusConstants.LOGGER.warn("Attempted to generate duplicate {} model {} (from mod of ID {}), specified DuplicateDataPolicy is EXCLUDE_WARN. Skipping...", new Object[]{objectClassName, modelRL, this.getModId()});
                    break;
                }
                case EXCLUDE_SILENT: {
                    break;
                }
                case OVERRIDE_WARN: {
                    NexusConstants.LOGGER.warn("Overriding duplicate {} model for {} from mod of ID {}, specified DuplicateDataPolicy is OVERRIDE_WARN.", new Object[]{objectClassName, modelRL, this.getModId()});
                    serializationAction.run();
                    break;
                }
                case OVERRIDE_SILENT: {
                    serializationAction.run();
                }
            }
        } else {
            serializationAction.run();
        }
    }

    @NotNull
    protected ResourceLocation formatModelResourceLocation(String descId, ModelBasedPropertyWrapper.ModelDefinition convertedDefinition) {
        String weaklyFormattedDescId = descId.contains(".") ? descId.substring(descId.lastIndexOf(".") + 1) : descId;
        return new ResourceLocation(this.modId, convertedDefinition.getBackingDirectory().map(curDir -> curDir.endsWith("/") ? curDir : curDir.concat("/")).orElse("").concat(convertedDefinition.getCustomModelName().orElse(weaklyFormattedDescId.concat(convertedDefinition.getParentModel().f_125587_.orElse("")))));
    }

    protected JsonObject constructModelJson(String defaultedModelDefName, @NotNull ModelBasedPropertyWrapper.ModelDefinition modelDefinition) {
        AtomicReference modelJson = new AtomicReference();
        ModelTemplate parentModel = modelDefinition.getParentModel();
        parentModel.m_125612_(this.formatModelResourceLocation(defaultedModelDefName, modelDefinition), modelDefinition.getTextureMapping().orElse(ModelUtil.EMPTY_TEXTURE_MAPPING), (finalizedModelLoc, modelJsonFileSup) -> modelJson.set(modelDefinition.constructJson((ResourceLocation)finalizedModelLoc, (Supplier<JsonElement>)modelJsonFileSup)));
        return (JsonObject)modelJson.get();
    }

    @Override
    @NotNull
    public String m_6055_() {
        return String.format("Models [%s]", this.getModId());
    }

    @Override
    @NotNull
    public String getModId() {
        return this.modId;
    }

    @Override
    public boolean validateAllEntries() {
        return this.validateAllEntries;
    }

    @Override
    @NotNull
    public ProviderType getProviderType() {
        return NexusProviderTypes.MODEL_PROVIDER;
    }

    @Override
    @NotNull
    public DuplicateDataPolicy getDuplicateDataPolicy() {
        return this.dupeStrat;
    }
}

