/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.event.blueprint;

import com.mememan.nexus.loader.ModSide;
import com.mememan.nexus.platform.NexusServices;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public interface EventBlueprint<T> {
    public Class<T> getEventInterface();

    default public Class<?> getActualEventType() {
        return this.getEventInterface();
    }

    @Nullable
    public T mergeListeners(T[] var1);

    public ModSide getEventSide();

    default public <R> R fireEvent(Function<T, R> eventMapper, ModSide firingSide) {
        return NexusServices.EVENT_BUS.fireEventHook(this.getEventInterface(), eventMapper, firingSide, this.getActualEventType());
    }

    default public <R> R fireEvent(Function<T, R> eventMapper) {
        return this.fireEvent(eventMapper, this.getEventSide());
    }

    default public void onEvent(T listener, int listenerPriority) {
        NexusServices.EVENT_BUS.onEvent(this.getEventInterface(), listener, this.getEventSide(), listenerPriority, this.getActualEventType());
    }

    default public void onEvent(T listener) {
        this.onEvent(listener, 0);
    }

    default public Map<Integer, List<T>> getListeners() {
        return NexusServices.EVENT_BUS.getListenersFor(this.getEventInterface(), this.getActualEventType());
    }

    default public List<T> getListeners(int priority) {
        return this.getListeners().get(priority);
    }

    default public List<T> getAllListeners() {
        return this.getListeners().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

