/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.event.blueprint;

import com.mememan.nexus.event.blueprint.BaseEventBlueprint;
import com.mememan.nexus.event.listener.EventListener;
import com.mememan.nexus.event.object.BaseEvent;
import com.mememan.nexus.event.result.EventResult;
import com.mememan.nexus.loader.ModSide;
import com.mememan.nexus.util.ReflectionUtil;
import it.unimi.dsi.fastutil.booleans.BooleanObjectMutablePair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class PropagatingEventBlueprint<BE extends BaseEvent, R>
extends BaseEventBlueprint<BE, R> {
    protected static final Map<Class<? extends BaseEvent>, BooleanObjectMutablePair<Map<Class<? extends BaseEvent>, List<EventListener<?, ?>>>>> RAW_EVENT_SUPERCLASS_LISTENERS = new Object2ObjectOpenHashMap();

    protected PropagatingEventBlueprint(Class<BE> eventInterface, R defaultResult, boolean isCancellable, ModSide eventSide) {
        super(eventInterface, defaultResult, isCancellable, eventSide);
    }

    @Override
    public void onEvent(EventListener<BE, R> listener, int listenerPriority) {
        super.onEvent(listener, listenerPriority);
    }

    @Override
    public <U> U fireEvent(Function<EventListener<BE, R>, U> eventMapper, ModSide firingSide) {
        U result;
        Class eventSuperclass = this.eventInterface.getSuperclass();
        AtomicBoolean cancelledThroughPropagation = new AtomicBoolean(false);
        AtomicBoolean shortCircuitedThroughPropagation = new AtomicBoolean(false);
        AtomicReference<Object> mutResult = new AtomicReference<Object>(this.defaultResult);
        while (BaseEvent.class.isAssignableFrom(eventSuperclass)) {
            Optional potentiallyMappedBlueprint = PropagatingEventBlueprint.getBlueprintFor(eventSuperclass);
            Class eventSuperclassCopy = eventSuperclass;
            if (potentiallyMappedBlueprint.isPresent()) {
                BaseEventBlueprint inferredBlueprint = potentiallyMappedBlueprint.get();
                U parentResult = inferredBlueprint.fireEvent(eventMapper, firingSide);
                if (parentResult instanceof EventResult) {
                    EventResult parentEventResult = (EventResult)parentResult;
                    mutResult.set(this.mergeListenerResults(mutResult.get(), parentEventResult.actualResult()));
                    cancelledThroughPropagation.set(cancelledThroughPropagation.get() || parentEventResult.cancelled());
                    shortCircuitedThroughPropagation.set(shortCircuitedThroughPropagation.get() || parentEventResult.shortCircuit());
                }
                if (inferredBlueprint instanceof PropagatingEventBlueprint) {
                    break;
                }
            } else {
                BooleanObjectMutablePair superClazzListeners = RAW_EVENT_SUPERCLASS_LISTENERS.computeIfAbsent(this.getActualEventType(), oK -> new BooleanObjectMutablePair(true, (Object)new Object2ObjectOpenHashMap()));
                ((Map)superClazzListeners.right()).compute(eventSuperclassCopy, (eventSuperClazz, mappedListeners) -> {
                    if (mappedListeners != null && !superClazzListeners.leftBoolean()) {
                        return mappedListeners;
                    }
                    if (superClazzListeners.leftBoolean()) {
                        superClazzListeners.first(false);
                    }
                    return (List)this.getAllListeners().stream().filter(curListener -> ReflectionUtil.compareGenericInterfaceType(EventListener.class, eventSuperClazz)).collect(Collectors.toCollection(ObjectArrayList::new));
                }).forEach(listener -> {
                    Object propagatedResult = eventMapper.apply((EventListener<BE, R>)listener);
                    if (propagatedResult instanceof EventResult) {
                        EventResult eventResult = (EventResult)propagatedResult;
                        mutResult.set(this.mergeListenerResults(mutResult.get(), eventResult.actualResult()));
                        cancelledThroughPropagation.set(cancelledThroughPropagation.get() || eventResult.cancelled());
                        shortCircuitedThroughPropagation.set(shortCircuitedThroughPropagation.get() || eventResult.shortCircuit());
                    }
                });
            }
            eventSuperclass = eventSuperclass.getSuperclass();
        }
        if ((result = super.fireEvent(eventMapper, firingSide)) instanceof EventResult) {
            EventResult eventResult = (EventResult)result;
            return (U)new EventResult<Object>(this.mergeListenerResults(mutResult.get(), eventResult.actualResult()), eventResult.cancelled() || cancelledThroughPropagation.get(), eventResult.shortCircuit() || shortCircuitedThroughPropagation.get());
        }
        return result;
    }
}

