/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.event.blueprint;

import com.mememan.nexus.event.blueprint.EventBlueprint;
import com.mememan.nexus.event.listener.EventListener;
import com.mememan.nexus.event.result.EventResult;
import com.mememan.nexus.loader.ModSide;
import com.mememan.nexus.platform.NexusServices;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public abstract class WrappedEventBlueprint<T, R>
implements EventBlueprint<EventListener<T, R>> {
    protected final Class<T> eventInterface;
    protected final R defaultResult;
    protected final boolean isCancellable;
    protected final ModSide eventSide;

    protected WrappedEventBlueprint(Class<T> eventInterface, R defaultResult, boolean isCancellable, ModSide eventSide) {
        this.eventInterface = eventInterface;
        this.defaultResult = defaultResult;
        this.isCancellable = isCancellable;
        this.eventSide = eventSide;
        NexusServices.EVENT_BUS.registerEventHook(this);
    }

    @Override
    public Class<EventListener<T, R>> getEventInterface() {
        return EventListener.class;
    }

    @Override
    public Class<T> getActualEventType() {
        return this.eventInterface;
    }

    @Nullable
    public EventListener<T, R> mergeListeners(EventListener<T, R>[] existingListeners) {
        return listener -> {
            R curResult = this.defaultResult;
            boolean cancelled = false;
            for (EventListener existingListener : existingListeners) {
                EventResult listenerResult = existingListener.getResult(listener);
                curResult = this.mergeListenerResults(curResult, listenerResult.actualResult());
                if (this.isCancellable() && (cancelled |= listenerResult.cancelled()) && listenerResult.shortCircuit()) break;
            }
            return new EventResult<R>(curResult, cancelled);
        };
    }

    protected abstract R mergeListenerResults(R var1, R var2);

    @Override
    public ModSide getEventSide() {
        return this.eventSide;
    }

    @Override
    public <U> U fireEvent(Function<EventListener<T, R>, U> eventMapper) {
        return EventBlueprint.super.fireEvent(eventMapper);
    }

    @Override
    public <U> U fireEvent(Function<EventListener<T, R>, U> eventMapper, ModSide firingSide) {
        U eventResult = EventBlueprint.super.fireEvent(eventMapper, firingSide);
        return (U)(eventResult == null ? EventResult.pass() : eventResult);
    }

    public boolean isCancellable() {
        return this.isCancellable;
    }
}

