/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.event.result;

import java.util.function.Consumer;

public record EventResult<R>(R actualResult, boolean cancelled, boolean shortCircuit) {
    public EventResult(R actualResult, boolean cancelled) {
        this(actualResult, cancelled, false);
    }

    public static <R> EventResult<R> cancelled(R actualResult, boolean shortCircuit) {
        return new EventResult<R>(actualResult, true, shortCircuit);
    }

    public static <R> EventResult<R> cancelled(R actualResult) {
        return new EventResult<R>(actualResult, true);
    }

    public static <R> EventResult<R> success(R actualResult) {
        return new EventResult<R>(actualResult, false);
    }

    public static <R> EventResult<R> pass() {
        return new EventResult<Object>(null, false);
    }

    public void ifCancelled(Consumer<R> actionOnCancellation) {
        if (this.cancelled) {
            actionOnCancellation.accept(this.actualResult);
        }
    }

    public void ifTerminated(Consumer<R> actionOnTermination) {
        if (this.cancelled && this.shortCircuit) {
            actionOnTermination.accept(this.actualResult);
        }
    }

    public void ifSuccessful(Consumer<R> actionOnSuccess) {
        if (!this.cancelled) {
            actionOnSuccess.accept(this.actualResult);
        }
    }

    public void ifShortCircuit(Consumer<R> actionOnShortCircuit) {
        if (this.shortCircuit) {
            actionOnShortCircuit.accept(this.actualResult);
        }
    }
}

