/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.event.client;

import com.mememan.nexus.client.block.WrappedBlockColor;
import com.mememan.nexus.client.block_entity.BlockEntityClientData;
import com.mememan.nexus.client.block_entity.BlockEntitySheetData;
import com.mememan.nexus.client.entity.EntityClientData;
import com.mememan.nexus.client.item.WrappedClampedItemPropertyFunction;
import com.mememan.nexus.client.item.WrappedItemColor;
import com.mememan.nexus.internal.services.ForgeRegistrar;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.specialised.vanilla.VanillaBasedPropertyWrapper;
import com.mememan.nexus.property_wrapper.def.block.BlockPropertyWrapper;
import com.mememan.nexus.property_wrapper.def.block_entity.BlockEntityTypePropertyWrapper;
import com.mememan.nexus.property_wrapper.def.entity.EntityTypePropertyWrapper;
import com.mememan.nexus.property_wrapper.def.item.ItemPropertyWrapper;
import com.mememan.nexus.util.ClientUtil;
import it.unimi.dsi.fastutil.Pair;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.jetbrains.annotations.Nullable;

public class NexusForgeClientSetupEvents {
    @SubscribeEvent
    public static void onFMLClientSetupEvent(FMLClientSetupEvent event) {
        PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(ItemPropertyWrapper.class).stream().map(curPW -> (ItemPropertyWrapper)curPW).forEach(curPW -> {
            Supplier itemSupEntry = curPW.getParentObject();
            Map<ResourceLocation, WrappedClampedItemPropertyFunction> targetItemModelPredicates = curPW.getItemModelPredicates();
            if (!targetItemModelPredicates.isEmpty()) {
                targetItemModelPredicates.forEach((curName, curFunc) -> {
                    ClampedItemPropertyFunction clampedPropertyFunc = ClientUtil.toClampedItemPropertyFunction(curFunc);
                    if (clampedPropertyFunc != null) {
                        ItemProperties.register((Item)((Item)itemSupEntry.get()), (ResourceLocation)curName, (ItemPropertyFunction)clampedPropertyFunc);
                    }
                });
            }
        });
        PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(BlockEntityTypePropertyWrapper.class).stream().map(curPW -> (BlockEntityTypePropertyWrapper)curPW).filter(curPW -> curPW.getBlockEntityClientData().filter(curClientData -> curClientData.get() != null).isPresent()).forEach(NexusForgeClientSetupEvents::registerBlockEntitySheetData);
    }

    @SubscribeEvent
    public static void onRegisterEntityRenderersEvent(EntityRenderersEvent.RegisterRenderers event) {
        PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(EntityTypePropertyWrapper.class).stream().map(curPW -> (EntityTypePropertyWrapper)curPW).filter(curPW -> curPW.getEntityClientData().filter(curClientData -> curClientData.get() != null).isPresent()).forEach(curPW -> NexusForgeClientSetupEvents.registerEntityRenderer(curPW, event));
        PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(BlockEntityTypePropertyWrapper.class).stream().map(curPW -> (BlockEntityTypePropertyWrapper)curPW).filter(curPW -> curPW.getBlockEntityClientData().filter(curClientData -> curClientData.get() != null).isPresent()).forEach(curPW -> NexusForgeClientSetupEvents.registerBlockEntityRenderer(curPW, event));
    }

    @SubscribeEvent
    public static void onRegisterLayerDefinitionsEvent(EntityRenderersEvent.RegisterLayerDefinitions event) {
        PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(EntityTypePropertyWrapper.class).stream().map(curPW -> (EntityTypePropertyWrapper)curPW).filter(curPW -> curPW.getEntityClientData().filter(curClientData -> curClientData.get() != null).isPresent()).forEach(curPW -> NexusForgeClientSetupEvents.registerEntityModelLayerDefinitions(curPW, event));
        PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(BlockEntityTypePropertyWrapper.class).stream().map(curPW -> (BlockEntityTypePropertyWrapper)curPW).filter(curPW -> curPW.getBlockEntityClientData().filter(curClientData -> curClientData.get() != null).isPresent()).forEach(curPW -> NexusForgeClientSetupEvents.registerBlockEntityModelLayerDefinitions(curPW, event));
    }

    @SubscribeEvent
    public static void onRegisterBlockColorHandlersEvent(RegisterColorHandlersEvent.Block event) {
        PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(BlockPropertyWrapper.class).stream().map(curPW -> (BlockPropertyWrapper)curPW).forEach(curPW -> {
            Supplier parentBlockSup = curPW.getParentObject();
            Block parentBlock = (Block)parentBlockSup.get();
            curPW.getBlockColorMapper().ifPresent(curMapper -> {
                BlockColor mappedBlockColor = ClientUtil.toBlockColor((WrappedBlockColor)curMapper.apply(parentBlockSup));
                if (mappedBlockColor != null) {
                    event.register(mappedBlockColor, new Block[]{parentBlock});
                }
            });
        });
    }

    @SubscribeEvent
    public static void onRegisterItemColorHandlersEvent(RegisterColorHandlersEvent.Item event) {
        PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(VanillaBasedPropertyWrapper.class).stream().map(curPW -> (VanillaBasedPropertyWrapper)curPW).forEach(curPW -> {
            if (curPW instanceof BlockPropertyWrapper) {
                BlockPropertyWrapper curBPW = (BlockPropertyWrapper)curPW;
                NexusForgeClientSetupEvents.registerBlockItemColorProvider(curBPW, event);
            }
            if (curPW instanceof ItemPropertyWrapper) {
                ItemPropertyWrapper curIPW = (ItemPropertyWrapper)curPW;
                NexusForgeClientSetupEvents.registerItemColorProvider(curIPW, event);
            }
        });
    }

    @SubscribeEvent
    public static void onRegisterClientReloadListenersEvent(RegisterClientReloadListenersEvent event) {
        ForgeRegistrar.getCachedResourceReloadListeners().values().stream().filter(curListenerPair -> ((Optional)curListenerPair.second()).map(curListenerConfig -> curListenerConfig.listenerPackType() == PackType.CLIENT_RESOURCES).orElse(false)).map(Pair::first).forEach(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0));
    }

    private static <B extends Block> void registerBlockItemColorProvider(BlockPropertyWrapper<B> targetBPW, RegisterColorHandlersEvent.Item itemRegEvent) {
        Supplier parentBlockSup = targetBPW.getParentObject();
        Block parentBlock = (Block)parentBlockSup.get();
        targetBPW.getBlockColorMapper().ifPresent(curMapper -> {
            BlockColor mappedBlockColor = ClientUtil.toBlockColor((WrappedBlockColor)curMapper.apply(parentBlockSup));
            if (mappedBlockColor != null) {
                itemRegEvent.register((curStack, tintIdx) -> itemRegEvent.getBlockColors().m_92577_(parentBlock.m_49966_(), null, null, tintIdx), new ItemLike[]{parentBlock});
            }
        });
    }

    private static <I extends Item> void registerItemColorProvider(ItemPropertyWrapper<I> targetIPW, RegisterColorHandlersEvent.Item itemRegEvent) {
        Supplier parentItemSup = targetIPW.getParentObject();
        Item parentItem = (Item)parentItemSup.get();
        targetIPW.getItemColorMapper().ifPresent(curMapper -> {
            ItemColor mappedItemColor = ClientUtil.toItemColor((WrappedItemColor)curMapper.apply(parentItemSup));
            if (mappedItemColor != null) {
                itemRegEvent.register(mappedItemColor, new ItemLike[]{parentItem});
            }
        });
    }

    private static <E extends Entity> void registerEntityRenderer(EntityTypePropertyWrapper<E> targetETPW, EntityRenderersEvent.RegisterRenderers event) {
        targetETPW.getEntityClientData().ifPresent(curClientData -> {
            Function entityRendererMapper;
            EntityClientData clientData = (EntityClientData)curClientData.get();
            if (clientData != null && (entityRendererMapper = clientData.entityRendererMapper()) != null) {
                event.registerEntityRenderer((EntityType)targetETPW.getParentObject().get(), entityRendererMapper::apply);
            }
        });
    }

    private static <BE extends BlockEntity> void registerBlockEntityRenderer(BlockEntityTypePropertyWrapper<BE> targetBEPW, EntityRenderersEvent.RegisterRenderers event) {
        targetBEPW.getBlockEntityClientData().ifPresent(curClientData -> {
            Function blockEntityRendererMapper;
            BlockEntityClientData clientData = (BlockEntityClientData)curClientData.get();
            if (clientData != null && (blockEntityRendererMapper = clientData.blockEntityRendererMapper()) != null) {
                event.registerBlockEntityRenderer((BlockEntityType)targetBEPW.getParentObject().get(), blockEntityRendererMapper::apply);
            }
        });
    }

    private static <BE extends BlockEntity> void registerBlockEntitySheetData(BlockEntityTypePropertyWrapper<BE> targetBEPW) {
        targetBEPW.getBlockEntityClientData().ifPresent(curClientData -> {
            BlockEntityClientData clientData = (BlockEntityClientData)curClientData.get();
            if (clientData != null) {
                Supplier parentObj = targetBEPW.getParentObject();
                @Nullable Function<Supplier<BlockEntityType<BE>>, Collection<BlockEntitySheetData>> blockEntitySheetDataMapper = clientData.blockEntitySheetDataMapper();
                if (blockEntitySheetDataMapper != null) {
                    Collection<BlockEntitySheetData> collectedMappedSheetData = blockEntitySheetDataMapper.apply(parentObj);
                    collectedMappedSheetData.forEach(mappedSheetData -> {
                        WoodType signWoodType = mappedSheetData.signWoodType();
                        WoodType hangingSignWoodType = mappedSheetData.hangingSignWoodType();
                        ResourceKey<BannerPattern> bannerPatternKey = mappedSheetData.bannerPatternKey();
                        ResourceKey<BannerPattern> shieldPatternKey = mappedSheetData.shieldPatternKey();
                        ResourceKey<String> decoratedPotMaterialName = mappedSheetData.decoratedPotMaterialName();
                        if (signWoodType != null) {
                            Sheets.f_110743_.put(signWoodType, ClientUtil.createSignMaterial(signWoodType));
                        }
                        if (hangingSignWoodType != null) {
                            Sheets.f_244291_.put(hangingSignWoodType, ClientUtil.createHangingSignMaterial(hangingSignWoodType));
                        }
                        if (bannerPatternKey != null) {
                            Sheets.f_173376_.put(bannerPatternKey, ClientUtil.createBannerMaterial(bannerPatternKey));
                        }
                        if (shieldPatternKey != null) {
                            Sheets.f_173377_.put(shieldPatternKey, ClientUtil.createShieldMaterial(shieldPatternKey));
                        }
                        if (decoratedPotMaterialName != null) {
                            Sheets.f_271486_.put(decoratedPotMaterialName, ClientUtil.createDecoratedPotMaterial(decoratedPotMaterialName));
                        }
                    });
                }
            }
        });
    }

    private static <E extends Entity> void registerEntityModelLayerDefinitions(EntityTypePropertyWrapper<E> targetETPW, EntityRenderersEvent.RegisterLayerDefinitions event) {
        targetETPW.getEntityClientData().ifPresent(curClientData -> {
            Function mappedLayerDefSup;
            EntityClientData clientData = (EntityClientData)curClientData.get();
            if (clientData != null && (mappedLayerDefSup = clientData.modelLayerDefinitionMapper()) != null) {
                Pair<Collection<ModelLayerLocation>, LayerDefinition> mappedModelLayerDef = mappedLayerDefSup.apply(targetETPW.getParentObject());
                Collection layerLocs = (Collection)mappedModelLayerDef.left();
                LayerDefinition layerDef = (LayerDefinition)mappedModelLayerDef.right();
                if (layerLocs != null && layerDef != null && !layerLocs.isEmpty()) {
                    layerLocs.forEach(layerLoc -> event.registerLayerDefinition(layerLoc, () -> layerDef));
                }
            }
        });
    }

    private static <BE extends BlockEntity> void registerBlockEntityModelLayerDefinitions(BlockEntityTypePropertyWrapper<BE> targetBETPW, EntityRenderersEvent.RegisterLayerDefinitions event) {
        targetBETPW.getBlockEntityClientData().ifPresent(curClientData -> {
            Supplier<Pair<Collection<ModelLayerLocation>, LayerDefinition>> mappedLayerDefSup;
            BlockEntityClientData clientData = (BlockEntityClientData)curClientData.get();
            if (clientData != null && (mappedLayerDefSup = clientData.mappedModelLayerDefinitions()) != null && mappedLayerDefSup.get() != null) {
                Pair<Collection<ModelLayerLocation>, LayerDefinition> mappedModelLayerDef = mappedLayerDefSup.get();
                Collection layerLocs = (Collection)mappedModelLayerDef.left();
                LayerDefinition layerDef = (LayerDefinition)mappedModelLayerDef.right();
                if (layerLocs != null && layerDef != null && !layerLocs.isEmpty()) {
                    layerLocs.forEach(layerLoc -> event.registerLayerDefinition(layerLoc, () -> layerDef));
                }
            }
        });
    }
}

