/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.event.common;

import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.internal.network.packets.s2c.DatapackEntriesSyncPacket;
import com.mememan.nexus.internal.services.ForgeRegistrar;
import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.specialised.vanilla.VanillaBasedPropertyWrapper;
import com.mememan.nexus.property_wrapper.def.block.BlockPropertyWrapper;
import com.mememan.nexus.property_wrapper.def.tag.TagPropertyWrapper;
import com.mememan.nexus.resource.config.ResourceReloadListenerConfig;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NexusForgeCommonMiscEvents {
    private static final Object2ObjectOpenHashMap<ToolAction, Object2ObjectOpenHashMap<Block, Function<BlockState, BlockState>>> CACHED_BLOCK_TOOL_ACTIONS = (Object2ObjectOpenHashMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), toolActionMap -> PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(BlockPropertyWrapper.class).stream().map(curPW -> (BlockPropertyWrapper)curPW).forEach(curBPW -> {
        Supplier parentBlockSup = curBPW.getParentObject();
        Block parentBlock = (Block)parentBlockSup.get();
        curBPW.getBlockStrippingMapper().ifPresent(strippedBlockMapper -> ((Object2ObjectOpenHashMap)toolActionMap.computeIfAbsent((Object)ToolActions.AXE_STRIP, axeStripAction -> new Object2ObjectOpenHashMap())).put((Object)parentBlock, strippedBlockMapper));
        curBPW.getBlockFlatteningMapper().ifPresent(flatteningMapper -> ((Object2ObjectOpenHashMap)toolActionMap.computeIfAbsent((Object)ToolActions.SHOVEL_FLATTEN, shovelFlattenAction -> new Object2ObjectOpenHashMap())).put((Object)parentBlock, flatteningMapper));
    }));
    private static final Object2IntOpenHashMap<Item> CACHED_FUEL_TIME = (Object2IntOpenHashMap)Util.m_137469_((Object)new Object2IntOpenHashMap(), fuelTimeMap -> PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(VanillaBasedPropertyWrapper.class).stream().map(curPW -> (VanillaBasedPropertyWrapper)curPW).forEach(curPW -> curPW.getFuelMapper().ifPresent(fuelMapper -> {
        Supplier parentItemLikeSup = curPW.getParentObject();
        Item parentItem = ((ItemLike)parentItemLikeSup.get()).m_5456_();
        if (!parentItem.m_7968_().m_41619_()) {
            fuelTimeMap.put((Object)parentItem, Math.abs((Integer)fuelMapper.apply(parentItemLikeSup)));
        }
    })));
    private static final Object2IntOpenHashMap<Item> CACHED_FUEL_TIME_BY_TAG = new Object2IntOpenHashMap();
    private static final ObjectArrayList<PreparableReloadListener> CACHED_RESOURCE_RELOAD_LISTENERS = (ObjectArrayList)Util.m_137469_((Object)new ObjectArrayList(), resourceReloadListenerList -> ForgeRegistrar.getCachedResourceReloadListeners().values().stream().filter(curListenerPair -> ((Optional)curListenerPair.second()).map(curListenerConfig -> curListenerConfig.listenerPackType() == PackType.SERVER_DATA).orElse(false)).map(Pair::first).forEach(arg_0 -> ((ObjectArrayList)resourceReloadListenerList).add(arg_0)));
    private static final Object2ObjectOpenHashMap<ResourceLocation, Pair<PreparableReloadListener, ResourceReloadListenerConfig<PreparableReloadListener>>> CACHED_SYNCABLE_RESOURCE_RELOAD_LISTENERS = (Object2ObjectOpenHashMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), syncableResourceReloadListenerMap -> ForgeRegistrar.getCachedResourceReloadListeners().entrySet().stream().filter(curListenerEntry -> ((Optional)((Pair)curListenerEntry.getValue()).second()).map(curListenerConfig -> curListenerConfig.listenerPackType() == PackType.SERVER_DATA && curListenerConfig.shouldSyncToClient()).orElse(false)).forEach(curListenerEntry -> syncableResourceReloadListenerMap.putIfAbsent((Object)((ResourceLocation)curListenerEntry.getKey()), (Object)ObjectObjectImmutablePair.of((Object)((PreparableReloadListener)((Pair)curListenerEntry.getValue()).first()), (Object)((ResourceReloadListenerConfig)((Optional)((Pair)curListenerEntry.getValue()).second()).get())))));
    public static final Object2ObjectOpenHashMap<Block, IntIntMutablePair> CACHED_FLAMMABILITY_BY_TAG = new Object2ObjectOpenHashMap();
    public static final Object2ObjectOpenHashMap<Block, Function<Supplier<Block>, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>>> CACHED_BLOCK_TILLING_BEHAVIOURS = (Object2ObjectOpenHashMap)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), tillingBehaviourMap -> PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(BlockPropertyWrapper.class).stream().map(curPW -> (BlockPropertyWrapper)curPW).forEach(curBPW -> {
        Supplier parentBlockSup = curBPW.getParentObject();
        Block parentBlock = (Block)parentBlockSup.get();
        curBPW.getBlockTillingMapper().ifPresent(tillingMapper -> tillingBehaviourMap.put((Object)parentBlock, tillingMapper));
    }));

    @SubscribeEvent
    public static void onTagsUpdatedEvent(TagsUpdatedEvent event) {
        CACHED_FUEL_TIME_BY_TAG.clear();
        CACHED_FLAMMABILITY_BY_TAG.clear();
        PropertyWrapper.PropertyWrappersContainer.getInferrableWrappersOfType(TagPropertyWrapper.class).stream().map(curPW -> (TagPropertyWrapper)curPW).forEach(curPW -> {
            TagKey parentTagKey = (TagKey)curPW.getParentObject().get();
            curPW.getCookTime().filter(curPair -> parentTagKey.m_207645_(Registries.f_256747_) || parentTagKey.m_207645_(Registries.f_256913_)).ifPresent(cookTime -> {
                if (parentTagKey.m_207645_(Registries.f_256747_)) {
                    BuiltInRegistries.f_256975_.m_206058_(parentTagKey).forEach(curBlockHolder -> {
                        Item curBlockItem = ((Block)curBlockHolder.m_203334_()).m_5456_();
                        if (!curBlockItem.m_7968_().m_41619_()) {
                            CACHED_FUEL_TIME_BY_TAG.put((Object)curBlockItem, Math.abs(cookTime));
                        }
                    });
                } else {
                    BuiltInRegistries.f_257033_.m_206058_(parentTagKey).forEach(curItemHolder -> CACHED_FUEL_TIME_BY_TAG.put((Object)((Item)curItemHolder.m_203334_()), Math.abs(cookTime)));
                }
            });
            curPW.getFlammabilityPair().filter(curPair -> parentTagKey.m_207645_(Registries.f_256747_)).ifPresent(flammabilityPair -> BuiltInRegistries.f_256975_.m_206058_(parentTagKey).forEach(curBlockHolder -> CACHED_FLAMMABILITY_BY_TAG.put((Object)((Block)curBlockHolder.m_203334_()), flammabilityPair)));
        });
    }

    @SubscribeEvent
    public static void onBlockToolModificationEvent(BlockEvent.BlockToolModificationEvent event) {
        BlockState transformedState;
        BlockState curState;
        Block initialBlock;
        Function stateTransformer;
        ToolAction stateTransformationAction = event.getToolAction();
        if (stateTransformationAction == null) {
            return;
        }
        Object2ObjectOpenHashMap toolActionMap = (Object2ObjectOpenHashMap)CACHED_BLOCK_TOOL_ACTIONS.get((Object)stateTransformationAction);
        if (toolActionMap != null && !toolActionMap.isEmpty() && (stateTransformer = (Function)toolActionMap.get((Object)(initialBlock = (curState = event.getState()).m_60734_()))) != null && (transformedState = (BlockState)stateTransformer.apply(curState)) != null) {
            event.setFinalState(transformedState);
        }
    }

    @SubscribeEvent
    public static void onFurnaceFuelBurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        Item targetItem = event.getItemStack().m_41720_();
        int cookTime = CACHED_FUEL_TIME.getOrDefault((Object)targetItem, CACHED_FUEL_TIME_BY_TAG.getOrDefault((Object)targetItem, 0));
        if (cookTime != 0) {
            event.setBurnTime(cookTime);
        }
    }

    @SubscribeEvent
    public static void onAddReloadListenerEvent(AddReloadListenerEvent event) {
        CACHED_RESOURCE_RELOAD_LISTENERS.forEach(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
    }

    @SubscribeEvent
    public static void onDatapackSyncEvent(OnDatapackSyncEvent event) {
        ServerPlayer primaryPlayer = event.getPlayer();
        CACHED_SYNCABLE_RESOURCE_RELOAD_LISTENERS.forEach((curListenerId, curListenerPair) -> {
            PreparableReloadListener listener = (PreparableReloadListener)curListenerPair.first();
            ResourceReloadListenerConfig listenerConfig = (ResourceReloadListenerConfig)curListenerPair.second();
            Optional listenerDataMapper = listenerConfig.dataMapGetter();
            listenerDataMapper.ifPresentOrElse(dataMapper -> {
                DatapackEntriesSyncPacket syncPacket = new DatapackEntriesSyncPacket((ResourceLocation)curListenerId, (Map)dataMapper.apply(listener));
                if (primaryPlayer != null) {
                    NexusServices.NETWORK_MANAGER.sendToClient(syncPacket, primaryPlayer);
                } else {
                    NexusServices.NETWORK_MANAGER.sendToAllClients(syncPacket);
                }
            }, () -> NexusConstants.LOGGER.warn("Skipping syncable resource reload listener of id '{}' due to missing data mapper.", curListenerId));
        });
    }
}

