/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.event.custom;

import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.function.Function;

public class ForgeEventWrapper<T> {
    protected final Class<? super T> eventInterface;
    protected final Function<T[], T> listenerResultMerger;
    protected final Map<Integer, T[]> listeners;
    protected final Object lock = new Object();
    protected volatile T invoker;

    public ForgeEventWrapper(Class<? super T> eventInterface, Function<T[], T> listenerResultMerger) {
        this.eventInterface = eventInterface;
        this.listenerResultMerger = listenerResultMerger;
        this.listeners = new Int2ObjectAVLTreeMap();
        this.invoker = ForgeEventWrapper.createEmptyInvoker(eventInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(T listener, int priority) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.compute(priority, (curPriority, potentialListenerArray) -> {
                if (potentialListenerArray != null) {
                    int curListenerArrayLength = ((Object[])potentialListenerArray).length;
                    Object[] newListenerArray = (Object[])Array.newInstance(this.eventInterface, curListenerArrayLength + 1);
                    System.arraycopy(potentialListenerArray, 0, newListenerArray, 0, curListenerArrayLength);
                    newListenerArray[curListenerArrayLength] = listener;
                    return newListenerArray;
                }
                Object[] newListenerArray = (Object[])Array.newInstance(this.eventInterface, 1);
                newListenerArray[0] = listener;
                return newListenerArray;
            });
            Object[] allListeners = (Object[])Array.newInstance(this.eventInterface, this.listeners.values().stream().mapToInt(lis -> ((Object[])lis).length).sum());
            int listenerIndex = 0;
            for (T[] priorityListeners : this.listeners.values()) {
                System.arraycopy(priorityListeners, 0, allListeners, listenerIndex, priorityListeners.length);
                listenerIndex += priorityListeners.length;
            }
            this.invoker = this.listenerResultMerger.apply((Object[][])allListeners);
        }
    }

    public T invoker() {
        return this.invoker;
    }

    public static <T> T createEmptyInvoker(Class<? super T> targetFunctionalInterface) {
        try {
            Method method = targetFunctionalInterface.getDeclaredMethods()[0];
            Class<?> returnType = method.getReturnType();
            return targetFunctionalInterface.cast(Proxy.newProxyInstance(targetFunctionalInterface.getClassLoader(), new Class[]{targetFunctionalInterface}, (proxy, m, args) -> {
                if (returnType == Boolean.TYPE) {
                    return false;
                }
                if (returnType == Void.TYPE) {
                    return null;
                }
                if (returnType.isPrimitive()) {
                    return 0;
                }
                return null;
            }));
        }
        catch (Throwable t) {
            throw new RuntimeException(String.format("Failed to create empty invoker for type: %s", targetFunctionalInterface.getName()), t);
        }
    }
}

