/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.loader;

import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.loader.GamePathWrapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgeGamePathWrapper
extends GamePathWrapper {
    public ForgeGamePathWrapper() {
        super(() -> ((FMLPaths)FMLPaths.GAMEDIR).get());
    }

    @Override
    public Path getOrCreatePath(Path nestedPath) {
        return FMLPaths.getOrCreateGameRelativePath((Path)nestedPath);
    }

    @Override
    public void deletePath(Path targetNestedPath) {
        Path targetPath = this.getGameDir().resolve(targetNestedPath);
        try {
            if (Files.deleteIfExists(targetPath)) {
                NexusConstants.LOGGER.debug("Successfully deleted path: {}", (Object)targetPath);
            }
        }
        catch (IOException e) {
            NexusConstants.LOGGER.error("Failed to delete path: {}", (Object)targetPath, (Object)e);
        }
    }
}

