/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.loader;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.asm.ClassFinder;
import com.mememan.nexus.loader.ModData;
import com.mememan.nexus.loader.ModMetadata;
import com.mememan.nexus.loader.ModSide;
import cpw.mods.jarhandling.SecureJar;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeModData
implements ModData {
    private final IModInfo ownerModInfo;
    private final ModMetadata ownerModMetadata;
    private final ObjectArrayList<String> allFilePaths;
    private final ConcurrentHashMap<String, ObjectArrayList<String>> cachedAnnotatedClasses = new ConcurrentHashMap();

    public ForgeModData(IModInfo targetMod) {
        long startTime = System.currentTimeMillis();
        this.ownerModInfo = targetMod;
        String authorInput = targetMod.getConfig().getConfigElement(new String[]{"authors"}).orElse(targetMod.getConfig().getConfigElement(new String[]{"credits"}).orElse("None"));
        ObjectArrayList dependencies = targetMod.getDependencies().isEmpty() ? ObjectArrayList.of() : targetMod.getDependencies().stream().map(curVersion -> {
            TreeRangeSet depVersions = TreeRangeSet.create();
            if (!curVersion.getVersionRange().getRestrictions().isEmpty()) {
                if (curVersion.getVersionRange() == IModInfo.UNBOUNDED) {
                    depVersions.add(Range.all());
                } else {
                    curVersion.getVersionRange().getRestrictions().stream().map(curRestriction -> curRestriction.getLowerBound() == null && curRestriction.getUpperBound() == null ? null : (curRestriction.getLowerBound() == null ? Range.atMost((Comparable)((Object)curRestriction.getUpperBound().toString())) : (curRestriction.getUpperBound() == null ? Range.atLeast((Comparable)((Object)curRestriction.getLowerBound().toString())) : Range.closed((Comparable)((Object)curRestriction.getLowerBound().toString()), (Comparable)((Object)curRestriction.getUpperBound().toString()))))).filter(Objects::nonNull).forEach(arg_0 -> ((RangeSet)depVersions).add(arg_0));
                }
            }
            return Triple.of((Object)curVersion.getModId(), (Object)depVersions, (Object)curVersion.isMandatory());
        }).collect(Collectors.toCollection(ObjectArrayList::new));
        this.ownerModMetadata = new ModMetadata(targetMod.getModId(), targetMod.getDisplayName(), targetMod.getVersion().getQualifier(), this.ownerModInfo.getOwningFile().getLicense(), targetMod.getDescription(), (List<String>)ObjectArrayList.of((Object[])(authorInput.contains(",") ? authorInput.split(",") : authorInput.split("\\s+"))), (List<Triple<String, RangeSet<String>, Boolean>>)dependencies, targetMod.getConfig().getConfigElement(new String[]{"clientSideOnly"}).orElse(false) != false ? ModSide.CLIENT : ModSide.COMMON);
        this.allFilePaths = this.mapAllFilePaths(this.ownerModInfo.getOwningFile().getFile().getSecureJar());
        this.ownerModInfo.getOwningFile().getFile().getScanResult().getAnnotations().forEach(curAnnotData -> this.cachedAnnotatedClasses.computeIfAbsent(curAnnotData.annotationType().getClassName().replace('/', '.'), oK -> new ObjectArrayList()).add((Object)curAnnotData.clazz().getClassName().replace('/', '.')));
        long endTime = System.currentTimeMillis();
        long milliDuration = endTime - startTime;
        NexusConstants.LOGGER.info("Loaded mod data for mod {} (within file {}) in {} ms", new Object[]{targetMod.getModId(), targetMod.getOwningFile().getFile().getFileName(), milliDuration});
    }

    public IModInfo getOwnerModInfo() {
        return this.ownerModInfo;
    }

    public ObjectArrayList<String> mapAllFilePaths(SecureJar targetJar) {
        ObjectArrayList objectArrayList;
        block8: {
            Stream<Path> rootJarStream = Files.walk(targetJar.getRootPath(), new FileVisitOption[0]);
            try {
                objectArrayList = rootJarStream.filter(curPath -> curPath.getNameCount() > 0).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(curPath -> curPath.toString().endsWith(".class") ? curPath.toString().replace('/', '.') : curPath.toString()).filter(pkg -> !pkg.isEmpty()).collect(Collectors.toCollection(ObjectArrayList::new));
                if (rootJarStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rootJarStream != null) {
                        try {
                            rootJarStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    NexusConstants.LOGGER.error("Failed to map paths for SecureJar: {}", (Object)targetJar.name(), (Object)e);
                    return ObjectArrayList.of();
                }
            }
            rootJarStream.close();
        }
        return objectArrayList;
    }

    @Override
    @NotNull
    public ModMetadata getModMetadata() {
        return this.ownerModMetadata;
    }

    public ObjectArrayList<String> getAllFilePaths() {
        return this.allFilePaths;
    }

    @Override
    public ConcurrentHashMap<String, ObjectArrayList<String>> getCachedAnnotatedClasses() {
        return this.cachedAnnotatedClasses;
    }

    @Override
    public List<Class<?>> discoverAnnotatedClasses(Class<? extends Annotation> annotationTypeClazz, @Nullable Comparator<String> classLoadingSorter, @Nullable Consumer<String> beforeClassInitConsumer) {
        String formattedAnnotationName = "L" + annotationTypeClazz.getName().replace('.', '/') + ";";
        return this.cachedAnnotatedClasses.get(formattedAnnotationName) == null ? ObjectArrayList.of() : (List)this.cachedAnnotatedClasses.get(formattedAnnotationName).stream().sorted(classLoadingSorter != null ? classLoadingSorter : String::compareTo).peek(name -> {
            if (beforeClassInitConsumer != null) {
                beforeClassInitConsumer.accept((String)name);
            }
        }).map(ClassFinder::forName).collect(Collectors.toCollection(ObjectArrayList::new));
    }
}

