/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.network.packets.s2c;

import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.network.PacketContext;
import com.mememan.nexus.platform.NexusServices;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;

public class DatapackEntriesSyncPacket<T> {
    private final ResourceLocation listenerId;
    private final Map<ResourceLocation, T> entriesToSync;

    public DatapackEntriesSyncPacket(ResourceLocation listenerId, Map<ResourceLocation, T> entriesToSync) {
        this.listenerId = listenerId;
        this.entriesToSync = entriesToSync;
    }

    public static <T> DatapackEntriesSyncPacket<T> decode(FriendlyByteBuf buf) {
        ResourceLocation listenerId = buf.m_130281_();
        return new DatapackEntriesSyncPacket<T>(listenerId, buf.m_236841_(Object2ObjectOpenHashMap::new, FriendlyByteBuf::m_130281_, localBuf -> localBuf.m_266466_((DynamicOps)NbtOps.f_128958_, DatapackEntriesSyncPacket.getCodecFromListenerById(listenerId))));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.listenerId);
        buf.m_236831_(this.entriesToSync, FriendlyByteBuf::m_130085_, (localBuf, value) -> localBuf.m_266332_((DynamicOps)NbtOps.f_128958_, DatapackEntriesSyncPacket.getCodecFromListenerById(this.listenerId), value));
    }

    public PacketContext handlePacket() {
        return (ownerPlayer, curLevel, curConnection, curSide) -> {
            Pair targetListenerPair = NexusServices.REGISTRAR.getMappedResourceReloadListeners().get(this.listenerId);
            PreparableReloadListener targetListenerConfig = (PreparableReloadListener)targetListenerPair.first();
            ((Optional)targetListenerPair.second()).ifPresentOrElse(reloadListenerConfig -> reloadListenerConfig.resourceSyncOperation().ifPresent(syncOp -> syncOp.accept(targetListenerConfig, this.entriesToSync)), () -> NexusConstants.LOGGER.warn("Somehow failed to run data syncing operation for listener of id '{}', listener config was unmapped/empty.", (Object)this.listenerId));
        };
    }

    protected static <T> Codec<T> getCodecFromListenerById(ResourceLocation listenerId) {
        Pair targetListenerPair = NexusServices.REGISTRAR.getMappedResourceReloadListeners().get(listenerId);
        return ((Optional)Optional.ofNullable(targetListenerPair).orElseThrow(() -> new IllegalArgumentException(String.format("Attempted to sync data for invalid listener of id '%s'", listenerId))).second()).map(curConfig -> {
            PackType targetPackType = curConfig.listenerPackType();
            boolean shouldSyncToClient = curConfig.shouldSyncToClient();
            if (targetPackType == PackType.CLIENT_RESOURCES || !shouldSyncToClient) {
                throw new IllegalArgumentException(String.format("Attempted to sync data for unsyncable reload listener of id '%s' (listener PackType is '%s', shouldSyncToClient is set to: %s)", listenerId, targetPackType, shouldSyncToClient));
            }
            return curConfig;
        }).orElseThrow(() -> new IllegalArgumentException(String.format("Attempted to sync data for unsyncable reload listener of id '%s'", listenerId))).dataCodecMapper().orElseThrow(() -> new IllegalArgumentException(String.format("Attempted to sync data for listener of id '%s' with no codec mapper", listenerId))).apply((PreparableReloadListener)targetListenerPair.first());
    }
}

