/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.services;

import com.mememan.nexus.asm.annotations.DatagenRegistrarEntry;
import com.mememan.nexus.datagen.DuplicateDataPolicy;
import com.mememan.nexus.datagen.ModDatagenConfig;
import com.mememan.nexus.datagen.ModSpecificPackOutput;
import com.mememan.nexus.datagen.NexusProviderTypes;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.datagen.standard.ModDataProvider;
import com.mememan.nexus.datagen.standard.data_pack.StandardDatapackRegistryProvider;
import com.mememan.nexus.datagen.standard.data_pack.StandardLootProvider;
import com.mememan.nexus.datagen.standard.data_pack.StandardRecipeProvider;
import com.mememan.nexus.datagen.standard.data_pack.StandardTagProvider;
import com.mememan.nexus.datagen.standard.resource_pack.StandardBlockStateProvider;
import com.mememan.nexus.datagen.standard.resource_pack.StandardLanguageProvider;
import com.mememan.nexus.datagen.standard.resource_pack.StandardModelProvider;
import com.mememan.nexus.loader.ModData;
import com.mememan.nexus.loader.ModSide;
import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.platform.services.DataGenerator;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

public class ForgeDataGenerator
implements DataGenerator {
    private static boolean hasConsumedGenerators = false;
    private static final AtomicReference<net.minecraft.data.DataGenerator> GLOBAL_DATA_GENERATOR_INSTANCE = new AtomicReference();
    private static final Queue<ObjectObjectImmutablePair<String, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, ? extends Pair<Boolean, ? extends DataProvider>>>> ENQUEUED_PROVIDERS = new ConcurrentLinkedQueue<ObjectObjectImmutablePair<String, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, ? extends Pair<Boolean, ? extends DataProvider>>>>();
    private static final Queue<ObjectObjectImmutablePair<String, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, ? extends ModDataProvider>>> ENQUEUED_MOD_PROVIDERS = new ConcurrentLinkedQueue<ObjectObjectImmutablePair<String, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, ? extends ModDataProvider>>>();
    private static final ObjectOpenCustomHashSet<ModDatagenConfig> MOD_DATAGEN_CONFIGS = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<ModDatagenConfig>(){

        public int hashCode(ModDatagenConfig o) {
            return Objects.hash(o.modId());
        }

        public boolean equals(ModDatagenConfig a, ModDatagenConfig b) {
            return a != null && b != null && Objects.equals(a.modId(), b.modId());
        }
    });

    @Override
    public void setupDataGenerator() {
        NexusServices.PLATFORM_MANAGER.discoverAnnotatedClasses(DatagenRegistrarEntry.class);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(ForgeDataGenerator::onGatherDataEvent);
    }

    @Override
    public <DP extends DataProvider> void registerDataProvider(String modId, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, Pair<Boolean, DP>> dataProvider) {
        ENQUEUED_PROVIDERS.add((ObjectObjectImmutablePair<String, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, ? extends Pair<Boolean, ? extends DataProvider>>>)ObjectObjectImmutablePair.of((Object)modId, dataProvider));
    }

    @Override
    public <MDP extends ModDataProvider> void registerModDataProvider(String modId, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, MDP> modDataProvider) {
        ENQUEUED_MOD_PROVIDERS.add((ObjectObjectImmutablePair<String, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, ? extends ModDataProvider>>)ObjectObjectImmutablePair.of((Object)modId, modDataProvider));
    }

    @Override
    public ModDatagenConfig registerConfigForMod(ModDatagenConfig modDatagenConfig) {
        MOD_DATAGEN_CONFIGS.add((Object)modDatagenConfig);
        return modDatagenConfig;
    }

    @Override
    public Set<ModDatagenConfig> getModDatagenConfigs() {
        return MOD_DATAGEN_CONFIGS;
    }

    @Override
    @Nullable
    public net.minecraft.data.DataGenerator getDataGenerator() {
        return GLOBAL_DATA_GENERATOR_INSTANCE.get();
    }

    public static boolean hasConsumedGenerators() {
        return hasConsumedGenerators;
    }

    private static void onGatherDataEvent(GatherDataEvent event) {
        net.minecraft.data.DataGenerator primaryGen = event.getGenerator();
        PackOutput rootPackOutput = primaryGen.getPackOutput();
        Path rootOutputPath = rootPackOutput.m_245114_();
        CompletableFuture regLookupProvider = event.getLookupProvider();
        boolean onClient = event.includeClient();
        boolean onServer = event.includeServer();
        if (!ForgeDataGenerator.hasConsumedGenerators()) {
            ModSpecificPackOutput modSpecificPackOutput;
            boolean allowDatagenForMod;
            ModDatagenConfig targetModConfig;
            String targetModId;
            ModData targetMod;
            GLOBAL_DATA_GENERATOR_INSTANCE.set(primaryGen);
            if (!ENQUEUED_MOD_PROVIDERS.isEmpty()) {
                ObjectObjectImmutablePair<String, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, ? extends ModDataProvider>> modProviderMapper;
                while ((modProviderMapper = ENQUEUED_MOD_PROVIDERS.poll()) != null) {
                    targetMod = NexusServices.PLATFORM_MANAGER.getModDataById((String)modProviderMapper.left());
                    targetModId = targetMod.getModMetadata().modId();
                    targetModConfig = NexusServices.DATA_GENERATOR.getConfigForMod(targetModId);
                    allowDatagenForMod = targetModConfig != null && targetModConfig.enableDatagen();
                    modSpecificPackOutput = new ModSpecificPackOutput(rootOutputPath, targetMod, allowDatagenForMod);
                    if (!allowDatagenForMod) continue;
                    ModDataProvider mappedModProvider = (ModDataProvider)((BiFunction)modProviderMapper.right()).apply(modSpecificPackOutput, regLookupProvider);
                    ProviderType mappedModProviderType = mappedModProvider.getProviderType();
                    boolean modProviderOnClient = mappedModProviderType.getSide() == ModSide.CLIENT;
                    boolean allowDatagenForProviderType = !targetModConfig.disabledProviderTypes().contains(mappedModProviderType);
                    if (!allowDatagenForProviderType) continue;
                    primaryGen.addProvider(mappedModProviderType.getSide() == ModSide.COMMON || (modProviderOnClient ? onClient : onServer), (DataProvider)mappedModProvider);
                }
            }
            if (!ENQUEUED_PROVIDERS.isEmpty()) {
                ObjectObjectImmutablePair<String, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, ? extends Pair<Boolean, ? extends DataProvider>>> providerMapper;
                while ((providerMapper = ENQUEUED_PROVIDERS.poll()) != null) {
                    targetMod = NexusServices.PLATFORM_MANAGER.getModDataById((String)providerMapper.left());
                    targetModId = targetMod.getModMetadata().modId();
                    targetModConfig = NexusServices.DATA_GENERATOR.getConfigForMod(targetModId);
                    allowDatagenForMod = targetModConfig != null && targetModConfig.enableDatagen();
                    modSpecificPackOutput = new ModSpecificPackOutput(rootOutputPath, targetMod, allowDatagenForMod);
                    if (!allowDatagenForMod) continue;
                    Pair mappedDataProvider = (Pair)((BiFunction)providerMapper.right()).apply(modSpecificPackOutput, regLookupProvider);
                    primaryGen.addProvider((Boolean)mappedDataProvider.left() != false ? onClient : onServer, (DataProvider)mappedDataProvider.right());
                }
            }
            NexusServices.PLATFORM_MANAGER.getModData().forEach(curModData -> {
                String modId = curModData.getModMetadata().modId();
                ModDatagenConfig modDatagenConfig = NexusServices.DATA_GENERATOR.getConfigForMod(modId);
                boolean allowDatagenForMod = modDatagenConfig != null && modDatagenConfig.enableDatagen();
                ModSpecificPackOutput modSpecificPackOutput = new ModSpecificPackOutput(rootOutputPath, (ModData)curModData, allowDatagenForMod);
                if (allowDatagenForMod) {
                    Set<Object> providersToValidate = modDatagenConfig.providerTypesToFullyValidate() == null ? Set.of() : modDatagenConfig.providerTypesToFullyValidate();
                    Set<Object> disabledProviders = modDatagenConfig.disabledProviderTypes() == null ? Set.of() : modDatagenConfig.disabledProviderTypes();
                    Map<Object, Object> mappedDupeStrats = modDatagenConfig.mappedDupeStrats() == null ? Map.of() : modDatagenConfig.mappedDupeStrats();
                    primaryGen.addProvider(!disabledProviders.contains(NexusProviderTypes.LANGUAGE_PROVIDER) && onClient, (DataProvider)new StandardLanguageProvider(modSpecificPackOutput, modId, "en_us", providersToValidate.contains(NexusProviderTypes.LANGUAGE_PROVIDER), mappedDupeStrats.getOrDefault(NexusProviderTypes.LANGUAGE_PROVIDER, (Object)DuplicateDataPolicy.CRASH)));
                    primaryGen.addProvider(!disabledProviders.contains(NexusProviderTypes.MODEL_PROVIDER) && onClient, (DataProvider)new StandardModelProvider(modSpecificPackOutput, modId, providersToValidate.contains(NexusProviderTypes.MODEL_PROVIDER), (DuplicateDataPolicy)((Object)((Object)mappedDupeStrats.getOrDefault(NexusProviderTypes.MODEL_PROVIDER, (Object)DuplicateDataPolicy.CRASH)))));
                    primaryGen.addProvider(!disabledProviders.contains(NexusProviderTypes.BLOCK_STATE_PROVIDER) && onClient, (DataProvider)new StandardBlockStateProvider(modSpecificPackOutput, modId, providersToValidate.contains(NexusProviderTypes.BLOCK_STATE_PROVIDER), (DuplicateDataPolicy)((Object)((Object)mappedDupeStrats.getOrDefault(NexusProviderTypes.BLOCK_STATE_PROVIDER, (Object)DuplicateDataPolicy.CRASH)))));
                    primaryGen.addProvider(!disabledProviders.contains(NexusProviderTypes.DYNAMIC_REGISTRY_PROVIDER) && onServer, (DataProvider)new StandardDatapackRegistryProvider(modSpecificPackOutput, regLookupProvider, NexusServices.REGISTRAR.getRegistrySetBuilder(), modId, providersToValidate.contains(NexusProviderTypes.DYNAMIC_REGISTRY_PROVIDER), (DuplicateDataPolicy)((Object)((Object)mappedDupeStrats.getOrDefault(NexusProviderTypes.DYNAMIC_REGISTRY_PROVIDER, (Object)DuplicateDataPolicy.CRASH)))));
                    primaryGen.addProvider(!disabledProviders.contains(NexusProviderTypes.RECIPE_PROVIDER) && onServer, (DataProvider)new StandardRecipeProvider(modSpecificPackOutput, modId, providersToValidate.contains(NexusProviderTypes.RECIPE_PROVIDER), (DuplicateDataPolicy)((Object)((Object)mappedDupeStrats.getOrDefault(NexusProviderTypes.RECIPE_PROVIDER, (Object)DuplicateDataPolicy.CRASH)))));
                    primaryGen.addProvider(!disabledProviders.contains(NexusProviderTypes.LOOT_TABLE_PROVIDER) && onServer, (DataProvider)new StandardLootProvider(modSpecificPackOutput, modId, providersToValidate.contains(NexusProviderTypes.LOOT_TABLE_PROVIDER), (DuplicateDataPolicy)((Object)((Object)mappedDupeStrats.getOrDefault(NexusProviderTypes.LOOT_TABLE_PROVIDER, (Object)DuplicateDataPolicy.CRASH)))));
                    primaryGen.addProvider(!disabledProviders.contains(NexusProviderTypes.TAG_PROVIDER) && onServer, (DataProvider)new StandardTagProvider(modSpecificPackOutput, regLookupProvider, modId, providersToValidate.contains(NexusProviderTypes.TAG_PROVIDER), (DuplicateDataPolicy)((Object)((Object)mappedDupeStrats.getOrDefault(NexusProviderTypes.TAG_PROVIDER, (Object)DuplicateDataPolicy.CRASH)))));
                }
            });
            hasConsumedGenerators = true;
        }
    }
}

