/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.services;

import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.internal.event.custom.ForgeEventWrapper;
import com.mememan.nexus.loader.ModSide;
import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.platform.services.EventBus;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ForgeEventBus
implements EventBus {
    private static final Object2ObjectOpenHashMap<ModSide, Object2ObjectOpenHashMap<EventBus.EventKey<?>, ForgeEventWrapper<?>>> MAPPED_EVENTS = new Object2ObjectOpenHashMap();
    private static final Object2ObjectOpenHashMap<EventBus.EventKey<?>, Int2ObjectOpenHashMap<ObjectArrayList<?>>> LISTENERS_BY_PRIORITY = new Object2ObjectOpenHashMap();
    private final Object sideBasedThreadLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void registerEventHook(EventBus.EventKey<T> eventKey, Function<T[], T> eventListenerMerger, ModSide eventSide) {
        Class<T> eventInterface = eventKey.getEventInterface();
        Object object = this.sideBasedThreadLock;
        synchronized (object) {
            ForgeEventWrapper mappedEvent = (ForgeEventWrapper)((Object2ObjectOpenHashMap)MAPPED_EVENTS.computeIfAbsent((Object)eventSide, side -> new Object2ObjectOpenHashMap())).putIfAbsent(eventKey, new ForgeEventWrapper<T>(eventInterface, eventListenerMerger));
            if (mappedEvent != null) {
                throw new IllegalArgumentException(String.format("Event of type %s%s is already mapped to ModSide: %s", eventInterface.getName(), eventKey.getAssociatedTypes().isEmpty() ? "" : "[" + eventKey.getAssociatedTypes().stream().map(Class::getName).collect(Collectors.joining(", ")) + "]", eventSide.getSideName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void onEvent(Class<T> eventInterface, T listener, ModSide listenerTypeSide, int listenerPriority, Class<?> ... associatedEventTypes) {
        ForgeEventWrapper mappedEvent;
        Object2ObjectOpenHashMap eventByType = (Object2ObjectOpenHashMap)MAPPED_EVENTS.get((Object)listenerTypeSide);
        if (eventByType == null || eventByType.isEmpty()) {
            NexusConstants.LOGGER.debug("ModSide {} has no mapped events, skipping listener registration until state changes...", (Object)listenerTypeSide.getSideName());
            return;
        }
        EventBus.EventKey<T> eventKey = new EventBus.EventKey<T>(eventInterface, associatedEventTypes);
        ForgeEventWrapper forgeEventWrapper = mappedEvent = eventByType.get(eventKey) == null ? null : (ForgeEventWrapper)eventByType.get(eventKey);
        if (mappedEvent == null) {
            NexusConstants.LOGGER.warn("Event of type {}{} is not mapped to ModSide: {}, skipping listener registration until state changes...", new Object[]{eventInterface.getName(), eventKey.getAssociatedTypes().isEmpty() ? "" : "[" + eventKey.getAssociatedTypes().stream().map(Class::getName).collect(Collectors.joining(", ")) + "]", listenerTypeSide.getSideName()});
            return;
        }
        Object object = this.sideBasedThreadLock;
        synchronized (object) {
            ObjectArrayList listenersByPriority = (ObjectArrayList)((Int2ObjectOpenHashMap)LISTENERS_BY_PRIORITY.computeIfAbsent(new EventBus.EventKey<T>(eventInterface, associatedEventTypes), eventInterfaceClazz -> new Int2ObjectOpenHashMap())).computeIfAbsent(listenerPriority, priority -> new ObjectArrayList());
            if (!listenersByPriority.contains(listener)) {
                mappedEvent.addListener(listener, listenerPriority);
                listenersByPriority.add(listener);
            }
        }
    }

    @Override
    public <T, R> R fireEventHook(Class<T> eventInterface, Function<T, R> eventListenerInvokerMapper, ModSide eventSide, Class<?> ... associatedEventTypes) {
        ForgeEventWrapper mappedEvent;
        Object2ObjectOpenHashMap eventByType = (Object2ObjectOpenHashMap)MAPPED_EVENTS.get((Object)eventSide);
        if (eventByType == null || eventByType.isEmpty()) {
            NexusConstants.LOGGER.debug("ModSide {} has no mapped events, skipping event invocation/posting/firing until state changes...", (Object)eventSide.getSideName());
            return null;
        }
        EventBus.EventKey<T> eventKey = new EventBus.EventKey<T>(eventInterface, associatedEventTypes);
        ForgeEventWrapper forgeEventWrapper = mappedEvent = eventByType.get(eventKey) == null ? null : (ForgeEventWrapper)eventByType.get(eventKey);
        if (mappedEvent == null && eventSide != ModSide.COMMON) {
            mappedEvent = (ForgeEventWrapper)((Object2ObjectOpenHashMap)MAPPED_EVENTS.getOrDefault((Object)ModSide.COMMON, (Object)new Object2ObjectOpenHashMap())).get(eventKey);
        }
        if (mappedEvent == null) {
            NexusConstants.LOGGER.warn("Event of type {}{} is not mapped to ModSide: {}, skipping event invocation/posting/firing until state changes...", new Object[]{eventInterface.getName(), eventKey.getAssociatedTypes().isEmpty() ? "" : "[" + eventKey.getAssociatedTypes().stream().map(Class::getName).collect(Collectors.joining(", ")) + "]", eventSide.getSideName()});
            return null;
        }
        if (!NexusServices.PLATFORM_MANAGER.getEnvironmentSide().pertainsTo(eventSide)) {
            NexusConstants.LOGGER.warn("Attempted to invoke listeners for event of type {}{} on EnvironmentSide {} (physical side), but provided ModSide was {} (logical side). Skipping listener invocation on current side...", new Object[]{eventInterface.getName(), eventKey.getAssociatedTypes().isEmpty() ? "" : "[" + eventKey.getAssociatedTypes().stream().map(Class::getName).collect(Collectors.joining(", ")) + "]", NexusServices.PLATFORM_MANAGER.getEnvironmentSide().getSideName(), eventSide.getSideName()});
            return null;
        }
        return eventListenerInvokerMapper.apply(mappedEvent.invoker());
    }

    @Override
    public <T> Map<Integer, List<T>> getListenersFor(Class<T> eventInterface, Class<?> ... associatedEventTypes) {
        Int2ObjectOpenHashMap classifiedListenersByPriority = (Int2ObjectOpenHashMap)LISTENERS_BY_PRIORITY.get(new EventBus.EventKey<T>(eventInterface, associatedEventTypes));
        return classifiedListenersByPriority == null ? Map.of() : (Map)new Int2ObjectOpenHashMap((Int2ObjectMap)classifiedListenersByPriority).int2ObjectEntrySet().stream().map(curEntry -> new Int2ObjectMap.Entry<ObjectArrayList<T>>(){
            final /* synthetic */ Int2ObjectMap.Entry val$curEntry;
            {
                this.val$curEntry = entry;
            }

            public ObjectArrayList<T> getValue() {
                return (ObjectArrayList)this.val$curEntry.getValue();
            }

            public ObjectArrayList<T> setValue(ObjectArrayList<T> value) {
                return (ObjectArrayList)this.val$curEntry.setValue(value);
            }

            public int getIntKey() {
                return this.val$curEntry.getIntKey();
            }
        }).collect(Collectors.toMap(Int2ObjectMap.Entry::getIntKey, Map.Entry::getValue, (a, b) -> a, Int2ObjectOpenHashMap::new));
    }
}

