/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.services;

import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.asm.annotations.NetworkRegistrarEntry;
import com.mememan.nexus.network.BasePacket;
import com.mememan.nexus.network.NetworkSide;
import com.mememan.nexus.network.PacketContext;
import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.platform.services.NetworkManager;
import com.mememan.nexus.util.ClientUtil;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.ApiStatus;

public class ForgeNetworkManager
implements NetworkManager {
    private static final SimpleChannel INSTANCE = NetworkRegistry.ChannelBuilder.named((ResourceLocation)NexusConstants.prefix("messages")).networkProtocolVersion(() -> "1.0").clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).simpleChannel();
    private static int PACKET_ID = 0;

    @Override
    @ApiStatus.Internal
    public void setupNetworkManager() {
        long startTime = System.currentTimeMillis();
        NexusServices.PLATFORM_MANAGER.discoverAnnotatedClasses(NetworkRegistrarEntry.class);
        long endTime = System.currentTimeMillis();
        NexusConstants.LOGGER.info("Network manager setup took {} ms", (Object)(endTime - startTime));
    }

    @Override
    public <MSGT> BasePacket<MSGT> registerPacket(BasePacket<MSGT> packet) {
        INSTANCE.registerMessage(PACKET_ID++, packet.packetClass(), packet.packetEncoder(), packet.packetDecoder(), this.handlePacketFromContext(packet.packetHandler()), Optional.of(packet.targetSide().equals((Object)NetworkSide.C2S) ? NetworkDirection.PLAY_TO_SERVER : NetworkDirection.PLAY_TO_CLIENT));
        return packet;
    }

    @Override
    public <MSGT> void sendToServer(MSGT c2sPacket) {
        INSTANCE.sendToServer(c2sPacket);
    }

    @Override
    public <MSGT> void sendToClient(MSGT s2cPacket) {
        INSTANCE.sendTo(s2cPacket, Objects.requireNonNull(Minecraft.m_91087_().m_91403_(), "Minecraft instance has no connection (Are you sending this packet outside of an active game?)").m_104910_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public <MSGT> void sendToAllClients(MSGT s2cPacket) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), s2cPacket);
    }

    @Override
    public <MSGT> void sendToTrackingClients(MSGT s2cPacket, Entity trackedEntity, boolean ignoreSelf) {
        INSTANCE.send(ignoreSelf ? PacketDistributor.TRACKING_ENTITY.with(() -> trackedEntity) : PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> trackedEntity), s2cPacket);
    }

    @Override
    public <MSGT> void sendToTrackingClients(MSGT s2cPacket, LevelChunk trackedChunk) {
        INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> trackedChunk), s2cPacket);
    }

    @Override
    public <MSGT> void sendToClientsInDimension(MSGT s2cPacket, ResourceKey<Level> targetDim) {
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> targetDim), s2cPacket);
    }

    @Override
    public <MSGT> void sendToClientsWithinRange(MSGT s2cPacket, ResourceKey<Level> targetDim, BlockPos originPos, double range) {
        INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)originPos.m_123341_(), (double)originPos.m_123342_(), (double)originPos.m_123343_(), range, targetDim)), s2cPacket);
    }

    @Override
    public <MSGT> void sendToClient(MSGT s2cPacket, ServerPlayer targetPlayer) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> targetPlayer), s2cPacket);
    }

    private <MSGT> BiConsumer<MSGT, Supplier<NetworkEvent.Context>> handlePacketFromContext(Function<MSGT, PacketContext> handler) {
        return (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ForgeNetworkManager.lambda$handlePacketFromContext$9((Supplier)ctx, handler, msg));
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        };
    }

    private static /* synthetic */ void lambda$handlePacketFromContext$9(Supplier ctx, Function handler, Object msg) {
        LogicalSide curSide = ((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer() ? LogicalSide.SERVER : LogicalSide.CLIENT;
        ServerPlayer playerSender = ((NetworkEvent.Context)ctx.get()).getSender();
        ((PacketContext)handler.apply(msg)).handlePacket((Player)(playerSender == null ? ClientUtil.getClientPlayer() : playerSender), (Level)(playerSender == null ? ((Optional)LogicalSidedProvider.CLIENTWORLD.get(curSide)).orElse(ClientUtil.getClientLevel()) : playerSender.m_284548_()), ((NetworkEvent.Context)ctx.get()).getNetworkManager(), curSide.isServer() ? NetworkSide.C2S : NetworkSide.S2C);
    }
}

