/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.internal.services;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.asm.ClassFinder;
import com.mememan.nexus.asm.annotations.RegistrarEntry;
import com.mememan.nexus.loader.StandardRegistryBuilder;
import com.mememan.nexus.mixins.forge.registries.DataPackRegistriesHooksAccessor;
import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.platform.services.Registrar;
import com.mememan.nexus.resource.config.ResourceReloadListenerConfig;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import it.unimi.dsi.fastutil.objects.ObjectObjectMutablePair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ForgeRegistrar
implements Registrar {
    private static final Object2ObjectLinkedOpenHashMap<String, Object2ObjectOpenHashMap<ResourceKey<?>, DeferredRegister<?>>> CACHED_REGISTRIES = new Object2ObjectLinkedOpenHashMap();
    private static final Multimap<ResourceKey<? extends Registry<?>>, ObjectObjectMutablePair<ResourceKey<?>, Function<? extends BootstapContext<?>, ? extends Supplier<?>>>> CACHED_DATAPACK_OBJECT_ENTRIES = ArrayListMultimap.create();
    private static final Map<ResourceLocation, Pair<? extends PreparableReloadListener, Optional<ResourceReloadListenerConfig<? extends PreparableReloadListener>>>> CACHED_RESOURCE_RELOAD_LISTENERS = new Object2ObjectOpenHashMap();
    private static final Multimap<ResourceKey<? extends Registry<?>>, ResourceLocation> EARLY_REFLECTED_ENTRIES = ArrayListMultimap.create();
    private static RegistrySetBuilder DATAPACK_REGISTRY_SET_BUILDER;

    @Override
    @ApiStatus.Internal
    public void setupRegistrar() {
        long startTime = System.currentTimeMillis();
        NexusServices.PLATFORM_MANAGER.discoverAnnotatedClasses(RegistrarEntry.class, (classA, classB) -> {
            int priorityB;
            Class<?> uninitializedClassA = ClassFinder.forNameNoInit(classA);
            Class<?> uninitializedClassB = ClassFinder.forNameNoInit(classB);
            RegistrarEntry annotA = uninitializedClassA.getAnnotation(RegistrarEntry.class);
            RegistrarEntry annotB = uninitializedClassB.getAnnotation(RegistrarEntry.class);
            int priorityA = annotA.priority();
            return priorityA > (priorityB = annotB.priority()) ? -1 : (priorityA == priorityB ? classA.compareTo((String)classB) : 1);
        }, sortedClassName -> {
            Class<?> uninitializedTargetClass = ClassFinder.forNameNoInit(sortedClassName);
            RegistrarEntry targetAnnotation = uninitializedTargetClass.getAnnotation(RegistrarEntry.class);
            Class[] dependencies = targetAnnotation.dependencies();
            if (dependencies != null) {
                for (Class dependency : dependencies) {
                    if (dependency == null || dependency.getName().equals(sortedClassName)) continue;
                    ClassFinder.forName(dependency.getName());
                }
            }
        });
        CACHED_DATAPACK_OBJECT_ENTRIES.asMap().forEach((registryKey, objSupMappingFuncs) -> ForgeRegistrar.getDatapackRegistrySetBuilder().m_254916_(this.tCastRegistryKey((ResourceKey<? extends Registry<?>>)registryKey), b -> objSupMappingFuncs.forEach(mappedObjKey -> b.m_255272_(this.tCastObjectKey((ResourceKey)mappedObjKey.left()), this.tCastObjSupMappingFunc((Function)mappedObjKey.right(), b).get()))));
        long endTime = System.currentTimeMillis();
        NexusConstants.LOGGER.info("Registrar setup took {} ms", (Object)(endTime - startTime));
    }

    public <V, T extends V> RegistryObject<T> registerObject(ResourceLocation objId, Supplier<T> objSup, Registry<V> targetRegistry) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ResourceKey targetRegistryKey = targetRegistry.m_123023_();
        String modId = objId.m_135827_();
        DeferredRegister existingDefReg = (DeferredRegister)((Object2ObjectOpenHashMap)CACHED_REGISTRIES.computeIfAbsent((Object)modId, oK -> new Object2ObjectOpenHashMap())).computeIfAbsent((Object)targetRegistryKey, regKey -> {
            DeferredRegister cachedDefReg = DeferredRegister.create((ResourceKey)targetRegistryKey, (String)modId);
            cachedDefReg.register(modBus);
            return cachedDefReg;
        });
        return existingDefReg.register(objId.m_135815_(), objSup);
    }

    public <V, T extends V> RegistryObject<T> registerObjectAndReflect(ResourceLocation objId, Supplier<T> objSup, Registry<V> targetRegistry) {
        RegistryObject<Object> deferredRegObj = this.registerObject(objId, () -> Registry.m_122965_((Registry)targetRegistry, (ResourceLocation)objId, objSup.get()), targetRegistry);
        EARLY_REFLECTED_ENTRIES.put((Object)targetRegistry.m_123023_(), (Object)objId);
        return deferredRegObj;
    }

    @Override
    public <V, T extends V> Supplier<ResourceKey<T>> registerDatapackObject(ResourceLocation objId, Function<BootstapContext<T>, Supplier<T>> objSupMappingFunc, ResourceKey<Registry<V>> targetDatapackRegistry) {
        ResourceKey targetObject = ResourceKey.m_135785_(targetDatapackRegistry, (ResourceLocation)objId);
        if (objSupMappingFunc != null) {
            CACHED_DATAPACK_OBJECT_ENTRIES.put(targetDatapackRegistry, (Object)ObjectObjectMutablePair.of((Object)targetObject, objSupMappingFunc));
        }
        return () -> targetObject;
    }

    @Override
    public <T> Registry<T> registerStandardRegistry(StandardRegistryBuilder<T, Registry<T>> registryBuilder) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        DeferredRegister defReg = DeferredRegister.create(registryBuilder.getRegistryKey(), (String)registryBuilder.getRegistryKey().m_135782_().m_135827_());
        RegistryBuilder forgeRegBuilder = new RegistryBuilder();
        if (!registryBuilder.isSynced()) {
            forgeRegBuilder.disableSync();
        }
        if (!registryBuilder.isPersistent()) {
            forgeRegBuilder.disableSaving();
        }
        if (!registryBuilder.isBuiltAsCustomRegistry() && registryBuilder.getDefaultRegistryEntryLocation() != null) {
            forgeRegBuilder.setDefaultKey(registryBuilder.getDefaultRegistryEntryLocation());
        }
        forgeRegBuilder.hasTags();
        defReg.makeRegistry(() -> forgeRegBuilder);
        defReg.register(modBus);
        return registryBuilder.buildAndGetRegistry();
    }

    @Override
    public <T> ResourceKey<Registry<T>> registerDatapackRegistry(ResourceKey<Registry<T>> registryKey, Codec<T> registryCodec, @Nullable Codec<T> networkCodec) {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(event -> event.dataPackRegistry(registryKey, registryCodec, networkCodec));
        return registryKey;
    }

    @Override
    public <PRL extends PreparableReloadListener> PRL registerReloadListener(ResourceLocation listenerId, PRL listener, ResourceReloadListenerConfig<PRL> config) {
        CACHED_RESOURCE_RELOAD_LISTENERS.putIfAbsent(listenerId, (Pair<? extends PreparableReloadListener, Optional<ResourceReloadListenerConfig<? extends PreparableReloadListener>>>)ObjectObjectImmutablePair.of(listener, Optional.ofNullable(config)));
        return listener;
    }

    @Override
    @Nullable
    public RegistrySetBuilder getRegistrySetBuilder() {
        return ForgeRegistrar.getDatapackRegistrySetBuilder();
    }

    @Override
    public List<RegistryDataLoader.RegistryData<?>> getDynamicRegistries() {
        return DataPackRegistriesHooks.getDataPackRegistries();
    }

    @Override
    public Map<ResourceKey<? extends Registry<?>>, RegistrySynchronization.NetworkedRegistryData<?>> getSyncedDynamicRegistries() {
        return DataPackRegistriesHooksAccessor.getNetworkableRegistries();
    }

    @Override
    public <PRL extends PreparableReloadListener> Map<ResourceLocation, Pair<PRL, Optional<ResourceReloadListenerConfig<PRL>>>> getMappedResourceReloadListeners() {
        return ForgeRegistrar.getCachedResourceReloadListeners();
    }

    protected <T> Supplier<T> tCastObjSupMappingFunc(Function<? extends BootstapContext<?>, ? extends Supplier<?>> objSupMappingFunc, BootstapContext<T> bootstapContext) {
        return objSupMappingFunc.apply(bootstapContext);
    }

    protected <T> ResourceKey<T> tCastObjectKey(ResourceKey<?> objectKey) {
        return objectKey;
    }

    protected <T> ResourceKey<Registry<T>> tCastRegistryKey(ResourceKey<? extends Registry<?>> registryKey) {
        return registryKey;
    }

    public static RegistrySetBuilder getDatapackRegistrySetBuilder() {
        return DATAPACK_REGISTRY_SET_BUILDER == null ? (DATAPACK_REGISTRY_SET_BUILDER = new RegistrySetBuilder()) : DATAPACK_REGISTRY_SET_BUILDER;
    }

    public static ImmutableMap<String, Object2ObjectOpenHashMap<ResourceKey<?>, DeferredRegister<?>>> getCachedRegistries() {
        return ImmutableMap.copyOf(CACHED_REGISTRIES);
    }

    public static ImmutableMultimap<ResourceKey<? extends Registry<?>>, ObjectObjectMutablePair<ResourceKey<?>, Function<? extends BootstapContext<?>, ? extends Supplier<?>>>> getCachedDatapackObjectEntries() {
        return ImmutableMultimap.copyOf(CACHED_DATAPACK_OBJECT_ENTRIES);
    }

    public static ImmutableMultimap<ResourceKey<? extends Registry<?>>, ResourceLocation> getEarlyReflectedRegistryEntries() {
        return ImmutableMultimap.copyOf(EARLY_REFLECTED_ENTRIES);
    }

    public static <PRL extends PreparableReloadListener> ImmutableMap<ResourceLocation, Pair<PRL, Optional<ResourceReloadListenerConfig<PRL>>>> getCachedResourceReloadListeners() {
        Object2ObjectOpenHashMap result = new Object2ObjectOpenHashMap();
        CACHED_RESOURCE_RELOAD_LISTENERS.forEach((arg_0, arg_1) -> ForgeRegistrar.lambda$getCachedResourceReloadListeners$12((Map)result, arg_0, arg_1));
        return ImmutableMap.copyOf((Map)result);
    }

    private static /* synthetic */ void lambda$getCachedResourceReloadListeners$12(Map result, ResourceLocation key, Pair value) {
        result.put(key, ObjectObjectImmutablePair.of((Object)((PreparableReloadListener)value.left()), ((Optional)value.right()).flatMap(config -> Optional.of(config))));
    }
}

