/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.loader;

import com.mojang.serialization.Lifecycle;
import net.minecraft.core.DefaultedMappedRegistry;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class StandardRegistryBuilder<T, R extends Registry<T>> {
    private final ResourceKey<R> registryKey;
    private boolean synced = false;
    private boolean persistent = false;
    @Nullable
    private ResourceLocation defaultRegistryEntryLocation;
    @Nullable
    private R potentialBuiltRegistry;
    private boolean builtAsCustomRegistry = false;

    private StandardRegistryBuilder(ResourceKey<R> registryKey) {
        this.registryKey = registryKey;
    }

    public static <T, R extends Registry<T>> StandardRegistryBuilder<T, R> of(ResourceKey<R> registryKey, Class<T> regTypeClazz) {
        return new StandardRegistryBuilder<T, R>(registryKey);
    }

    public static <T, R extends Registry<T>> StandardRegistryBuilder<T, R> of(ResourceLocation registryId, Class<T> regTypeClazz) {
        return new StandardRegistryBuilder<T, R>(ResourceKey.m_135788_((ResourceLocation)registryId));
    }

    public StandardRegistryBuilder<T, R> synced(boolean synced) {
        this.synced = synced;
        return this;
    }

    public StandardRegistryBuilder<T, R> persistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public StandardRegistryBuilder<T, R> defaultRegistryEntryLocation(ResourceLocation defaultRegistryEntryLocation) {
        this.defaultRegistryEntryLocation = defaultRegistryEntryLocation;
        return this;
    }

    public StandardRegistryBuilder<T, R> buildFromCustomRegistryType(R customRegistryObject) {
        this.potentialBuiltRegistry = customRegistryObject;
        this.builtAsCustomRegistry = this.potentialBuiltRegistry != null;
        return this;
    }

    public StandardRegistryBuilder<T, R> buildRegistry() {
        if (!this.builtAsCustomRegistry) {
            this.potentialBuiltRegistry = this.defaultRegistryEntryLocation == null ? new MappedRegistry(this.registryKey, Lifecycle.stable()) : new DefaultedMappedRegistry(this.defaultRegistryEntryLocation.toString(), this.registryKey, Lifecycle.stable(), false);
        }
        return this;
    }

    public R buildAndGetRegistry() {
        this.buildRegistry();
        return this.getRegistry();
    }

    public ResourceKey<R> getRegistryKey() {
        return this.registryKey;
    }

    @Nullable
    public ResourceLocation getDefaultRegistryEntryLocation() {
        return this.defaultRegistryEntryLocation;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    @Nullable
    public R getRegistry() {
        return this.potentialBuiltRegistry;
    }

    public boolean isBuiltAsCustomRegistry() {
        return this.builtAsCustomRegistry;
    }
}

