/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.mixins.entity;

import com.mememan.nexus.event.result.EventResult;
import com.mememan.nexus.template.event.blueprint.common.TickEventBlueprint;
import com.mememan.nexus.template.event.def.common.TickEvent;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    private EntityMixin() {
        throw new IllegalArgumentException("Attempted to construct Mixin Class! (EntityMixin)");
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void nexus$handlePreEntityTickEventHook(CallbackInfo ci) {
        TickEvent.EntityTickEvent entityTickEventHook = new TickEvent.EntityTickEvent(TickEvent.Phase.START, (Entity)this);
        EventResult entityTickEventResult = TickEventBlueprint.ENTITY_TICK.fireEvent(entityTickEventHook);
        if (entityTickEventResult.cancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void nexus$handlePostEntityTickEventHook(CallbackInfo ci) {
        TickEvent.EntityTickEvent entityTickEventHook = new TickEvent.EntityTickEvent(TickEvent.Phase.END, (Entity)this);
        TickEventBlueprint.ENTITY_TICK.fireEvent(entityTickEventHook);
    }
}

