/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.mixins.entity;

import com.mememan.nexus.event.result.EventResult;
import com.mememan.nexus.template.event.blueprint.common.TickEventBlueprint;
import com.mememan.nexus.template.event.def.common.TickEvent;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    private PlayerMixin() {
        throw new IllegalArgumentException("Attempted to construct Mixin Class! (PlayerMixin)");
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void nexus$handlePrePlayerTickEventHook(CallbackInfo ci) {
        TickEvent.PlayerTickEvent playerTickEventHook = new TickEvent.PlayerTickEvent(TickEvent.Phase.START, (Player)this);
        EventResult playerTickEventResult = TickEventBlueprint.PLAYER_TICK.fireEvent(playerTickEventHook);
        if (playerTickEventResult.cancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void nexus$handlePostPlayerTickEventHook(CallbackInfo ci) {
        TickEvent.PlayerTickEvent playerTickEventHook = new TickEvent.PlayerTickEvent(TickEvent.Phase.END, (Player)this);
        TickEventBlueprint.PLAYER_TICK.fireEvent(playerTickEventHook);
    }
}

