/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.mixins.server;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mememan.nexus.event.result.EventResult;
import com.mememan.nexus.template.event.blueprint.common.TickEventBlueprint;
import com.mememan.nexus.template.event.blueprint.server.ServerLifeCycleEventBlueprint;
import com.mememan.nexus.template.event.def.common.TickEvent;
import com.mememan.nexus.template.event.def.server.ServerLifeCycleEvent;
import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    private MinecraftServerMixin() {
        throw new IllegalArgumentException("Attempted to construct Mixin Class! (MinecraftServerMixin)");
    }

    @ModifyExpressionValue(method={"runServer"}, at={@At(value="MIXINEXTRAS:EXPRESSION")})
    @Definition(id="initServer", method={"Lnet/minecraft/server/MinecraftServer;initServer()Z"})
    @Expression(value={"this.initServer()"})
    private boolean nexus$handleServerStartingEventHook(boolean original) {
        ServerLifeCycleEvent.ServerStartingEvent serverStartingEventHook = new ServerLifeCycleEvent.ServerStartingEvent((MinecraftServer)this);
        EventResult serverStartingEventResult = ServerLifeCycleEventBlueprint.SERVER_STARTING.fireEvent(serverStartingEventHook);
        return original && !serverStartingEventResult.cancelled();
    }

    @Inject(method={"runServer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;buildServerStatus()Lnet/minecraft/network/protocol/status/ServerStatus;", shift=At.Shift.AFTER)})
    private void nexus$handleServerStartEventHook(CallbackInfo ci) {
        ServerLifeCycleEvent.ServerStartedEvent serverStartedEventHook = new ServerLifeCycleEvent.ServerStartedEvent((MinecraftServer)this);
        ServerLifeCycleEventBlueprint.SERVER_STARTED.fireEvent(serverStartedEventHook);
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")})
    private void nexus$handleServerStoppingEventHook(CallbackInfo ci) {
        ServerLifeCycleEvent.ServerStoppingEvent serverStoppingEventHook = new ServerLifeCycleEvent.ServerStoppingEvent((MinecraftServer)this);
        ServerLifeCycleEventBlueprint.SERVER_STOPPING.fireEvent(serverStoppingEventHook);
    }

    @Inject(method={"stopServer"}, at={@At(value="TAIL")})
    private void nexus$handleServerStopEventHook(CallbackInfo ci) {
        ServerLifeCycleEvent.ServerStoppedEvent serverStoppedEventHook = new ServerLifeCycleEvent.ServerStoppedEvent((MinecraftServer)this);
        ServerLifeCycleEventBlueprint.SERVER_STOPPED.fireEvent(serverStoppedEventHook);
    }

    @Inject(method={"tickServer"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/Util;getNanos()J", ordinal=0)}, cancellable=true)
    private void nexus$handlePreServerTickEventHook(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        TickEvent.ServerTickEvent serverTickEventHook = new TickEvent.ServerTickEvent(TickEvent.Phase.START, (MinecraftServer)this, hasTimeLeft);
        EventResult serverTickEventEventResult = TickEventBlueprint.SERVER_TICK.fireEvent(serverTickEventHook);
        if (serverTickEventEventResult.cancelled()) {
            ci.cancel();
        }
    }

    @Inject(method={"tickServer"}, at={@At(value="TAIL")})
    private void nexus$handlePostServerTickEventHook(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        TickEvent.ServerTickEvent serverTickEventHook = new TickEvent.ServerTickEvent(TickEvent.Phase.END, (MinecraftServer)this, hasTimeLeft);
        TickEventBlueprint.SERVER_TICK.fireEvent(serverTickEventHook);
    }
}

