/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.platform;

import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.platform.services.DataGenerator;
import com.mememan.nexus.platform.services.EventBus;
import com.mememan.nexus.platform.services.NetworkManager;
import com.mememan.nexus.platform.services.PlatformManager;
import com.mememan.nexus.platform.services.Registrar;
import java.util.ServiceLoader;

public class NexusServices {
    public static final PlatformManager PLATFORM_MANAGER = NexusServices.loadService(PlatformManager.class);
    public static final Registrar REGISTRAR = NexusServices.loadService(Registrar.class);
    public static final NetworkManager NETWORK_MANAGER = NexusServices.loadService(NetworkManager.class);
    public static final DataGenerator DATA_GENERATOR = NexusServices.loadService(DataGenerator.class);
    public static final EventBus EVENT_BUS = NexusServices.loadService(EventBus.class);

    private static <T> T loadService(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        NexusConstants.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

