/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.platform.services;

import com.google.common.collect.HashMultimap;
import com.mememan.nexus.datagen.ModDatagenConfig;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.datagen.standard.ModDataProvider;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface DataGenerator {
    @ApiStatus.Internal
    @ApiStatus.OverrideOnly
    public void setupDataGenerator();

    public <DP extends DataProvider> void registerDataProvider(String var1, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, Pair<Boolean, DP>> var2);

    public <MDP extends ModDataProvider> void registerModDataProvider(String var1, BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, MDP> var2);

    public ModDatagenConfig registerConfigForMod(ModDatagenConfig var1);

    public Set<ModDatagenConfig> getModDatagenConfigs();

    @Nullable
    default public ModDatagenConfig getConfigForMod(String modId) {
        return this.getModDatagenConfigs().isEmpty() ? null : (ModDatagenConfig)this.getModDatagenConfigs().stream().filter(curConfig -> curConfig.modId().equals(modId)).findFirst().orElse(null);
    }

    default public HashMultimap<String, ProviderType> getDisabledDataProviders() {
        HashMultimap mappedDisabledProviders = HashMultimap.create();
        if (this.getModDatagenConfigs().isEmpty()) {
            return mappedDisabledProviders;
        }
        this.getModDatagenConfigs().forEach(curModDGConfig -> mappedDisabledProviders.asMap().computeIfAbsent(curModDGConfig.modId(), oK -> new ObjectOpenHashSet()).addAll(curModDGConfig.disabledProviderTypes()));
        return mappedDisabledProviders;
    }

    default public ObjectOpenHashSet<ModDatagenConfig> getDisabledMods() {
        return this.getModDatagenConfigs().isEmpty() ? ObjectOpenHashSet.of() : this.getModDatagenConfigs().stream().filter(curModDGConfig -> !curModDGConfig.enableDatagen()).collect(Collectors.toCollection(ObjectOpenHashSet::new));
    }

    @Nullable
    public net.minecraft.data.DataGenerator getDataGenerator();
}

