/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.platform.services;

import com.google.common.collect.ImmutableList;
import com.mememan.nexus.event.blueprint.EventBlueprint;
import com.mememan.nexus.loader.ModSide;
import com.mememan.nexus.util.ReflectionUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface EventBus {
    public <T> void registerEventHook(EventKey<T> var1, Function<T[], T> var2, ModSide var3);

    default public <T> void registerEventHook(Class<T> eventInterface, Function<T[], T> eventListenerMerger, ModSide eventSide) {
        this.registerEventHook(new EventKey<T>(eventInterface, new Class[0]), eventListenerMerger, eventSide);
    }

    default public <T> void registerEventHook(EventBlueprint<T> eventBlueprint) {
        this.registerEventHook(new EventKey<T>(eventBlueprint.getEventInterface(), eventBlueprint.getActualEventType()), eventBlueprint::mergeListeners, eventBlueprint.getEventSide());
    }

    public <T> void onEvent(Class<T> var1, T var2, ModSide var3, int var4, Class<?> ... var5);

    default public <T> void onEvent(Class<T> eventInterface, T listener, int listenerPriority, Class<?> ... associatedEventTypes) {
        this.onEvent(eventInterface, listener, ModSide.COMMON, listenerPriority, associatedEventTypes);
    }

    default public <T> void onEvent(T listener, ModSide listenerExecutionSide, int listenerPriority, Class<?> ... associatedEventTypes) {
        this.onEvent(ReflectionUtil.getFunctionalInterfaceClass(listener), listener, listenerExecutionSide, listenerPriority, associatedEventTypes);
    }

    default public <T> void onEvent(Class<T> eventInterface, T listener, Class<?> ... associatedEventTypes) {
        this.onEvent(eventInterface, listener, 0, associatedEventTypes);
    }

    default public <T> void onEvent(T listener, ModSide listenerExecutionSide, Class<?> ... associatedEventTypes) {
        this.onEvent(listener, listenerExecutionSide, 0, associatedEventTypes);
    }

    default public <T> void onEvent(T listener, int listenerPriority, Class<?> ... associatedEventTypes) {
        this.onEvent(listener, ModSide.COMMON, listenerPriority, associatedEventTypes);
    }

    default public <T> void onEvent(T listener, Class<?> ... associatedEventTypes) {
        this.onEvent(listener, 0, associatedEventTypes);
    }

    @Nullable
    public <T, R> R fireEventHook(Class<T> var1, Function<T, R> var2, ModSide var3, Class<?> ... var4);

    @Nullable
    default public <T, R> R fireEventHook(Class<T> eventInterface, Function<T, R> eventListenerInvokerMapper, Class<?> ... associatedEventTypes) {
        return this.fireEventHook(eventInterface, eventListenerInvokerMapper, ModSide.COMMON, associatedEventTypes);
    }

    public <T> Map<Integer, List<T>> getListenersFor(Class<T> var1, Class<?> ... var2);

    public static class EventKey<T> {
        protected final Class<T> eventInterface;
        protected final List<Class<?>> associatedTypes = new ObjectArrayList();

        public EventKey(Class<T> eventInterface, Class<?> ... associatedTypes) {
            if (!eventInterface.isInterface() || Arrays.stream(eventInterface.getMethods()).filter(curMethod -> Modifier.isAbstract(curMethod.getModifiers()) && !Modifier.isStatic(curMethod.getModifiers())).count() != 1L) {
                throw new IllegalArgumentException(String.format("Attempted to declare event of type %s, but it isn't a functional interface!", eventInterface.getName()));
            }
            this.eventInterface = eventInterface;
            this.associatedTypes.addAll(List.of(associatedTypes));
        }

        public Class<T> getEventInterface() {
            return this.eventInterface;
        }

        public List<Class<?>> getAssociatedTypes() {
            return ImmutableList.copyOf(this.associatedTypes);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventKey eventKey = (EventKey)o;
            return Objects.equals(this.eventInterface, eventKey.eventInterface) && Objects.equals(this.associatedTypes, eventKey.associatedTypes);
        }

        public int hashCode() {
            return Objects.hash(this.eventInterface, this.associatedTypes);
        }
    }
}

