/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.platform.services;

import com.mememan.nexus.loader.EnvironmentSide;
import com.mememan.nexus.loader.EnvironmentType;
import com.mememan.nexus.loader.GamePathWrapper;
import com.mememan.nexus.loader.ModData;
import com.mememan.nexus.loader.ModLoader;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface PlatformManager {
    public ModLoader getPlatform();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    public List<Class<?>> discoverAnnotatedClasses(Class<? extends Annotation> var1, @Nullable Comparator<String> var2, @Nullable List<String> var3, @Nullable Consumer<String> var4);

    default public List<Class<?>> discoverAnnotatedClasses(Class<? extends Annotation> annotationTypeClazz, @Nullable List<String> validModIds, Consumer<String> beforeClassInitConsumer) {
        return this.discoverAnnotatedClasses(annotationTypeClazz, String::compareTo, validModIds, beforeClassInitConsumer);
    }

    default public List<Class<?>> discoverAnnotatedClasses(Class<? extends Annotation> annotationTypeClazz, @Nullable List<String> validModIds) {
        return this.discoverAnnotatedClasses(annotationTypeClazz, validModIds, null);
    }

    default public List<Class<?>> discoverAnnotatedClasses(Class<? extends Annotation> annotationTypeClazz, @Nullable Comparator<String> classLoadingSorter, @Nullable Consumer<String> beforeClassInitConsumer) {
        return this.discoverAnnotatedClasses(annotationTypeClazz, classLoadingSorter, null, beforeClassInitConsumer);
    }

    default public List<Class<?>> discoverAnnotatedClasses(Class<? extends Annotation> annotationTypeClazz, @Nullable Comparator<String> classLoadingSorter) {
        return this.discoverAnnotatedClasses(annotationTypeClazz, classLoadingSorter, null);
    }

    default public List<Class<?>> discoverAnnotatedClasses(Class<? extends Annotation> annotationTypeClazz, @Nullable Consumer<String> beforeClassInitConsumer) {
        return this.discoverAnnotatedClasses(annotationTypeClazz, null, null, beforeClassInitConsumer);
    }

    default public List<Class<?>> discoverAnnotatedClasses(Class<? extends Annotation> annotationTypeClazz) {
        return this.discoverAnnotatedClasses(annotationTypeClazz, null, null, null);
    }

    public Set<ModData> getModData();

    @Nullable
    default public ModData getModDataById(String modId) {
        return this.getModData().isEmpty() ? null : (ModData)this.getModData().stream().filter(curModData -> curModData.getModMetadata().modId().equals(modId)).findFirst().orElse(null);
    }

    public GamePathWrapper getGamePathWrapper();

    @Nullable
    public MinecraftServer getCurrentServer();

    public boolean isRunningDataGen();

    public EnvironmentSide getEnvironmentSide();

    default public EnvironmentType getEnvironmentType() {
        return this.isDevelopmentEnvironment() ? EnvironmentType.DEVELOPMENT : EnvironmentType.PRODUCTION;
    }
}

