/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.property_wrapper.base.generic;

import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.datagen.ProviderType;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapperBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorPreset;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import org.jetbrains.annotations.NotNull;

public interface DataGenPropertyWrapper<T, SELF extends PropertyWrapper<T, SELF, BUILDER>, BUILDER extends PropertyWrapperBuilder<T, BUILDER, SELF>>
extends PropertyWrapper<T, SELF, BUILDER> {
    public boolean isExcludedFromDataGen();

    public Map<ProviderType, Boolean> getProviderTypeRequisites();

    default public Optional<String> getDescriptionIdPrefix() {
        return Optional.empty();
    }

    @NotNull
    default public String getObjectDescriptionId() {
        Optional<ResourceLocation> parentObjRegId = this.getObjectRegistryKey().map(ResourceKey::m_135782_);
        return this.isTemplate() ? "Template ".concat(this.getClass().getSimpleName()) : parentObjRegId.map(regLoc -> Util.m_137492_((String)this.getDescriptionIdPrefix().orElse(regLoc.m_135815_()), (ResourceLocation)RegistryLookupContainer.getObjectRegistryIdOrThrow(this.getParentObject().get()))).orElseGet(() -> this.getParentObject().get().toString());
    }

    default public Optional<ResourceKey<Registry<? super T>>> getObjectRegistryKey() {
        return this.isTemplate() ? Optional.empty() : RegistryLookupContainer.computeForObject(this.getParentObject().get());
    }

    public static class RegistryLookupContainer {
        public static final ResourceKey<? extends Registry<? super Object>> UNMAPPED_REGISTRY = ResourceKey.m_135788_((ResourceLocation)NexusConstants.prefix("unknown"));
        private static final Map<Class<?>, ResourceKey<? extends Registry<?>>> NATIVE_REGISTRY_KEY_LOOKUP = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), regKeyMap -> {
            regKeyMap.put(Activity.class, (Object)Registries.f_257025_);
            regKeyMap.put(Attribute.class, (Object)Registries.f_256728_);
            regKeyMap.put(BannerPattern.class, (Object)Registries.f_256969_);
            regKeyMap.put(BiomeSource.class, (Object)Registries.f_256826_);
            regKeyMap.put(Block.class, (Object)Registries.f_256747_);
            regKeyMap.put(BlockEntityType.class, (Object)Registries.f_256922_);
            regKeyMap.put(BlockPredicateType.class, (Object)Registries.f_256774_);
            regKeyMap.put(BlockStateProviderType.class, (Object)Registries.f_256891_);
            regKeyMap.put(WorldCarver.class, (Object)Registries.f_256812_);
            regKeyMap.put(CatVariant.class, (Object)Registries.f_257006_);
            regKeyMap.put(ChunkGenerator.class, (Object)Registries.f_256783_);
            regKeyMap.put(ChunkStatus.class, (Object)Registries.f_256755_);
            regKeyMap.put(ArgumentTypeInfo.class, (Object)Registries.f_256982_);
            regKeyMap.put(CreativeModeTab.class, (Object)Registries.f_279569_);
            regKeyMap.put(ResourceLocation.class, (Object)Registries.f_256887_);
            regKeyMap.put(DamageType.class, (Object)Registries.f_268580_);
            regKeyMap.put(DensityFunction.class, (Object)Registries.f_256746_);
            regKeyMap.put(Enchantment.class, (Object)Registries.f_256762_);
            regKeyMap.put(EntityType.class, (Object)Registries.f_256939_);
            regKeyMap.put(Feature.class, (Object)Registries.f_256833_);
            regKeyMap.put(FeatureSizeType.class, (Object)Registries.f_256720_);
            regKeyMap.put(FloatProviderType.class, (Object)Registries.f_256892_);
            regKeyMap.put(Fluid.class, (Object)Registries.f_256808_);
            regKeyMap.put(FoliagePlacerType.class, (Object)Registries.f_256905_);
            regKeyMap.put(FrogVariant.class, (Object)Registries.f_256732_);
            regKeyMap.put(GameEvent.class, (Object)Registries.f_256827_);
            regKeyMap.put(HeightProviderType.class, (Object)Registries.f_256757_);
            regKeyMap.put(Instrument.class, (Object)Registries.f_257010_);
            regKeyMap.put(IntProviderType.class, (Object)Registries.f_256949_);
            regKeyMap.put(Item.class, (Object)Registries.f_256913_);
            regKeyMap.put(LootItemConditionType.class, (Object)Registries.f_256976_);
            regKeyMap.put(LootItemFunctionType.class, (Object)Registries.f_257015_);
            regKeyMap.put(LootNbtProviderType.class, (Object)Registries.f_256871_);
            regKeyMap.put(LootNumberProviderType.class, (Object)Registries.f_256829_);
            regKeyMap.put(LootPoolEntryType.class, (Object)Registries.f_257032_);
            regKeyMap.put(LootScoreProviderType.class, (Object)Registries.f_256924_);
            regKeyMap.put(SurfaceRules.ConditionSource.class, (Object)Registries.f_256793_);
            regKeyMap.put(SurfaceRules.RuleSource.class, (Object)Registries.f_256815_);
            regKeyMap.put(MemoryModuleType.class, (Object)Registries.f_257023_);
            regKeyMap.put(MenuType.class, (Object)Registries.f_256798_);
            regKeyMap.put(MobEffect.class, (Object)Registries.f_256929_);
            regKeyMap.put(PaintingVariant.class, (Object)Registries.f_256836_);
            regKeyMap.put(ParticleType.class, (Object)Registries.f_256890_);
            regKeyMap.put(PlacementModifierType.class, (Object)Registries.f_256843_);
            regKeyMap.put(PoiType.class, (Object)Registries.f_256805_);
            regKeyMap.put(PositionSourceType.class, (Object)Registries.f_256792_);
            regKeyMap.put(PosRuleTestType.class, (Object)Registries.f_257009_);
            regKeyMap.put(Potion.class, (Object)Registries.f_256973_);
            regKeyMap.put(RecipeSerializer.class, (Object)Registries.f_256764_);
            regKeyMap.put(RecipeType.class, (Object)Registries.f_256954_);
            regKeyMap.put(RootPlacerType.class, (Object)Registries.f_256768_);
            regKeyMap.put(RuleTestType.class, (Object)Registries.f_256947_);
            regKeyMap.put(RuleBlockEntityModifierType.class, (Object)Registries.f_276428_);
            regKeyMap.put(Schedule.class, (Object)Registries.f_256723_);
            regKeyMap.put(SensorType.class, (Object)Registries.f_256937_);
            regKeyMap.put(SoundEvent.class, (Object)Registries.f_256840_);
            regKeyMap.put(StatType.class, (Object)Registries.f_256849_);
            regKeyMap.put(StructurePieceType.class, (Object)Registries.f_256786_);
            regKeyMap.put(StructurePlacementType.class, (Object)Registries.f_256888_);
            regKeyMap.put(StructurePoolElementType.class, (Object)Registries.f_257024_);
            regKeyMap.put(StructureProcessorType.class, (Object)Registries.f_256983_);
            regKeyMap.put(StructureType.class, (Object)Registries.f_256938_);
            regKeyMap.put(TreeDecoratorType.class, (Object)Registries.f_256845_);
            regKeyMap.put(TrunkPlacerType.class, (Object)Registries.f_256963_);
            regKeyMap.put(VillagerProfession.class, (Object)Registries.f_256749_);
            regKeyMap.put(VillagerType.class, (Object)Registries.f_257019_);
            regKeyMap.put(String.class, (Object)Registries.f_271200_);
            regKeyMap.put(Biome.class, (Object)Registries.f_256952_);
            regKeyMap.put(ChatType.class, (Object)Registries.f_256873_);
            regKeyMap.put(ConfiguredWorldCarver.class, (Object)Registries.f_257003_);
            regKeyMap.put(ConfiguredFeature.class, (Object)Registries.f_256911_);
            regKeyMap.put(DimensionType.class, (Object)Registries.f_256787_);
            regKeyMap.put(FlatLevelGeneratorPreset.class, (Object)Registries.f_256724_);
            regKeyMap.put(NoiseGeneratorSettings.class, (Object)Registries.f_256932_);
            regKeyMap.put(NormalNoise.NoiseParameters.class, (Object)Registries.f_256865_);
            regKeyMap.put(PlacedFeature.class, (Object)Registries.f_256988_);
            regKeyMap.put(Structure.class, (Object)Registries.f_256944_);
            regKeyMap.put(StructureProcessorList.class, (Object)Registries.f_257011_);
            regKeyMap.put(StructureSet.class, (Object)Registries.f_256998_);
            regKeyMap.put(StructureTemplatePool.class, (Object)Registries.f_256948_);
            regKeyMap.put(TrimMaterial.class, (Object)Registries.f_266076_);
            regKeyMap.put(TrimPattern.class, (Object)Registries.f_266063_);
            regKeyMap.put(WorldPreset.class, (Object)Registries.f_256729_);
            regKeyMap.put(MultiNoiseBiomeSourceParameterList.class, (Object)Registries.f_273919_);
            regKeyMap.put(Level.class, (Object)Registries.f_256858_);
            regKeyMap.put(LevelStem.class, (Object)Registries.f_256862_);
        });

        private RegistryLookupContainer() {
            throw new IllegalAccessError("Attempted to construct instance of container class! (RegistryLookupContainer)");
        }

        public static <T> Optional<ResourceKey<Registry<? super T>>> ofRegistryKey(ResourceKey<?> registryKey) {
            return Optional.ofNullable(registryKey);
        }

        public static <T> Optional<ResourceKey<Registry<? super T>>> computeForClass(Class<T> targetObjClazz) {
            return targetObjClazz == null ? Optional.empty() : RegistryLookupContainer.ofRegistryKey(NATIVE_REGISTRY_KEY_LOOKUP.computeIfAbsent(targetObjClazz, objClazz -> NATIVE_REGISTRY_KEY_LOOKUP.entrySet().stream().filter(regEntry -> ((Class)regEntry.getKey()).isAssignableFrom((Class<?>)objClazz)).map(Map.Entry::getValue).findFirst().flatMap(RegistryLookupContainer::ofRegistryKey).orElseGet(() -> BuiltInRegistries.f_257047_.m_6579_().stream().filter(curRegEntry -> !NATIVE_REGISTRY_KEY_LOOKUP.containsValue(curRegEntry.getKey())).flatMap(curRegEntry -> ((Registry)curRegEntry.getValue()).m_6579_().stream()).filter(regEntry -> regEntry.getValue().getClass().isAssignableFrom((Class<?>)objClazz)).map(Map.Entry::getKey).findFirst().flatMap(RegistryLookupContainer::ofRegistryKey).orElse(UNMAPPED_REGISTRY))));
        }

        public static <T> Optional<ResourceKey<Registry<? super T>>> computeForObject(T targetObj) {
            return RegistryLookupContainer.computeForClass(targetObj == null ? null : targetObj.getClass());
        }

        public static <T> Optional<Registry<T>> getRegistryForObject(T targetObj) {
            return targetObj == null ? Optional.empty() : Optional.ofNullable((Registry)BuiltInRegistries.f_257047_.m_7745_(RegistryLookupContainer.computeForObject(targetObj).filter(regResourceKey -> !regResourceKey.m_135782_().equals((Object)UNMAPPED_REGISTRY.m_135782_())).orElseThrow(() -> new IllegalArgumentException(String.format("Attempted to find registry resource key for non-registry object of type %s: %s", targetObj.getClass().getSimpleName(), targetObj))).m_135782_()));
        }

        public static <T> Optional<ResourceLocation> getObjectRegistryId(T targetObj) {
            return targetObj instanceof ResourceKey ? Optional.of(((ResourceKey)targetObj).m_135782_()) : (targetObj instanceof TagKey ? Optional.of(((TagKey)targetObj).f_203868_()) : Optional.ofNullable(RegistryLookupContainer.getRegistryForObject(targetObj).orElseThrow(() -> new IllegalArgumentException(String.format("Attempted to find registry for unregistered or unmapped object of type %s: %s", targetObj.getClass().getSimpleName(), targetObj))).m_7981_(targetObj)));
        }

        public static <T> ResourceLocation getObjectRegistryIdOrThrow(T targetObj) {
            return RegistryLookupContainer.getObjectRegistryId(targetObj).orElseThrow(() -> new IllegalArgumentException(String.format("No registry entry present for object of type %s: %s", targetObj.getClass().getSimpleName(), targetObj)));
        }

        public static <T> Optional<ResourceKey<T>> getObjectRegistryResourceKey(T targetObj) {
            return targetObj instanceof ResourceKey ? Optional.of((ResourceKey)targetObj) : (targetObj instanceof TagKey ? Optional.of(ResourceKey.m_135785_((ResourceKey)((TagKey)targetObj).f_203867_(), (ResourceLocation)((TagKey)targetObj).f_203868_())) : RegistryLookupContainer.getRegistryForObject(targetObj).orElseThrow(() -> new IllegalArgumentException(String.format("Attempted to find registry for unregistered or unmapped object of type %s: %s", targetObj.getClass().getSimpleName(), targetObj))).m_7854_(targetObj));
        }
    }
}

