/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.property_wrapper.base.generic;

import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapperBuilder;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface PropertyWrapper<T, SELF extends PropertyWrapper<T, SELF, BUILDER>, BUILDER extends PropertyWrapperBuilder<T, BUILDER, SELF>> {
    @NotNull
    public Supplier<T> getParentObject();

    public Optional<String> getModId();

    public BUILDER builder(boolean var1);

    default public BUILDER builder() {
        return this.builder(false);
    }

    @NotNull
    public PropertyWrapperBuilder<T, BUILDER, SELF> constructBuilder();

    public Optional<? extends PropertyWrapperBuilder<T, BUILDER, SELF>> rawBuilder();

    public boolean isTemplate();

    public static Object2ObjectOpenCustomHashMap<Supplier<?>, PropertyWrapper<?, ? extends PropertyWrapper<?, ?, ?>, ? extends PropertyWrapperBuilder<?, ?, ?>>> getMappedPropertyWrappers() {
        return new Object2ObjectOpenCustomHashMap(PropertyWrappersContainer.MAPPED_PROPERTY_WRAPPERS, new Hash.Strategy<Supplier<?>>(){

            public int hashCode(Supplier<?> o) {
                return o.get().hashCode();
            }

            public boolean equals(Supplier<?> a, Supplier<?> b) {
                return a != null && b != null && Objects.equals(a.get(), b.get());
            }
        });
    }

    public static class PropertyWrappersContainer {
        private static final Object2ObjectOpenCustomHashMap<Supplier<?>, PropertyWrapper<?, ? extends PropertyWrapper<?, ?, ?>, ? extends PropertyWrapperBuilder<?, ?, ?>>> MAPPED_PROPERTY_WRAPPERS = new Object2ObjectOpenCustomHashMap(new Hash.Strategy<Supplier<?>>(){

            public int hashCode(Supplier<?> o) {
                try {
                    return o.get() == null ? 0 : o.get().hashCode();
                }
                catch (NullPointerException npe) {
                    if (NexusServices.PLATFORM_MANAGER.isDevelopmentEnvironment()) {
                        NexusConstants.LOGGER.debug("Exception trying to hash Supplier value - In this case, it's most likely Forge's RegistryObject acting up due to PropertyWrappersContainer being initialized before deferred registration. You can ignore this warning; the custom Hash.Strategy comparisons for mapped objects (blocks, items, etc.) will still work as intended later beyond this point during runtime.", (Throwable)npe);
                    }
                    return o == null ? 0 : o.hashCode();
                }
            }

            public boolean equals(Supplier<?> a, Supplier<?> b) {
                if (a == b) {
                    return true;
                }
                if (a == null || b == null) {
                    return false;
                }
                try {
                    return Objects.equals(a.get(), b.get());
                }
                catch (NullPointerException npe) {
                    if (NexusServices.PLATFORM_MANAGER.isDevelopmentEnvironment()) {
                        NexusConstants.LOGGER.debug("Exception trying to compare Supplier values - In this case, it's most likely Forge's RegistryObjects acting up due to PropertyWrappersContainer being initialized before deferred registration. You can ignore this warning; the custom Hash.Strategy comparisons for mapped objects (blocks, items, etc.) will still work as intended later beyond this point during runtime.", (Throwable)npe);
                    }
                    return Objects.equals(a, b);
                }
            }
        });
        private static final Object2ObjectOpenHashMap<Class<?>, Map<String, List<PropertyWrapper<?, ? extends PropertyWrapper<?, ?, ?>, ? extends PropertyWrapperBuilder<?, ?, ?>>>>> CACHED_WRAPPER_LOOKUP = new Object2ObjectOpenHashMap();

        private PropertyWrappersContainer() {
            throw new IllegalAccessError("Attempted to construct instance of container class! (PropertyWrappersContainer)");
        }

        public static <T, PW extends PropertyWrapper<T, PW, PWB>, PWB extends PropertyWrapperBuilder<T, PWB, PW>> PW registerPropertyWrapper(Supplier<T> parentObject, PW propertyWrapper) {
            if (!propertyWrapper.isTemplate()) {
                MAPPED_PROPERTY_WRAPPERS.putIfAbsent(parentObject, propertyWrapper);
            }
            return propertyWrapper;
        }

        public static <T> void unregisterPropertyWrapper(Supplier<T> parentObject) {
            MAPPED_PROPERTY_WRAPPERS.remove(parentObject);
        }

        public static <T, PW extends PropertyWrapper<T, PW, PWB>, PWB extends PropertyWrapperBuilder<T, PWB, PW>> ObjectArrayList<PW> getWrappersOfType(Class<? extends PW> propertyWrapperTypeClass) {
            return (ObjectArrayList)((Map)CACHED_WRAPPER_LOOKUP.computeIfAbsent(propertyWrapperTypeClass, k -> new Object2ObjectOpenHashMap())).computeIfAbsent("*", modId -> (List)MAPPED_PROPERTY_WRAPPERS.values().stream().filter(propertyWrapperTypeClass::isInstance).map(propertyWrapperTypeClass::cast).collect(Collectors.toCollection(ObjectArrayList::new)));
        }

        public static <PW extends PropertyWrapper<?, ?, ?>> ObjectArrayList<PW> getInferrableWrappersOfType(Class<?> propertyWrapperTypeClass) {
            return (ObjectArrayList)((Map)CACHED_WRAPPER_LOOKUP.computeIfAbsent(propertyWrapperTypeClass, k -> new Object2ObjectOpenHashMap())).computeIfAbsent("*", modId -> (List)MAPPED_PROPERTY_WRAPPERS.values().stream().filter(propertyWrapperTypeClass::isInstance).collect(Collectors.toCollection(ObjectArrayList::new)));
        }

        public static <T, PW extends PropertyWrapper<T, PW, PWB>, PWB extends PropertyWrapperBuilder<T, PWB, PW>> ObjectArrayList<PW> getWrappersFromMod(String modId) {
            return (ObjectArrayList)((Map)CACHED_WRAPPER_LOOKUP.computeIfAbsent(PropertyWrapper.class, k -> new Object2ObjectOpenHashMap())).computeIfAbsent(modId, curModId -> (List)MAPPED_PROPERTY_WRAPPERS.values().stream().filter(propertyWrapper -> propertyWrapper.getModId().map(curModId::equals).orElse(false)).collect(Collectors.toCollection(ObjectArrayList::new)));
        }

        public static <PW extends PropertyWrapper<?, ?, ?>> ObjectArrayList<PW> getInferrableWrappersFromMod(String modId) {
            return (ObjectArrayList)((Map)CACHED_WRAPPER_LOOKUP.computeIfAbsent(PropertyWrapper.class, k -> new Object2ObjectOpenHashMap())).computeIfAbsent(modId, curModId -> (List)MAPPED_PROPERTY_WRAPPERS.values().stream().filter(propertyWrapper -> propertyWrapper.getModId().map(curModId::equals).orElse(false)).collect(Collectors.toCollection(ObjectArrayList::new)));
        }

        public static <T, PW extends PropertyWrapper<T, PW, PWB>, PWB extends PropertyWrapperBuilder<T, PWB, PW>> ObjectArrayList<PW> getWrappersOfType(Class<? extends PW> propertyWrapperTypeClass, String modId) {
            return (ObjectArrayList)((Map)CACHED_WRAPPER_LOOKUP.computeIfAbsent(propertyWrapperTypeClass, k -> new Object2ObjectOpenHashMap())).computeIfAbsent(modId, curModId -> (List)MAPPED_PROPERTY_WRAPPERS.values().stream().filter(propertyWrapper -> {
                if (!propertyWrapperTypeClass.isInstance(propertyWrapper)) return false;
                if (propertyWrapper.getModId().map(modId::equals).orElse(false) == false) return false;
                return true;
            }).map(propertyWrapperTypeClass::cast).collect(Collectors.toCollection(ObjectArrayList::new)));
        }

        public static <PW extends PropertyWrapper<?, ?, ?>> ObjectArrayList<PW> getInferrableWrappersOfType(Class<?> pwClazz, String modId) {
            return (ObjectArrayList)((Map)CACHED_WRAPPER_LOOKUP.computeIfAbsent(pwClazz, k -> new Object2ObjectOpenHashMap())).computeIfAbsent(modId, curModId -> (List)MAPPED_PROPERTY_WRAPPERS.values().stream().filter(propertyWrapper -> {
                if (!pwClazz.isInstance(propertyWrapper)) return false;
                if (propertyWrapper.getModId().map(modId::equals).orElse(false) == false) return false;
                return true;
            }).map(pw -> pw).collect(Collectors.toCollection(ObjectArrayList::new)));
        }

        public static <PW extends PropertyWrapper<?, ?, ?>> ObjectArrayList<PW> getInferrableDataGennableWrappersOfType(Class<?> pwClazz, String modId) {
            return PropertyWrappersContainer.getInferrableWrappersOfType(pwClazz, modId).stream().filter(propertyWrapper -> {
                DataGenPropertyWrapper dgpw;
                return pwClazz.isInstance(propertyWrapper) && propertyWrapper instanceof DataGenPropertyWrapper && !(dgpw = (DataGenPropertyWrapper)propertyWrapper).isExcludedFromDataGen();
            }).map(propertyWrapper -> propertyWrapper).collect(Collectors.toCollection(ObjectArrayList::new));
        }

        public static <PW extends PropertyWrapper<?, ? extends PropertyWrapper<?, ?, ?>, ? extends PropertyWrapperBuilder<?, ?, ?>>> Optional<PW> getWrapperFor(Supplier<?> parentObjSup) {
            return Optional.ofNullable((PropertyWrapper)MAPPED_PROPERTY_WRAPPERS.get(parentObjSup));
        }

        public static <PW extends PropertyWrapper<?, ? extends PropertyWrapper<?, ?, ?>, ? extends PropertyWrapperBuilder<?, ?, ?>>> Optional<PW> getWrapperFor(Object parentObj) {
            return PropertyWrappersContainer.getWrapperFor(() -> parentObj);
        }
    }
}

