/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.property_wrapper.base.specialised.language;

import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapperBuilder;
import com.mememan.nexus.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public interface LanguageBasedPropertyWrapper<T, SELF extends PropertyWrapper<T, SELF, BUILDER>, BUILDER extends PropertyWrapperBuilder<T, BUILDER, SELF>>
extends DataGenPropertyWrapper<T, SELF, BUILDER> {
    public Optional<String> getCustomName();

    public Optional<Function<String, String>> getObjectPostTranslationMapper();

    public List<String> getCustomSeparatorWords();

    public boolean hasLiteralTranslation();

    public boolean bypassesDefaultTranslation();

    public Map<String, Function<String, String>> getAdditionalLocalizationKeys();

    default public Optional<String> getLocalizedObjectKey(@Nullable BiConsumer<String, String> postTranslationLoggingCallback) {
        String unlocalizedKey = this.getObjectDescriptionId();
        return Optional.ofNullable(this.getCustomName().orElseGet(() -> {
            if (this.hasLiteralTranslation()) {
                return StringUtil.literallyLocalize(unlocalizedKey, this.getCustomSeparatorWords());
            }
            if (this.bypassesDefaultTranslation()) {
                return null;
            }
            return StringUtil.localizeWithDefaultAssertions(unlocalizedKey, this.getCustomSeparatorWords());
        })).map(locVal -> {
            if (this.getObjectPostTranslationMapper().isPresent()) {
                String mappedValue = this.getObjectPostTranslationMapper().get().apply((String)locVal);
                if (postTranslationLoggingCallback != null) {
                    postTranslationLoggingCallback.accept((String)locVal, mappedValue);
                }
                return mappedValue;
            }
            return locVal;
        });
    }
}

