/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.property_wrapper.base.specialised.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mememan.nexus.client.model.general.ModelElement;
import com.mememan.nexus.client.model.general.ModelGuiLight;
import com.mememan.nexus.client.model.general.ModelTransform;
import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapperBuilder;
import com.mememan.nexus.util.JsonUtil;
import com.mememan.nexus.util.ResourceLocationUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;
import org.joml.Vector3f;

public interface ModelBasedPropertyWrapper<T, SELF extends PropertyWrapper<T, SELF, BUILDER>, BUILDER extends PropertyWrapperBuilder<T, BUILDER, SELF>>
extends DataGenPropertyWrapper<T, SELF, BUILDER> {
    public Optional<Function<Supplier<T>, ModelDefinition>> getModelDefinition();

    public static interface ModelDefinition {
        public ModelDefinition withOrdinalModelDefinition(ModelDefinition var1);

        public ModelDefinition withOrdinalModelDefinitions(Collection<ModelDefinition> var1);

        public ModelDefinition setOrdinalModelDefinitions(Collection<ModelDefinition> var1);

        default public ModelDefinition withOrdinalModelDefinitions(ModelDefinition ... modelDefinition) {
            return this.withOrdinalModelDefinitions((Collection<ModelDefinition>)ObjectArrayList.of((Object[])modelDefinition));
        }

        public ModelDefinition withCustomName(String var1);

        public ModelDefinition appendToBackingDirectory(String var1);

        public ModelDefinition withTextureMapping(TextureMapping var1);

        public ModelDefinition withRenderType(ResourceLocation var1);

        public ModelDefinition withGuiLight(ModelGuiLight var1);

        public ModelDefinition withAmbientOcclusion(boolean var1);

        public ModelDefinition withTransform(ItemDisplayContext var1, ModelTransform var2);

        public ModelDefinition withTransforms(Map<ItemDisplayContext, ModelTransform> var1);

        public ModelDefinition setTransforms(Map<ItemDisplayContext, ModelTransform> var1);

        public ModelDefinition withElement(ModelElement var1);

        public ModelDefinition withElements(Collection<ModelElement> var1);

        public ModelDefinition withElements(ModelElement ... var1);

        public ModelDefinition setElements(Collection<ModelElement> var1);

        @NotNull
        public ModelTemplate getParentModel();

        public Optional<TextureMapping> getTextureMapping();

        public Optional<String> getCustomModelName();

        public Optional<String> getBackingDirectory();

        public Optional<ResourceLocation> getRenderType();

        public Optional<ModelGuiLight> getGuiLight();

        public boolean hasAmbientOcclusion();

        public Map<ItemDisplayContext, ModelTransform> getModelTransforms();

        public List<ModelElement> getModelElements();

        public List<ModelDefinition> getOrdinalModelDefinitions();

        default public List<ModelDefinition> getFlattenedModelDefinitions() {
            if (this.getOrdinalModelDefinitions().isEmpty()) {
                return ObjectArrayList.of();
            }
            ObjectArrayList flattenedDefinitions = new ObjectArrayList();
            LinkedList<ModelDefinition> toProcess = new LinkedList<ModelDefinition>(this.getOrdinalModelDefinitions());
            ObjectOpenHashSet processed = new ObjectOpenHashSet();
            while (!toProcess.isEmpty()) {
                ModelDefinition next = (ModelDefinition)toProcess.poll();
                if (!processed.add(next)) continue;
                flattenedDefinitions.add(next);
                if (next.getOrdinalModelDefinitions().isEmpty()) continue;
                toProcess.addAll(next.getOrdinalModelDefinitions());
            }
            return flattenedDefinitions;
        }

        default public JsonObject constructJson(ResourceLocation finalizedModelLoc, Supplier<JsonElement> baseModelJson) {
            JsonObject baseSerializedModelJson = baseModelJson.get().getAsJsonObject();
            boolean hasAO = this.hasAmbientOcclusion();
            if (!hasAO) {
                baseSerializedModelJson.addProperty("ambientocclusion", Boolean.valueOf(hasAO));
            }
            this.getGuiLight().ifPresent(guiLight -> baseSerializedModelJson.addProperty("gui_light", guiLight.m_7912_()));
            this.getRenderType().ifPresent(renderType -> baseSerializedModelJson.addProperty("render_type", renderType.toString()));
            Map<ItemDisplayContext, ModelTransform> modelTransforms = this.getModelTransforms();
            List<ModelElement> modelElements = this.getModelElements();
            if (!modelTransforms.isEmpty()) {
                JsonObject modelTransformsMap = new JsonObject();
                modelTransforms.forEach((transformName, transform) -> {
                    JsonObject transformJsonObj = new JsonObject();
                    if (transform.hasRotation()) {
                        transformJsonObj.add("rotation", (JsonElement)JsonUtil.createVec3fArray(transform.rotation()));
                    }
                    if (transform.hasTranslation()) {
                        transformJsonObj.add("translation", (JsonElement)JsonUtil.createVec3fArray(transform.translation()));
                    }
                    if (transform.hasScale()) {
                        transformJsonObj.add("scale", (JsonElement)JsonUtil.createVec3fArray(transform.scale()));
                    }
                    modelTransformsMap.add(transformName.m_7912_(), (JsonElement)transformJsonObj);
                });
                baseSerializedModelJson.add("display", (JsonElement)modelTransformsMap);
            }
            if (!modelElements.isEmpty()) {
                JsonArray modelElementsArray = new JsonArray();
                modelElements.forEach(curElement -> {
                    JsonObject elementObj = new JsonObject();
                    Vector3f from = curElement.from();
                    Vector3f to = curElement.to();
                    boolean hasShade = curElement.shade();
                    if (from != null) {
                        elementObj.add("from", (JsonElement)JsonUtil.createVec3fArray(from));
                    }
                    if (to != null) {
                        elementObj.add("to", (JsonElement)JsonUtil.createVec3fArray(to));
                    }
                    if (!hasShade) {
                        elementObj.addProperty("shade", Boolean.valueOf(hasShade));
                    }
                    ModelElement.ElementRotationData rotationData = curElement.rotation();
                    Map<Direction, ModelElement.ElementFaceData> elementFaces = curElement.faces();
                    if (rotationData != null) {
                        JsonObject rotationDataObj = new JsonObject();
                        Vector3f origin = rotationData.origin();
                        Direction.Axis axis = rotationData.axis();
                        float angle = rotationData.angle();
                        boolean shouldRescale = rotationData.rescale();
                        if (origin != null) {
                            rotationDataObj.add("origin", (JsonElement)JsonUtil.createVec3fArray(origin));
                        }
                        if (axis != null) {
                            rotationDataObj.addProperty("axis", axis.m_7912_());
                        }
                        if (rotationData.hasValidAngle()) {
                            rotationDataObj.addProperty("angle", (Number)Float.valueOf(angle));
                        }
                        if (shouldRescale) {
                            rotationDataObj.addProperty("rescale", Boolean.valueOf(shouldRescale));
                        }
                        elementObj.add("rotation", (JsonElement)rotationDataObj);
                    }
                    if (elementFaces != null && !elementFaces.isEmpty()) {
                        JsonObject facesObj = new JsonObject();
                        elementFaces.forEach((faceDir, faceData) -> {
                            JsonObject faceDataObj = new JsonObject();
                            ModelElement.FaceUVData uvData = faceData.uv();
                            String targetTextureOrKey = faceData.formattedTextureKey();
                            Direction cullFaceDir = faceData.cullFace();
                            if (uvData != null) {
                                Vector2f uvFrom = uvData.from();
                                Vector2f uvTo = uvData.to();
                                if (uvFrom != null && uvTo != null) {
                                    faceDataObj.add("uv", (JsonElement)JsonUtil.flatConcatVec2fArrays(uvFrom, uvTo));
                                }
                            }
                            if (targetTextureOrKey != null) {
                                faceDataObj.addProperty("texture", ResourceLocationUtil.formatModelUVTexture(targetTextureOrKey));
                            }
                            if (cullFaceDir != null) {
                                faceDataObj.addProperty("cullface", cullFaceDir.m_7912_());
                            }
                            if (faceData.hasTintIndex()) {
                                faceDataObj.addProperty("tintindex", (Number)faceData.tintIndex());
                            }
                            facesObj.add(faceDir.m_7912_(), (JsonElement)faceDataObj);
                        });
                        elementObj.add("faces", (JsonElement)facesObj);
                    }
                    modelElementsArray.add((JsonElement)elementObj);
                });
                baseSerializedModelJson.add("elements", (JsonElement)modelElementsArray);
            }
            return baseSerializedModelJson;
        }
    }
}

