/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.property_wrapper.def.block;

import com.mememan.nexus.client.block.BlockStateDefinition;
import com.mememan.nexus.client.block.WrappedBlockColor;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.specialised.vanilla.DefaultableVanillaBasedPropertyWrapperBuilder;
import com.mememan.nexus.property_wrapper.def.block.BlockPropertyWrapper;
import com.mememan.nexus.property_wrapper.impl.generic.misc.BaseDefaultableDataGenPropertyWrapperBuilder;
import com.mememan.nexus.property_wrapper.impl.specialised.vanilla.SpecializedVanillaPropertyWrapperBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BlockPropertyWrapperBuilder<B extends Block>
extends BaseDefaultableDataGenPropertyWrapperBuilder<B, BlockPropertyWrapperBuilder<B>, BlockPropertyWrapper<B>>
implements DefaultableVanillaBasedPropertyWrapperBuilder<B, BlockPropertyWrapperBuilder<B>, BlockPropertyWrapper<B>> {
    protected final SpecializedVanillaPropertyWrapperBuilder<B, BlockPropertyWrapperBuilder<B>, BlockPropertyWrapper<B>> compositeVanillaBuilder;
    protected Optional<Function<Supplier<B>, BlockStateDefinition>> blockStateDefMapperFunc = Optional.empty();
    protected Optional<Function<Supplier<B>, WrappedBlockColor>> blockColorMappingFunc = Optional.empty();
    protected Optional<Function<Supplier<B>, IntIntMutablePair>> flammabilityMappingFunc = Optional.empty();
    protected Optional<Function<BlockState, BlockState>> blockStrippingMappingFunc = Optional.empty();
    protected Optional<Function<Supplier<B>, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>>> blockTillingMappingFunc = Optional.empty();
    protected Optional<Function<BlockState, BlockState>> blockFlatteningMappingFunc = Optional.empty();
    protected Optional<Function<Supplier<B>, Supplier<Block>>> blockOxidizationMappingFunc = Optional.empty();
    protected Optional<Function<Supplier<B>, Supplier<Block>>> blockWaxingMappingFunc = Optional.empty();
    protected int minMiningLevel = 0;

    public BlockPropertyWrapperBuilder(@NotNull BlockPropertyWrapper<B> ownerWrapper) {
        super(ownerWrapper);
        this.compositeVanillaBuilder = ownerWrapper.getSpecializedVanillaWrapper().map(PropertyWrapper::builder).get();
    }

    @Override
    public BlockPropertyWrapperBuilder<B> copyFrom(BlockPropertyWrapper<B> propertyWrapper) {
        DefaultableVanillaBasedPropertyWrapperBuilder.super.copyFrom(propertyWrapper);
        return ((BlockPropertyWrapperBuilder)super.copyFrom(propertyWrapper)).withBlockStateDefinition(propertyWrapper.getBlockStateDefinition().orElse(null)).withBlockColor(propertyWrapper.getBlockColorMapper().orElse(null)).withFlammability(propertyWrapper.getFlammabilityMapper().orElse(null)).withBlockStripping(propertyWrapper.getBlockStrippingMapper().orElse(null)).withBlockTilling(propertyWrapper.getBlockTillingMapper().orElse(null)).withBlockFlattening(propertyWrapper.getBlockFlatteningMapper().orElse(null)).withBlockOxidization(propertyWrapper.getBlockOxidizationMapper().orElse(null)).withBlockWaxing(propertyWrapper.getBlockWaxingMapper().orElse(null));
    }

    public BlockPropertyWrapperBuilder<B> withBlockStateDefinition(Function<Supplier<B>, BlockStateDefinition> bsdMappingFunc) {
        this.blockStateDefMapperFunc = Optional.ofNullable(bsdMappingFunc);
        return (BlockPropertyWrapperBuilder)this.self();
    }

    public BlockPropertyWrapperBuilder<B> withBlockColor(Function<Supplier<B>, WrappedBlockColor> blockColorMappingFunc) {
        this.blockColorMappingFunc = Optional.ofNullable(blockColorMappingFunc);
        return (BlockPropertyWrapperBuilder)this.self();
    }

    public BlockPropertyWrapperBuilder<B> withFlammability(Function<Supplier<B>, IntIntMutablePair> flammabilityMappingFunc) {
        this.flammabilityMappingFunc = Optional.ofNullable(flammabilityMappingFunc);
        return (BlockPropertyWrapperBuilder)this.self();
    }

    public BlockPropertyWrapperBuilder<B> withBlockStripping(Function<BlockState, BlockState> blockStrippingMappingFunc) {
        this.blockStrippingMappingFunc = Optional.ofNullable(blockStrippingMappingFunc);
        return (BlockPropertyWrapperBuilder)this.self();
    }

    public BlockPropertyWrapperBuilder<B> withBlockTilling(Function<Supplier<B>, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>> blockTillingMappingFunc) {
        this.blockTillingMappingFunc = Optional.ofNullable(blockTillingMappingFunc);
        return (BlockPropertyWrapperBuilder)this.self();
    }

    public BlockPropertyWrapperBuilder<B> withBlockFlattening(Function<BlockState, BlockState> blockFlatteningMappingFunc) {
        this.blockFlatteningMappingFunc = Optional.ofNullable(blockFlatteningMappingFunc);
        return (BlockPropertyWrapperBuilder)this.self();
    }

    public BlockPropertyWrapperBuilder<B> withBlockOxidization(Function<Supplier<B>, Supplier<Block>> blockOxidizationMappingFunc) {
        this.blockOxidizationMappingFunc = Optional.ofNullable(blockOxidizationMappingFunc);
        return (BlockPropertyWrapperBuilder)this.self();
    }

    public BlockPropertyWrapperBuilder<B> withBlockWaxing(Function<Supplier<B>, Supplier<Block>> blockWaxingMappingFunc) {
        this.blockWaxingMappingFunc = Optional.ofNullable(blockWaxingMappingFunc);
        return (BlockPropertyWrapperBuilder)this.self();
    }

    public BlockPropertyWrapperBuilder<B> minimumMiningLevel(int miningLevel) {
        this.minMiningLevel = Math.abs(miningLevel);
        return (BlockPropertyWrapperBuilder)this.self();
    }

    @Override
    public Optional<SpecializedVanillaPropertyWrapperBuilder<B, BlockPropertyWrapperBuilder<B>, BlockPropertyWrapper<B>>> getSpecializedVanillaBuilder() {
        return Optional.of(this.compositeVanillaBuilder);
    }
}

