/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.property_wrapper.def.tag;

import com.mememan.nexus.property_wrapper.def.tag.TagPropertyWrapper;
import com.mememan.nexus.property_wrapper.impl.specialised.tag.SpecializedTagPropertyWrapperBuilder;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public class TagPropertyWrapperBuilder<T, TK extends TagKey<T>>
extends SpecializedTagPropertyWrapperBuilder<TK, TagPropertyWrapperBuilder<T, TK>, TagPropertyWrapper<T, TK>> {
    protected final List<Supplier<T>> storedTaggedObjects = new ObjectArrayList();
    protected final List<Supplier<TK>> storedTags = new ObjectArrayList();
    protected Optional<Integer> cookTime = Optional.empty();
    protected Optional<IntIntMutablePair> flammabilityPair = Optional.empty();

    public TagPropertyWrapperBuilder(@NotNull TagPropertyWrapper<T, TK> ownerWrapper) {
        super(ownerWrapper);
    }

    @Override
    public TagPropertyWrapperBuilder<T, TK> copyFrom(TagPropertyWrapper<T, TK> propertyWrapper) {
        return ((TagPropertyWrapperBuilder)super.copyFrom(propertyWrapper)).setTaggedObjects(propertyWrapper.getTaggedObjects()).setChildTags(propertyWrapper.getChildTags()).withCookTime(propertyWrapper.getCookTime().orElse(null)).withFlammability(propertyWrapper.getFlammabilityPair().orElse(null));
    }

    public TagPropertyWrapperBuilder<T, TK> withTaggedObject(Supplier<T> taggedObject) {
        this.storedTaggedObjects.add(taggedObject);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withTaggedObjects(Supplier<T> ... taggedObjects) {
        return this.withTaggedObjects((List<Supplier<T>>)ObjectArrayList.of((Object[])taggedObjects));
    }

    public TagPropertyWrapperBuilder<T, TK> withTaggedObjects(List<Supplier<T>> taggedObjects) {
        this.storedTaggedObjects.addAll(taggedObjects);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> setTaggedObjects(List<Supplier<T>> taggedObjects) {
        this.storedTaggedObjects.clear();
        this.storedTaggedObjects.addAll(taggedObjects);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withChildTag(Supplier<TK> tag) {
        this.storedTags.add(tag);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withChildTags(Supplier<TK> ... tags) {
        return this.withChildTags((List<Supplier<TK>>)ObjectArrayList.of((Object[])tags));
    }

    public TagPropertyWrapperBuilder<T, TK> withChildTags(List<Supplier<TK>> tags) {
        this.storedTags.addAll(tags);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> setChildTags(List<Supplier<TK>> tags) {
        this.storedTags.clear();
        this.storedTags.addAll(tags);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withTaggedObjectOfType(Supplier<? extends T> taggedObject) {
        this.storedTaggedObjects.add(taggedObject);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withTaggedObjectsOfType(Supplier<? extends T> ... taggedObjects) {
        return this.withTaggedObjectsOfType((List<Supplier<? extends T>>)ObjectArrayList.of((Object[])taggedObjects));
    }

    public TagPropertyWrapperBuilder<T, TK> withTaggedObjectsOfType(List<Supplier<? extends T>> taggedObjects) {
        this.storedTaggedObjects.addAll(taggedObjects);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> setTaggedObjectsOfType(List<Supplier<? extends T>> taggedObjects) {
        this.storedTaggedObjects.clear();
        this.storedTaggedObjects.addAll(taggedObjects);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withChildTagOfType(Supplier<? extends TK> tag) {
        this.storedTags.add(tag);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withChildTagsOfType(Supplier<? extends TK> ... tags) {
        return this.withChildTagsOfType((List<Supplier<? extends TK>>)ObjectArrayList.of((Object[])tags));
    }

    public TagPropertyWrapperBuilder<T, TK> withChildTagsOfType(List<Supplier<? extends TK>> tags) {
        this.storedTags.addAll(tags);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> setChildTagsOfType(List<Supplier<? extends TK>> tags) {
        this.storedTags.clear();
        this.storedTags.addAll(tags);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withCookTime(Integer cookTime) {
        this.cookTime = Optional.ofNullable(Math.abs(cookTime) > 0 ? cookTime : null);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withFlammability(IntIntMutablePair flammabilityPair) {
        this.flammabilityPair = Optional.ofNullable(flammabilityPair);
        return (TagPropertyWrapperBuilder)this.self();
    }

    public TagPropertyWrapperBuilder<T, TK> withFlammability(int igniteChance, int spread) {
        return this.withFlammability(IntIntMutablePair.of((int)igniteChance, (int)spread));
    }
}

