/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.property_wrapper.impl.generic;

import com.google.common.base.Suppliers;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapperBuilder;
import com.mememan.nexus.property_wrapper.impl.generic.BasePropertyWrapperBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasePropertyWrapper<T, SELF extends PropertyWrapper<T, SELF, BUILDER>, BUILDER extends PropertyWrapperBuilder<T, BUILDER, SELF>>
implements PropertyWrapper<T, SELF, BUILDER> {
    protected final Supplier<T> parentObject;
    protected final boolean isTemplate;
    protected final Function<SELF, PropertyWrapperBuilder<T, BUILDER, SELF>> builderFactory;
    protected final Optional<String> modId;
    @Nullable
    protected BUILDER builder;

    public BasePropertyWrapper(Supplier<T> parentObject, boolean isTemplate, Function<SELF, PropertyWrapperBuilder<T, BUILDER, SELF>> builderFactory, String modId) {
        this.parentObject = isTemplate || parentObject == null ? Suppliers.ofInstance(null) : parentObject;
        this.isTemplate = isTemplate;
        this.builderFactory = builderFactory;
        this.modId = Optional.ofNullable(modId);
    }

    public BasePropertyWrapper(@NotNull Supplier<T> parentObject, Function<SELF, PropertyWrapperBuilder<T, BUILDER, SELF>> builderFactory, String modId) {
        this(parentObject, false, builderFactory, modId);
    }

    public BasePropertyWrapper(Function<SELF, PropertyWrapperBuilder<T, BUILDER, SELF>> builderFactory) {
        this(null, true, builderFactory, null);
    }

    public BasePropertyWrapper(Supplier<T> parentObject, boolean isTemplate, Function<SELF, PropertyWrapperBuilder<T, BUILDER, SELF>> builderFactory) {
        this(parentObject, isTemplate, builderFactory, null);
    }

    public BasePropertyWrapper(@NotNull Supplier<T> parentObject, Function<SELF, PropertyWrapperBuilder<T, BUILDER, SELF>> builderFactory) {
        this(parentObject, false, builderFactory);
    }

    public BasePropertyWrapper() {
        this(null, true, BasePropertyWrapperBuilder::new);
    }

    @Override
    @NotNull
    public Supplier<T> getParentObject() {
        return this.parentObject;
    }

    @Override
    public Optional<String> getModId() {
        return this.isTemplate() ? Optional.empty() : this.modId;
    }

    @Override
    public BUILDER builder(boolean overrideExistingBuilder) {
        PropertyWrapperBuilder<T, Object, Object> propertyWrapperBuilder;
        if (overrideExistingBuilder || this.builder == null) {
            this.builder = this.constructBuilder();
            propertyWrapperBuilder = this.builder;
        } else {
            propertyWrapperBuilder = this.builder;
        }
        return (BUILDER)propertyWrapperBuilder;
    }

    @Override
    public Optional<BUILDER> rawBuilder() {
        return Optional.ofNullable(this.builder);
    }

    @Override
    @NotNull
    public PropertyWrapperBuilder<T, BUILDER, SELF> constructBuilder() {
        return this.builderFactory.apply(this);
    }

    @Override
    public boolean isTemplate() {
        return this.isTemplate;
    }
}

