/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.resource.reload_listeners;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mememan.nexus.util.ClientUtil;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DefaultedCodecResourceReloadListener<T>
extends SimpleJsonResourceReloadListener {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @NotNull
    protected final ResourceLocation listenerDirectoryId;
    @NotNull
    protected final Codec<T> objectCodec;
    @Nullable
    protected Map<ResourceLocation, T> objectMap;

    public DefaultedCodecResourceReloadListener(ResourceLocation listenerDirectoryId, @NotNull Codec<T> objectCodec) {
        super(GSON, listenerDirectoryId.m_135815_());
        this.listenerDirectoryId = listenerDirectoryId;
        this.objectCodec = objectCodec;
    }

    protected void apply(Map<ResourceLocation, JsonElement> serializedObjectMap, ResourceManager resourceManager, ProfilerFiller profileFiller) {
        if (serializedObjectMap.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap updatedObjectMap = new Object2ObjectOpenHashMap(serializedObjectMap.size());
        for (Map.Entry<ResourceLocation, JsonElement> entry : serializedObjectMap.entrySet()) {
            ResourceLocation targetObjId = entry.getKey();
            this.objectCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(errorMsg -> LOGGER.warn("Failed to parse entry of resource location {} with error: {}", (Object)targetObjId, errorMsg)).ifPresent(parsedObj -> updatedObjectMap.put((Object)targetObjId, parsedObj));
        }
        this.objectMap = updatedObjectMap;
    }

    @NotNull
    public ResourceLocation getListenerDirectoryId() {
        return this.listenerDirectoryId;
    }

    @NotNull
    public String getDirectory() {
        return this.getListenerDirectoryId().m_135815_();
    }

    @NotNull
    public Codec<T> getObjectCodec() {
        return this.objectCodec;
    }

    public Map<ResourceLocation, T> getMappedObjectData() {
        return this.objectMap == null ? ImmutableMap.of() : ImmutableMap.copyOf(this.objectMap);
    }

    @ApiStatus.Internal
    public void updateSyncedObjectData(Map<ResourceLocation, T> syncedObjectMap) {
        if (ClientUtil.onClient()) {
            this.objectMap = syncedObjectMap;
        }
    }
}

