/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.template.object.block.vegetation;

import com.google.common.base.Suppliers;
import com.mememan.nexus.util.RegistryUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultableFarmBlock
extends FarmBlock {
    protected final Supplier<Block> mappedDirtBlock;

    public DefaultableFarmBlock(BlockBehaviour.Properties properties, Supplier<Block> mappedDirtBlock) {
        super(properties);
        this.mappedDirtBlock = mappedDirtBlock == null ? Suppliers.ofInstance(null) : mappedDirtBlock;
    }

    public DefaultableFarmBlock(BlockBehaviour.Properties properties) {
        super(properties);
        Supplier<Block> ownerRefSup = () -> this;
        this.mappedDirtBlock = RegistryUtil.getSuppliedObjectFrom(ownerRefSup, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_farmland", "_dirt"))).orElse(RegistryUtil.getSuppliedObjectFrom(ownerRefSup, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_farmland", ""))).orElse(null));
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return !this.m_49966_().m_60710_((LevelReader)ctx.m_43725_(), ctx.m_8083_()) && this.mappedDirtBlock.get() != null ? this.mappedDirtBlock.get().m_49966_() : super.m_5573_(ctx);
    }

    public void m_213897_(BlockState targetState, ServerLevel curServerLevel, BlockPos targetPos, RandomSource randSrc) {
        if (!targetState.m_60710_((LevelReader)curServerLevel, targetPos)) {
            DefaultableFarmBlock.convertToMappedDirt(null, targetState, (Level)curServerLevel, targetPos);
        }
    }

    public void m_213898_(BlockState targetState, ServerLevel curServerLevel, BlockPos targetPos, RandomSource randSrc) {
        int curMoisture = (Integer)targetState.m_61143_((Property)f_53243_);
        if (!DefaultableFarmBlock.m_53258_((LevelReader)curServerLevel, targetPos) && !curServerLevel.m_46758_(targetPos.m_7494_())) {
            if (curMoisture > 0) {
                curServerLevel.m_7731_(targetPos, (BlockState)targetState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(curMoisture - 1)), 2);
            } else if (!DefaultableFarmBlock.m_53250_((BlockGetter)curServerLevel, targetPos)) {
                DefaultableFarmBlock.convertToMappedDirt(null, targetState, (Level)curServerLevel, targetPos);
            }
        } else if (curMoisture < 7) {
            curServerLevel.m_7731_(targetPos, (BlockState)targetState.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void m_142072_(Level curLevel, BlockState targetState, BlockPos targetPos, Entity fallingEntity, float fallDistance) {
        if (!curLevel.f_46443_ && curLevel.f_46441_.m_188501_() < fallDistance - 0.5f && fallingEntity instanceof LivingEntity && (fallingEntity instanceof Player || curLevel.m_46469_().m_46207_(GameRules.f_46132_)) && fallingEntity.m_20205_() * fallingEntity.m_20205_() * fallingEntity.m_20206_() > 0.512f) {
            DefaultableFarmBlock.convertToMappedDirt(fallingEntity, targetState, curLevel, targetPos);
        }
        fallingEntity.m_142535_(fallDistance, 1.0f, fallingEntity.m_269291_().m_268989_());
    }

    @NotNull
    public Supplier<Block> getMappedDirtBlock() {
        return this.mappedDirtBlock;
    }

    public static void convertToMappedDirt(@Nullable Entity responsibleEntity, BlockState targetState, Level curLevel, BlockPos targetPos) {
        Block block = targetState.m_60734_();
        if (block instanceof DefaultableFarmBlock) {
            DefaultableFarmBlock customizableFarmBlock = (DefaultableFarmBlock)block;
            Supplier<Block> dirtBlock = customizableFarmBlock.getMappedDirtBlock();
            BlockState updatedState = DefaultableFarmBlock.m_49897_((BlockState)targetState, (BlockState)(dirtBlock.get() == null ? Blocks.f_50493_.m_49966_() : dirtBlock.get().m_49966_()), (LevelAccessor)curLevel, (BlockPos)targetPos);
            curLevel.m_46597_(targetPos, updatedState);
            curLevel.m_220407_(GameEvent.f_157792_, targetPos, GameEvent.Context.m_223719_((Entity)responsibleEntity, (BlockState)updatedState));
        }
    }

    public static boolean m_53250_(BlockGetter blockGetter, BlockPos targetPos) {
        return blockGetter.m_8055_(targetPos.m_7494_()).m_204336_(BlockTags.f_279534_);
    }

    public static boolean m_53258_(LevelReader curLevel, BlockPos targetPos) {
        for (BlockPos curPos : BlockPos.m_121940_((BlockPos)targetPos.m_7918_(-4, 0, -4), (BlockPos)targetPos.m_7918_(4, 1, 4))) {
            if (!curLevel.m_6425_(curPos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }
}

