/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.template.object.block.vegetation;

import com.google.common.base.Suppliers;
import com.mememan.nexus.util.RegistryUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.SpreadingSnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import org.jetbrains.annotations.NotNull;

public class DefaultableSpreadingSnowyDirtBlock
extends SpreadingSnowyDirtBlock {
    protected final boolean allowSnowyVariant;
    protected final Set<Supplier<TagKey<Block>>> validSnowyTags;
    protected final Supplier<Block> baseDirtBlock;

    public DefaultableSpreadingSnowyDirtBlock(BlockBehaviour.Properties properties, boolean allowSnowyVariant, Set<Supplier<TagKey<Block>>> validSnowyTags, Supplier<Block> baseDirtBlock) {
        super(properties);
        this.allowSnowyVariant = allowSnowyVariant;
        this.validSnowyTags = validSnowyTags;
        this.baseDirtBlock = baseDirtBlock;
    }

    public DefaultableSpreadingSnowyDirtBlock(BlockBehaviour.Properties properties, boolean allowSnowyVariant, Set<Supplier<TagKey<Block>>> validSnowyTags) {
        super(properties);
        this.allowSnowyVariant = allowSnowyVariant;
        this.validSnowyTags = validSnowyTags;
        Supplier<Block> ownerRefSup = () -> this;
        this.baseDirtBlock = RegistryUtil.getSuppliedObjectFrom(ownerRefSup, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_grass_block", "_dirt"))).orElse(RegistryUtil.getSuppliedObjectFrom(ownerRefSup, parentBlockId -> RegistryUtil.pickSuffix(parentBlockId, "_dirt")).orElse((Supplier<Block>)Suppliers.ofInstance(null)));
    }

    public DefaultableSpreadingSnowyDirtBlock(BlockBehaviour.Properties properties, Set<Supplier<TagKey<Block>>> validSnowyTags, Supplier<Block> baseDirtBlock) {
        this(properties, true, validSnowyTags, baseDirtBlock);
    }

    public DefaultableSpreadingSnowyDirtBlock(BlockBehaviour.Properties properties, boolean allowSnowyVariant, Supplier<Block> baseDirtBlock) {
        this(properties, allowSnowyVariant, (Set<Supplier<TagKey<Block>>>)ObjectOpenHashSet.of(() -> BlockTags.f_144279_), baseDirtBlock);
    }

    public DefaultableSpreadingSnowyDirtBlock(BlockBehaviour.Properties properties, boolean allowSnowyVariant) {
        this(properties, allowSnowyVariant, (Set<Supplier<TagKey<Block>>>)ObjectOpenHashSet.of(() -> BlockTags.f_144279_));
    }

    public DefaultableSpreadingSnowyDirtBlock(BlockBehaviour.Properties properties, Set<Supplier<TagKey<Block>>> validSnowyTags) {
        this(properties, true, validSnowyTags);
    }

    public DefaultableSpreadingSnowyDirtBlock(BlockBehaviour.Properties properties, Supplier<Block> baseDirtBlock) {
        this(properties, false, baseDirtBlock);
    }

    public DefaultableSpreadingSnowyDirtBlock(BlockBehaviour.Properties properties) {
        this(properties, false);
    }

    @NotNull
    public BlockState m_7417_(BlockState targetState, Direction facingDir, BlockState facingState, LevelAccessor curLevel, BlockPos targetPos, BlockPos facingPos) {
        return facingDir == Direction.UP && this.allowSnowyVariant ? (BlockState)targetState.m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(this.allowSnowyVariant(targetState))) : super.m_7417_(targetState, facingDir, facingState, curLevel, targetPos, facingPos);
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_56637_, (Comparable)Boolean.valueOf(this.allowSnowyVariant(ctx.m_43725_().m_8055_(ctx.m_8083_().m_7494_()))));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.baseDirtBlock != null && this.baseDirtBlock.get() != null) {
            if (!this.allowGrassBlock((LevelAccessor)level, state, pos, random)) {
                level.m_46597_(pos, this.baseDirtBlock.get().m_49966_());
            } else if (this.allowSpread((LevelAccessor)level, state, pos, random)) {
                this.performSpread((LevelAccessor)level, state, pos, random);
            }
        }
    }

    public boolean allowSnowyVariant() {
        return this.allowSnowyVariant;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean allowSnowyVariant(BlockState state) {
        if (!this.allowSnowyVariant()) return false;
        if (!this.validSnowyTags.stream().map(Supplier::get).anyMatch(arg_0 -> ((BlockState)state).m_204336_(arg_0))) return false;
        return true;
    }

    public Set<Supplier<TagKey<Block>>> getValidSnowyTags() {
        return this.validSnowyTags;
    }

    public Supplier<Block> getBaseDirtBlock() {
        return this.baseDirtBlock;
    }

    public boolean allowGrassBlock(LevelAccessor curLevel, BlockState targetState, BlockPos targetPos, RandomSource randSrc) {
        BlockPos aboveTargetPos = targetPos.m_7494_();
        BlockState aboveTargetState = curLevel.m_8055_(aboveTargetPos);
        boolean snowSpreadGrass = this.allowSnowyVariant(targetState) && aboveTargetState.m_204336_(BlockTags.f_144279_) && aboveTargetState.m_61138_((Property)SnowLayerBlock.f_56581_) && (Integer)aboveTargetState.m_61143_((Property)SnowLayerBlock.f_56581_) == 1;
        boolean lightSpreadGrass = LightEngine.m_284282_((BlockGetter)curLevel, (BlockState)targetState, (BlockPos)targetPos, (BlockState)aboveTargetState, (BlockPos)aboveTargetPos, (Direction)Direction.UP, (int)aboveTargetState.m_60739_((BlockGetter)curLevel, aboveTargetPos)) < curLevel.m_7469_();
        return snowSpreadGrass || lightSpreadGrass && aboveTargetState.m_60819_().m_76186_() != 8;
    }

    public boolean allowSpread(LevelAccessor curServerLevel, BlockState targetState, BlockPos targetPos, RandomSource randSrc) {
        return curServerLevel.m_46803_(targetPos.m_7494_()) > 9 && this.baseDirtBlock != null && this.baseDirtBlock.get() != null;
    }

    public void performSpread(LevelAccessor serverLevel, BlockState targetState, BlockPos targetPos, RandomSource randSrc) {
        if (this.baseDirtBlock != null && this.baseDirtBlock.get() != null) {
            for (int attempt = 0; attempt < 4; ++attempt) {
                ServerLevel curServerLevel;
                BlockPos offsetPos = targetPos.m_7918_(randSrc.m_188503_(3) - 1, randSrc.m_188503_(5) - 3, randSrc.m_188503_(3) - 1);
                if (!(serverLevel instanceof ServerLevel) || !(curServerLevel = (ServerLevel)serverLevel).m_8055_(offsetPos).m_60713_(this.baseDirtBlock.get())) continue;
                curServerLevel.m_46597_(offsetPos, (BlockState)targetState.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(this.allowSnowyVariant(targetState))));
            }
        }
    }
}

