/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.template.object.client.renderer.entity.misc.vehicle;

import com.google.common.collect.ImmutableMap;
import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.template.object.entity.misc.vehicle.DefaultableBoatType;
import com.mememan.nexus.template.object.item.entity.boat.BoatType;
import com.mememan.nexus.util.RegistryUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class DefaultableBoatRenderer
extends EntityRenderer<Boat> {
    protected final boolean chestBoat;
    protected final Map<BoatType, Pair<ResourceLocation, ListModel<Boat>>> mappedBoatTypes;
    protected final Map<Boat.Type, Pair<ResourceLocation, ListModel<Boat>>> vanillaBoatResources;

    public DefaultableBoatRenderer(EntityRendererProvider.Context context, boolean chestBoat) {
        super(context);
        this.f_114477_ = 0.8f;
        this.chestBoat = chestBoat;
        this.mappedBoatTypes = (Map)Util.m_137469_((Object)new Object2ObjectOpenHashMap(), existingBoatResources -> BoatType.getKnownBoatTypes().forEach(knownBoatType -> existingBoatResources.put(knownBoatType, (Object)Pair.of((Object)RegistryUtil.pickPrefix(RegistryUtil.getTextureLocation(knownBoatType.getResourceFriendlyId(), chestBoat ? "entity/chest_boat" : "entity/boat").or(() -> RegistryUtil.getTextureLocation(knownBoatType.getResourceFriendlyId().m_266382_(chestBoat ? "_chest_boat" : "_boat"), chestBoat ? "entity/chest_boat" : "entity/boat")).orElse(knownBoatType.getResourceFriendlyId().m_246208_(chestBoat ? "entity/chest_boat/" : "entity/boat/")), "textures/").m_266382_(".png"), this.createBoatModel(context, (BoatType)knownBoatType, chestBoat)))));
        this.vanillaBoatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), curBoatType -> Pair.of((Object)new ResourceLocation(BoatRenderer.m_234565_((Boat.Type)curBoatType, (boolean)chestBoat)), this.createVanillaBoatModel(context, (Boat.Type)curBoatType, chestBoat))));
    }

    @NotNull
    protected ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, BoatType type, boolean chestBoat) {
        boolean isRaft = type.isRaft();
        ModelLayerLocation mappedModelLayerLoc = isRaft ? (chestBoat ? new ModelLayerLocation(RegistryUtil.pickPrefix(type.getResourceFriendlyId(), "chest_raft/"), "main") : new ModelLayerLocation(RegistryUtil.pickPrefix(type.getResourceFriendlyId(), "raft/"), "main")) : (chestBoat ? new ModelLayerLocation(RegistryUtil.pickPrefix(type.getResourceFriendlyId(), "chest_boat/"), "main") : new ModelLayerLocation(RegistryUtil.pickPrefix(type.getResourceFriendlyId(), "boat/"), "main"));
        ModelPart bakedRootModelPart = context.m_174023_(mappedModelLayerLoc);
        if (isRaft) {
            return chestBoat ? new ChestRaftModel(bakedRootModelPart) : new RaftModel(bakedRootModelPart);
        }
        return chestBoat ? new ChestBoatModel(bakedRootModelPart) : new BoatModel(bakedRootModelPart);
    }

    @NotNull
    protected ListModel<Boat> createVanillaBoatModel(EntityRendererProvider.Context context, Boat.Type type, boolean chestBoat) {
        ModelLayerLocation vanillaBoatLayerLoc = chestBoat ? ModelLayers.m_233550_((Boat.Type)type) : ModelLayers.m_171289_((Boat.Type)type);
        ModelPart rootBoatModelPart = context.m_174023_(vanillaBoatLayerLoc);
        if (type == Boat.Type.BAMBOO) {
            return chestBoat ? new ChestRaftModel(rootBoatModelPart) : new RaftModel(rootBoatModelPart);
        }
        return chestBoat ? new ChestBoatModel(rootBoatModelPart) : new BoatModel(rootBoatModelPart);
    }

    public void render(Boat entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Pair<ResourceLocation, ListModel<Boat>> pair;
        float adjustedBubbleAngle;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.375f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
        float hurtTimeFrames = (float)entity.m_38385_() - partialTicks;
        float dmgFrames = entity.m_38384_() - partialTicks;
        if (dmgFrames < 0.0f) {
            dmgFrames = 0.0f;
        }
        if (hurtTimeFrames > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)hurtTimeFrames) * hurtTimeFrames * dmgFrames / 10.0f * (float)entity.m_38386_()));
        }
        if (!Mth.m_14033_((float)(adjustedBubbleAngle = entity.m_38352_(partialTicks)), (float)0.0f)) {
            poseStack.m_252781_(new Quaternionf().setAngleAxis(entity.m_38352_(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        if (entity instanceof DefaultableBoatType) {
            DefaultableBoatType defaultableBoat = (DefaultableBoatType)entity;
            pair = this.mappedBoatTypes.get(defaultableBoat.getBoatType().orElseThrow(() -> new IllegalArgumentException("Tried to render DefaultableBoatType with invalid BoatType!")));
        } else {
            pair = this.vanillaBoatResources.get(entity.m_28554_());
        }
        Pair<ResourceLocation, ListModel<Boat>> mappedModelPair = pair;
        ResourceLocation modelTextureLoc = (ResourceLocation)mappedModelPair.getFirst();
        ListModel actualBoatModel = (ListModel)mappedModelPair.getSecond();
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        actualBoatModel.m_6973_((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer textureVertexBuffer = buffer.m_6299_(actualBoatModel.m_103119_(modelTextureLoc));
        actualBoatModel.m_7695_(poseStack, textureVertexBuffer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.m_5842_()) {
            VertexConsumer waterMaskVertexBuffer = buffer.m_6299_(RenderType.m_110478_());
            if (actualBoatModel instanceof WaterPatchModel) {
                WaterPatchModel waterPatchBoatModel = (WaterPatchModel)actualBoatModel;
                waterPatchBoatModel.m_102282_().m_104301_(poseStack, waterMaskVertexBuffer, packedLight, OverlayTexture.f_118083_);
            }
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(Boat entity) {
        ResourceLocation boatTypeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(entity.m_6095_());
        if (entity instanceof DefaultableBoatType) {
            DefaultableBoatType defaultableBoat = (DefaultableBoatType)entity;
            boatTypeId = defaultableBoat.getBoatType().orElseThrow(() -> new IllegalArgumentException("Tried to get texture location for DefaultableBoatType with invalid BoatType!")).getResourceFriendlyId();
        }
        ResourceLocation finalBoatTypeId = boatTypeId;
        return RegistryUtil.pickPrefix(RegistryUtil.getTextureLocation(boatTypeId, this.chestBoat ? "entity/chest_boat" : "entity/boat").or(() -> RegistryUtil.getTextureLocation(finalBoatTypeId.m_266382_("_boat"), this.chestBoat ? "entity/chest_boat" : "entity/boat")).orElse(boatTypeId), "textures/").m_266382_(".png");
    }
}

