/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.template.object.item.entity.boat;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public interface BoatType
extends StringRepresentable {
    public static final BoatType OAK = BoatType.register("oak", () -> Blocks.f_50705_, false);
    public static final BoatType SPRUCE = BoatType.register("spruce", () -> Blocks.f_50741_, false);
    public static final BoatType BIRCH = BoatType.register("birch", () -> Blocks.f_50742_, false);
    public static final BoatType JUNGLE = BoatType.register("jungle", () -> Blocks.f_50743_, false);
    public static final BoatType ACACIA = BoatType.register("acacia", () -> Blocks.f_50744_, false);
    public static final BoatType CHERRY = BoatType.register("cherry", () -> Blocks.f_271304_, false);
    public static final BoatType DARK_OAK = BoatType.register("dark_oak", () -> Blocks.f_50745_, false);
    public static final BoatType MANGROVE = BoatType.register("mangrove", () -> Blocks.f_220865_, false);

    public Supplier<Block> getPlanks();

    public boolean isRaft();

    default public ResourceLocation getResourceFriendlyId() {
        return new ResourceLocation(this.m_7912_().contains("-") ? this.m_7912_().replace('-', ':') : this.m_7912_());
    }

    public static BoatType register(final String typeName, final Supplier<Block> associatedPlanks, final boolean isRaft) {
        return BoatTypesContainer.trackBoatType(new BoatType(){

            @NotNull
            public String m_7912_() {
                return typeName;
            }

            @Override
            public Supplier<Block> getPlanks() {
                return associatedPlanks;
            }

            @Override
            public boolean isRaft() {
                return isRaft;
            }
        });
    }

    public static BoatType register(String typeName, Supplier<Block> associatedPlanks) {
        return BoatType.register(typeName, associatedPlanks, false);
    }

    public static ImmutableSet<BoatType> getKnownBoatTypes() {
        return ImmutableSet.copyOf(BoatTypesContainer.KNOWN_BOAT_TYPES);
    }

    public static class BoatTypesContainer {
        private static final ObjectOpenHashSet<BoatType> KNOWN_BOAT_TYPES = new ObjectOpenHashSet();

        private BoatTypesContainer() {
            throw new IllegalAccessError("Attempted to construct instance of container class! (BoatTypesContainer)");
        }

        public static BoatType trackBoatType(BoatType typeToTrack) {
            KNOWN_BOAT_TYPES.add((Object)typeToTrack);
            return typeToTrack;
        }

        public static void untrackBoatType(BoatType typeToUntrack) {
            KNOWN_BOAT_TYPES.remove((Object)typeToUntrack);
        }
    }
}

