/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.template.property_wrapper;

import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.property_wrapper.def.item.ItemPropertyWrapper;
import com.mememan.nexus.property_wrapper.def.item.ItemPropertyWrapperBuilder;
import com.mememan.nexus.util.ModelUtil;
import com.mememan.nexus.util.RecipeUtil;
import com.mememan.nexus.util.VanillaUtil;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public final class ItemPropertyWrapperTemplates {
    public static final ItemPropertyWrapper<Item> BASIC_GENERATED = (ItemPropertyWrapper)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper().builder()).withModelDefinition(ModelUtil::basicGenerated)).build();
    public static final ItemPropertyWrapper<Item> BASIC_HANDHELD = (ItemPropertyWrapper)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper().builder()).withModelDefinition(ModelUtil::basicHandheld)).build();
    public static final ItemPropertyWrapper<Item> ROD = (ItemPropertyWrapper)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper().builder()).withModelDefinition(ModelUtil::handheldRod)).build();
    public static final ItemPropertyWrapper<Item> COOKED_FOOD = (ItemPropertyWrapper)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper().builder()).copyFrom(BASIC_GENERATED).withRecipe(RecipeUtil::cookedFoodFrom)).build();
    public static final ItemPropertyWrapper<Item> MATERIAL = (ItemPropertyWrapper)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper().builder()).copyFrom(BASIC_GENERATED).withRecipe(RecipeUtil::materialFrom)).build();
    public static final ItemPropertyWrapper<Item> MATERIAL_PIECE = (ItemPropertyWrapper)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper().builder()).copyFrom(BASIC_GENERATED).withRecipe(RecipeUtil::materialPieceFrom)).build();
    public static final ItemPropertyWrapper<Item> BOAT = (ItemPropertyWrapper)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper().builder()).copyFrom(BASIC_GENERATED).asDispensable(VanillaUtil::standardBoatDispenseBehavior)).withRecipe(RecipeUtil::woodenBoatFrom)).withTag(() -> ItemTags.f_13155_)).build();
    public static final ItemPropertyWrapper<Item> CHEST_BOAT = (ItemPropertyWrapper)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper().builder()).copyFrom(BASIC_GENERATED).asDispensable(VanillaUtil::standardChestBoatDispenseBehavior)).withRecipe(RecipeUtil::woodenChestBoatFrom)).withTag(() -> ItemTags.f_215864_)).build();

    private ItemPropertyWrapperTemplates() {
        throw new IllegalAccessError("Attempted to construct instance of template utility class! (ItemPropertyWrapperTemplates)");
    }

    public static <I extends Item> Supplier<I> registerItem(ResourceLocation itemId, Supplier<I> itemSup, @Nullable Collection<Supplier<Item>> itemSupCol) {
        Supplier<I> registeredItem = NexusServices.REGISTRAR.registerObject(itemId, itemSup, BuiltInRegistries.f_257033_);
        if (itemSupCol != null) {
            itemSupCol.add(registeredItem);
        }
        return registeredItem;
    }

    public static <I extends Item> Supplier<I> registerItem(ResourceLocation itemId, Supplier<I> itemSup) {
        return ItemPropertyWrapperTemplates.registerItem(itemId, itemSup, null);
    }

    public static <I extends Item> Supplier<I> registerItemFromTemplate(ResourceLocation itemId, Supplier<I> itemSup, ItemPropertyWrapper<Item> templateBPW, @Nullable Collection<Supplier<Item>> itemSupCol) {
        Supplier<I> registeredItem = ItemPropertyWrapperTemplates.registerItem(itemId, itemSup, itemSupCol);
        return ((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper<I>(registeredItem, itemId.m_135827_()).builder()).copyFromType(templateBPW)).buildAndGet();
    }

    public static <I extends Item> Supplier<I> registerItemFromTemplate(ResourceLocation itemId, Supplier<I> itemSup, ItemPropertyWrapper<Item> templateBPW) {
        return ItemPropertyWrapperTemplates.registerItemFromTemplate(itemId, itemSup, templateBPW, null);
    }

    public static <I extends Item> ItemPropertyWrapperBuilder<I> registerAndChain(ResourceLocation itemId, Supplier<I> itemSup, ItemPropertyWrapper<Item> templateBPW, @Nullable Collection<Supplier<Item>> itemSupCol) {
        Supplier<I> registeredItem = ItemPropertyWrapperTemplates.registerItem(itemId, itemSup, itemSupCol);
        return (ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper<I>(registeredItem, itemId.m_135827_()).builder()).copyFromType(templateBPW);
    }

    public static <I extends Item> ItemPropertyWrapperBuilder<I> registerAndChain(ResourceLocation itemId, Supplier<I> itemSup, ItemPropertyWrapper<Item> templateBPW) {
        return ItemPropertyWrapperTemplates.registerAndChain(itemId, itemSup, templateBPW, null);
    }

    public static <I extends Item> Supplier<I> registerBasicItem(ResourceLocation itemId, Supplier<I> itemSup, @Nullable Collection<Supplier<Item>> itemSupCol) {
        return ItemPropertyWrapperTemplates.registerItemFromTemplate(itemId, itemSup, BASIC_GENERATED, itemSupCol);
    }

    public static <I extends Item> Supplier<I> registerBasicItem(ResourceLocation itemId, Supplier<I> itemSup) {
        return ItemPropertyWrapperTemplates.registerBasicItem(itemId, itemSup, null);
    }

    public static Supplier<Item> registerBasicItem(ResourceLocation itemId) {
        return ItemPropertyWrapperTemplates.registerBasicItem(itemId, () -> new Item(new Item.Properties()));
    }

    public static <I extends Item> Supplier<I> registerBasicHandheldItem(ResourceLocation itemId, Supplier<I> itemSup, @Nullable Collection<Supplier<Item>> itemSupCol) {
        return ItemPropertyWrapperTemplates.registerItemFromTemplate(itemId, itemSup, BASIC_HANDHELD, itemSupCol);
    }

    public static <I extends Item> Supplier<I> registerBasicHandheldItem(ResourceLocation itemId, Supplier<I> itemSup) {
        return ItemPropertyWrapperTemplates.registerBasicHandheldItem(itemId, itemSup, null);
    }

    public static Supplier<Item> registerBasicHandheldItem(ResourceLocation itemId) {
        return ItemPropertyWrapperTemplates.registerBasicHandheldItem(itemId, () -> new Item(new Item.Properties()));
    }

    public static <I extends Item> Supplier<I> registerItemAndReflect(ResourceLocation itemId, Supplier<I> itemSup, @Nullable Collection<Supplier<Item>> itemSupCol) {
        Supplier<I> registeredItem = NexusServices.REGISTRAR.registerObjectAndReflect(itemId, itemSup, BuiltInRegistries.f_257033_);
        if (itemSupCol != null) {
            itemSupCol.add(registeredItem);
        }
        return registeredItem;
    }

    public static <I extends Item> Supplier<I> registerItemAndReflect(ResourceLocation itemId, Supplier<I> itemSup) {
        return ItemPropertyWrapperTemplates.registerItemAndReflect(itemId, itemSup, null);
    }

    public static <I extends Item> Supplier<I> registerItemFromTemplateAndReflect(ResourceLocation itemId, Supplier<I> itemSup, ItemPropertyWrapper<Item> templateBPW, @Nullable Collection<Supplier<Item>> itemSupCol) {
        Supplier<I> registeredItem = ItemPropertyWrapperTemplates.registerItemAndReflect(itemId, itemSup, itemSupCol);
        return ((ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper<I>(registeredItem, itemId.m_135827_()).builder()).copyFromType(templateBPW)).buildAndGet();
    }

    public static <I extends Item> Supplier<I> registerItemFromTemplateAndReflect(ResourceLocation itemId, Supplier<I> itemSup, ItemPropertyWrapper<Item> templateBPW) {
        return ItemPropertyWrapperTemplates.registerItemFromTemplateAndReflect(itemId, itemSup, templateBPW, null);
    }

    public static <I extends Item> ItemPropertyWrapperBuilder<I> registerAndReflectAndChain(ResourceLocation itemId, Supplier<I> itemSup, ItemPropertyWrapper<Item> templateBPW, @Nullable Collection<Supplier<Item>> itemSupCol) {
        Supplier<I> registeredItem = ItemPropertyWrapperTemplates.registerItemAndReflect(itemId, itemSup, itemSupCol);
        return (ItemPropertyWrapperBuilder)((ItemPropertyWrapperBuilder)new ItemPropertyWrapper<I>(registeredItem, itemId.m_135827_()).builder()).copyFromType(templateBPW);
    }

    public static <I extends Item> ItemPropertyWrapperBuilder<I> registerAndReflectAndChain(ResourceLocation itemId, Supplier<I> itemSup, ItemPropertyWrapper<Item> templateBPW) {
        return ItemPropertyWrapperTemplates.registerAndReflectAndChain(itemId, itemSup, templateBPW, null);
    }

    public static <I extends Item> Supplier<I> registerBasicItemAndReflect(ResourceLocation itemId, Supplier<I> itemSup, @Nullable Collection<Supplier<Item>> itemSupCol) {
        return ItemPropertyWrapperTemplates.registerItemFromTemplateAndReflect(itemId, itemSup, BASIC_GENERATED, itemSupCol);
    }

    public static <I extends Item> Supplier<I> registerBasicItemAndReflect(ResourceLocation itemId, Supplier<I> itemSup) {
        return ItemPropertyWrapperTemplates.registerBasicItemAndReflect(itemId, itemSup, null);
    }

    public static Supplier<Item> registerBasicItemAndReflect(ResourceLocation itemId) {
        return ItemPropertyWrapperTemplates.registerBasicItemAndReflect(itemId, () -> new Item(new Item.Properties()));
    }

    public static <I extends Item> Supplier<I> registerBasicHandheldItemAndReflect(ResourceLocation itemId, Supplier<I> itemSup, @Nullable Collection<Supplier<Item>> itemSupCol) {
        return ItemPropertyWrapperTemplates.registerItemFromTemplateAndReflect(itemId, itemSup, BASIC_HANDHELD, itemSupCol);
    }

    public static <I extends Item> Supplier<I> registerBasicHandheldItemAndReflect(ResourceLocation itemId, Supplier<I> itemSup) {
        return ItemPropertyWrapperTemplates.registerBasicHandheldItemAndReflect(itemId, itemSup, null);
    }

    public static Supplier<Item> registerBasicHandheldItemAndReflect(ResourceLocation itemId) {
        return ItemPropertyWrapperTemplates.registerBasicHandheldItemAndReflect(itemId, () -> new Item(new Item.Properties()));
    }
}

