/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import com.mememan.nexus.client.block.WrappedBlockColor;
import com.mememan.nexus.client.item.WrappedClampedItemPropertyFunction;
import com.mememan.nexus.client.item.WrappedItemColor;
import com.mememan.nexus.client.item.WrappedItemPropertyFunction;
import com.mememan.nexus.loader.EnvironmentSide;
import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.util.RegistryUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.DecoratedPotPatterns;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.jetbrains.annotations.Nullable;

public class ClientUtil {
    private ClientUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (ClientUtil)");
    }

    public static boolean onClient() {
        return NexusServices.PLATFORM_MANAGER.getEnvironmentSide() == EnvironmentSide.CLIENT;
    }

    @Nullable
    public static Minecraft getClient() {
        return ClientUtil.onClient() ? Minecraft.m_91087_() : null;
    }

    @Nullable
    public static Player getClientPlayer() {
        return ClientUtil.onClient() ? ClientUtil.getClient().f_91074_ : null;
    }

    @Nullable
    public static Level getClientLevel() {
        return ClientUtil.onClient() ? ClientUtil.getClient().f_91073_ : null;
    }

    @Nullable
    public static ItemPropertyFunction toItemPropertyFunction(WrappedItemPropertyFunction itemModelPredicateFunc) {
        return ClientUtil.onClient() && itemModelPredicateFunc != null ? itemModelPredicateFunc::getValueForStack : null;
    }

    @Nullable
    public static ClampedItemPropertyFunction toClampedItemPropertyFunction(WrappedClampedItemPropertyFunction itemModelPredicateFunc) {
        return ClientUtil.onClient() && itemModelPredicateFunc != null ? itemModelPredicateFunc::getValueForStack : null;
    }

    @Nullable
    public static BlockColor toBlockColor(WrappedBlockColor targetBlockColor) {
        return ClientUtil.onClient() && targetBlockColor != null ? targetBlockColor::getColor : null;
    }

    @Nullable
    public static ItemColor toItemColor(WrappedItemColor targetItemColor) {
        return ClientUtil.onClient() && targetItemColor != null ? targetItemColor::getColor : null;
    }

    @Nullable
    public static Material createSignMaterial(WoodType signWoodType) {
        return ClientUtil.onClient() && signWoodType != null ? new Material(Sheets.f_110739_, RegistryUtil.pickPrefix(RegistryUtil.getTextureLocation(new ResourceLocation(signWoodType.f_61839_()), "entity/signs").or(() -> RegistryUtil.getTextureLocation(new ResourceLocation(signWoodType.f_61839_()).m_266382_("_sign"), "entity/signs")).orElse(new ResourceLocation(signWoodType.f_61839_())), "entity/signs/")) : null;
    }

    @Nullable
    public static Material createHangingSignMaterial(WoodType hangingSignWoodType) {
        return ClientUtil.onClient() && hangingSignWoodType != null ? new Material(Sheets.f_110739_, RegistryUtil.pickPrefix(RegistryUtil.getTextureLocation(new ResourceLocation(hangingSignWoodType.f_61839_()), "entity/signs/hanging").or(() -> RegistryUtil.getTextureLocation(new ResourceLocation(hangingSignWoodType.f_61839_()), "entity/hanging_signs")).or(() -> RegistryUtil.getTextureLocation(new ResourceLocation(hangingSignWoodType.f_61839_()).m_266382_("_hanging_sign"), "entity/signs/hanging")).or(() -> RegistryUtil.getTextureLocation(new ResourceLocation(hangingSignWoodType.f_61839_()).m_266382_("_hanging_sign"), "entity/hanging_signs")).or(() -> RegistryUtil.getTextureLocation(new ResourceLocation(hangingSignWoodType.f_61839_()), "entity/sign/hanging")).or(() -> RegistryUtil.getTextureLocation(new ResourceLocation(hangingSignWoodType.f_61839_()), "entity/hanging_sign")).or(() -> RegistryUtil.getTextureLocation(new ResourceLocation(hangingSignWoodType.f_61839_()).m_266382_("_hanging_sign"), "entity/sign/hanging")).or(() -> RegistryUtil.getTextureLocation(new ResourceLocation(hangingSignWoodType.f_61839_()).m_266382_("_hanging_sign"), "entity/hanging_sign")).orElse(new ResourceLocation(hangingSignWoodType.f_61839_())), "entity/signs/hanging/")) : null;
    }

    @Nullable
    public static Material createBannerMaterial(ResourceKey<BannerPattern> bannerPatternKey) {
        return ClientUtil.onClient() && bannerPatternKey != null ? new Material(Sheets.f_110737_, RegistryUtil.pickPrefix(RegistryUtil.getTextureLocation(bannerPatternKey.m_135782_(), "entity/banner").or(() -> RegistryUtil.getTextureLocation(bannerPatternKey.m_135782_().m_266382_("_banner"), "entity/banner")).orElse(BannerPattern.m_222697_(bannerPatternKey, (boolean)true)), "entity/banner/")) : null;
    }

    @Nullable
    public static Material createShieldMaterial(ResourceKey<BannerPattern> shieldPatternKey) {
        return ClientUtil.onClient() && shieldPatternKey != null ? new Material(Sheets.f_110738_, RegistryUtil.pickPrefix(RegistryUtil.getTextureLocation(shieldPatternKey.m_135782_(), "entity/shield").or(() -> RegistryUtil.getTextureLocation(shieldPatternKey.m_135782_().m_266382_("_shield"), "entity/shield")).orElse(BannerPattern.m_222697_(shieldPatternKey, (boolean)false)), "entity/shield/")) : null;
    }

    @Nullable
    public static Material createDecoratedPotMaterial(ResourceKey<String> decoratedPotMaterialName) {
        return ClientUtil.onClient() && decoratedPotMaterialName != null ? new Material(Sheets.f_271463_, RegistryUtil.pickPrefix(RegistryUtil.getTextureLocation(decoratedPotMaterialName.m_135782_(), "entity/decorated_pot").or(() -> RegistryUtil.getTextureLocation(decoratedPotMaterialName.m_135782_().m_266382_("_decorated_pot"), "entity/decorated_pot")).orElse(DecoratedPotPatterns.m_271757_(decoratedPotMaterialName)), "entity/decorated_pot/")) : null;
    }
}

