/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mememan.nexus.util.JsonUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;

public final class DataGenUtil {
    public static final BiFunction<JsonElement, JsonElement, JsonElement> TAG_FILE_MERGER = (existingContent, newContent) -> {
        JsonObject existingObj;
        block9: {
            block8: {
                if (!(existingContent instanceof JsonObject)) break block8;
                existingObj = (JsonObject)existingContent;
                if (newContent instanceof JsonObject) break block9;
            }
            return newContent;
        }
        JsonObject newObj = (JsonObject)newContent;
        JsonObject result = new JsonObject();
        JsonArray values = new JsonArray();
        ObjectOpenHashSet existingValues = new ObjectOpenHashSet();
        ObjectOpenHashSet newValues = new ObjectOpenHashSet();
        if (newObj.has("values")) {
            newObj.getAsJsonArray("values").forEach(arg_0 -> DataGenUtil.lambda$static$0((Set)newValues, (Set)existingValues, values, arg_0));
        }
        if (existingObj.has("values")) {
            existingObj.getAsJsonArray("values").forEach(arg_0 -> DataGenUtil.lambda$static$1((Set)newValues, (Set)existingValues, values, arg_0));
        }
        JsonArray orderedValues = new JsonArray();
        values.asList().stream().map(JsonElement::getAsString).sorted().forEach(arg_0 -> ((JsonArray)orderedValues).add(arg_0));
        result.add("values", (JsonElement)orderedValues);
        if (newObj.has("replace")) {
            result.addProperty("replace", Boolean.valueOf(newObj.get("replace").getAsBoolean()));
        } else if (existingObj.has("replace")) {
            result.addProperty("replace", Boolean.valueOf(existingObj.get("replace").getAsBoolean()));
        }
        return result;
    };

    private DataGenUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (DataGenUtil)");
    }

    public static CompletableFuture<?> saveStableAndMerge(CachedOutput targetOutput, JsonElement newContent, Path outputPath, BiFunction<JsonElement, JsonElement, JsonElement> mergerFunc) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonElement existingContent;
                if (!Files.exists(outputPath, new LinkOption[0])) {
                    return DataProvider.m_253162_((CachedOutput)targetOutput, (JsonElement)newContent, (Path)outputPath);
                }
                try (BufferedReader reader = Files.newBufferedReader(outputPath, StandardCharsets.UTF_8);){
                    existingContent = JsonParser.parseReader((Reader)reader);
                }
                catch (JsonParseException e) {
                    DataProvider.f_252483_.warn("Failed to parse existing file {}, will overwrite", (Object)outputPath, (Object)e);
                    return DataProvider.m_253162_((CachedOutput)targetOutput, (JsonElement)newContent, (Path)outputPath);
                }
                String existingHash = JsonUtil.hashJson(existingContent);
                String newHash = JsonUtil.hashJson(newContent);
                if (Objects.equals(existingHash, newHash)) {
                    return DataProvider.m_253162_((CachedOutput)targetOutput, (JsonElement)existingContent, (Path)outputPath);
                }
                JsonElement mergedContent = (JsonElement)mergerFunc.apply(existingContent, newContent);
                return DataProvider.m_253162_((CachedOutput)targetOutput, (JsonElement)mergedContent, (Path)outputPath);
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to process file: %s", outputPath), e);
            }
        }, Util.m_183991_()).thenCompose(innerFuture -> innerFuture != null ? innerFuture : CompletableFuture.completedFuture(null));
    }

    private static /* synthetic */ void lambda$static$1(Set newValues, Set existingValues, JsonArray values, JsonElement value) {
        String valueStr = value.toString();
        if (newValues.contains(valueStr) && existingValues.add(valueStr)) {
            values.add(value);
        }
    }

    private static /* synthetic */ void lambda$static$0(Set newValues, Set existingValues, JsonArray values, JsonElement value) {
        String valueStr = value.toString();
        newValues.add(valueStr);
        if (existingValues.add(valueStr)) {
            values.add(value);
        }
    }
}

