/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import com.google.common.hash.Hashing;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.nio.charset.StandardCharsets;
import org.joml.Vector2f;
import org.joml.Vector3f;

public final class JsonUtil {
    private JsonUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (JsonUtil)");
    }

    public static JsonArray createVec3fArray(Vector3f vec3f) {
        JsonArray vec3fArray = new JsonArray();
        vec3fArray.add((Number)Float.valueOf(vec3f.x));
        vec3fArray.add((Number)Float.valueOf(vec3f.y));
        vec3fArray.add((Number)Float.valueOf(vec3f.z));
        return vec3fArray;
    }

    public static JsonArray flatConcatVec3fArrays(Vector3f ... vecsToCombine) {
        JsonArray vec3fArray = new JsonArray();
        for (Vector3f vec : vecsToCombine) {
            vec3fArray.add((Number)Float.valueOf(vec.x));
            vec3fArray.add((Number)Float.valueOf(vec.y));
            vec3fArray.add((Number)Float.valueOf(vec.z));
        }
        return vec3fArray;
    }

    public static JsonArray createVec2fArray(Vector2f vec2f) {
        JsonArray vec2fArray = new JsonArray();
        vec2fArray.add((Number)Float.valueOf(vec2f.x));
        vec2fArray.add((Number)Float.valueOf(vec2f.y));
        return vec2fArray;
    }

    public static JsonArray flatConcatVec2fArrays(Vector2f ... vecsToCombine) {
        JsonArray vec2fArray = new JsonArray();
        for (Vector2f vec : vecsToCombine) {
            vec2fArray.add((Number)Float.valueOf(vec.x));
            vec2fArray.add((Number)Float.valueOf(vec.y));
        }
        return vec2fArray;
    }

    public static String hashJson(JsonElement json) {
        return Hashing.sha1().hashString((CharSequence)json.toString(), StandardCharsets.UTF_8).toString();
    }
}

