/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import com.mememan.nexus.util.RegistryUtil;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public final class LootUtil {
    public static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    public static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
    public static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    public static final LootItemCondition.Builder HAS_SHEARS_OR_SILK_TOUCH = HAS_SHEARS.m_285888_(HAS_SILK_TOUCH);
    public static final LootItemCondition.Builder HAS_NO_SHEARS_OR_SILK_TOUCH = HAS_SHEARS_OR_SILK_TOUCH.m_81807_();
    public static final EntityPredicate.Builder ENTITY_ON_FIRE = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
    public static final float[] NORMAL_LEAVES_SAPLING_CHANCES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    public static final float[] NORMAL_LEAVES_STICK_CHANCES = new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f};

    private LootUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (LootUtil)");
    }

    public static LootTable.Builder dropSelf(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get()))));
    }

    public static LootTable.Builder dropSlab(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)targetBlock.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE))))));
    }

    public static LootTable.Builder dropDoor(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)targetBlock.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER)))));
    }

    public static LootTable.Builder dropBed(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)targetBlock.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD)))));
    }

    public static LootTable.Builder dropShearsOnly(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_SHEARS).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get()))));
    }

    public static LootTable.Builder dropSilkTouchOnly(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_SILK_TOUCH).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get()))));
    }

    public static LootTable.Builder dropSilkTouchOrShears(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_SHEARS_OR_SILK_TOUCH).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get()))));
    }

    public static LootTable.Builder noDrop(Supplier<Block> targetBlock) {
        return LootTable.m_79147_();
    }

    public static LootTable.Builder dropLeaves(Supplier<Block> targetBlock) {
        LootPoolSingletonContainer.Builder droppedItem = LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get()));
        Optional<Block> inferredSapling = RegistryUtil.getObjectFrom(targetBlock.get(), RegistryUtil.replaceSuffix("sapling"));
        inferredSapling.ifPresent(sapling -> ((AlternativesEntry.Builder)droppedItem.m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)sapling)).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])NORMAL_LEAVES_SAPLING_CHANCES))).m_79080_(ExplosionCondition.m_81661_()));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_SHEARS_OR_SILK_TOUCH).m_79076_((LootPoolEntryContainer.Builder)droppedItem)).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(HAS_NO_SHEARS_OR_SILK_TOUCH).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42398_).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])NORMAL_LEAVES_STICK_CHANCES))).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f)))));
    }

    public static LootTable.Builder dropDoublePlant(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get())).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)targetBlock.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)))));
    }

    public static LootTable.Builder dropDoublePlantShearsOrSilkTouch(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(HAS_SHEARS_OR_SILK_TOUCH)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)targetBlock.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)))).m_79080_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{targetBlock.get()}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, 1, 0))))).m_79161_(LootPool.m_79043_().m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(HAS_SHEARS_OR_SILK_TOUCH)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)targetBlock.get()).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER))).m_79080_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{targetBlock.get()}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, -1, 0))));
    }

    public static LootTable.Builder dropMultiFace(Supplier<Block> targetBlock) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get())).m_79080_(HAS_SHEARS_OR_SILK_TOUCH)).m_230987_((Object[])Direction.values(), curDir -> SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)targetBlock.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)MultifaceBlock.m_153933_((Direction)curDir), true))))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)-1.0f), (boolean)true))));
    }

    public static LootTable.Builder dropFarmland(Supplier<Block> targetBlock) {
        LootPoolSingletonContainer.Builder farmlandDrop = LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get()));
        Optional<Supplier<Block>> alternateDirtBlock = RegistryUtil.getObjectFrom(targetBlock, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_farmland", "_dirt"))).or(() -> RegistryUtil.getObjectFrom(targetBlock, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_farmland", ""))));
        alternateDirtBlock.ifPresent(alternateDirt -> ((LootPoolSingletonContainer.Builder)farmlandDrop.m_79080_(HAS_SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)alternateDirt)));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)farmlandDrop));
    }

    public static LootTable.Builder dropGrassBlock(Supplier<Block> targetBlock) {
        LootPoolSingletonContainer.Builder grassBlockDrop = LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get()));
        Optional<Supplier<Block>> alternateDirtBlock = RegistryUtil.getObjectFrom(targetBlock, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_grass_block", "_dirt")));
        alternateDirtBlock.ifPresent(alternateDirt -> ((LootPoolSingletonContainer.Builder)grassBlockDrop.m_79080_(HAS_SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)alternateDirt)));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)grassBlockDrop));
    }

    public static LootTable.Builder dropPottedContents(Supplier<Block> targetBlock) {
        LootTable.Builder basePotBuilder = LootUtil.dropSelf(() -> Blocks.f_50276_);
        Block block = targetBlock.get();
        if (block instanceof FlowerPotBlock) {
            FlowerPotBlock targetFlowerPotBlock = (FlowerPotBlock)block;
            basePotBuilder.m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)targetFlowerPotBlock.m_53560_())));
        }
        return basePotBuilder;
    }

    public static LootTable.Builder dropComponents(Supplier<Block> targetBlock, int minCount, int maxCount) {
        LootPool.Builder potentialComponentPool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_());
        Supplier<Item> targetBlockItem = () -> ((Block)targetBlock.get()).m_5456_();
        Optional<Item> pickedMaterialComponent = targetBlockItem.get().m_7968_().m_41619_() ? Optional.empty() : RegistryUtil.getObjectFrom(targetBlockItem, targetParentBlockId -> RegistryUtil.pickMaterialId(targetBlock, "_lump")).or(() -> RegistryUtil.getObjectFrom(targetBlockItem, arg_0 -> LootUtil.lambda$dropComponents$10((Supplier)targetBlock, arg_0))).or(() -> RegistryUtil.getObjectFrom(targetBlockItem, arg_0 -> LootUtil.lambda$dropComponents$12((Supplier)targetBlock, arg_0))).or(() -> RegistryUtil.getObjectFrom(targetBlockItem, arg_0 -> LootUtil.lambda$dropComponents$14((Supplier)targetBlock, arg_0)));
        pickedMaterialComponent.ifPresentOrElse(chosenMaterialComponent -> potentialComponentPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)chosenMaterialComponent).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)UniformGenerator.m_165780_((float)minCount, (float)maxCount), (boolean)true))), () -> potentialComponentPool.m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true))));
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()).m_79080_(HAS_SILK_TOUCH).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)targetBlock.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)ConstantValue.m_165692_((float)1.0f), (boolean)true)))).m_79161_(potentialComponentPool);
    }

    public static LootTable.Builder dropComponents(Supplier<Block> targetBlock) {
        return LootUtil.dropComponents(targetBlock, 4, 9);
    }

    private static /* synthetic */ ResourceLocation lambda$dropComponents$14(Supplier targetBlock, ResourceLocation parentBlockId) {
        return RegistryUtil.pickMaterialId(targetBlock);
    }

    private static /* synthetic */ ResourceLocation lambda$dropComponents$12(Supplier targetBlock, ResourceLocation parentBlockId) {
        return RegistryUtil.pickMaterialId(targetBlock, "_dust");
    }

    private static /* synthetic */ ResourceLocation lambda$dropComponents$10(Supplier targetBlock, ResourceLocation parentBlockId) {
        return RegistryUtil.pickMaterialId(targetBlock, "_crystal");
    }
}

