/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import com.mememan.nexus.client.block.BlockStateDefinition;
import com.mememan.nexus.client.model.block.BlockModelDefinition;
import com.mememan.nexus.client.model.item.ItemModelDefinition;
import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.property_wrapper.base.specialised.model.ModelBasedPropertyWrapper;
import com.mememan.nexus.util.RegistryUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;

public final class ModelUtil {
    public static final ModelTemplate EMPTY_MODEL_TEMPLATE = new ModelTemplate(Optional.empty(), Optional.empty(), new TextureSlot[0]);
    public static final TextureMapping EMPTY_TEXTURE_MAPPING = new TextureMapping();
    public static final ResourceLocation SOLID_RENDER_TYPE = new ResourceLocation("solid");
    public static final ResourceLocation CUTOUT_MIPPED_RENDER_TYPE = new ResourceLocation("cutout_mipped");
    public static final ResourceLocation CUTOUT_RENDER_TYPE = new ResourceLocation("cutout");
    public static final ResourceLocation TRANSLUCENT_RENDER_TYPE = new ResourceLocation("translucent");
    public static final ResourceLocation TRANSLUCENT_MOVING_BLOCK_RENDER_TYPE = new ResourceLocation("translucent_moving_block");

    private ModelUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (ModelUtil)");
    }

    public static ModelTemplate fromLocation(ResourceLocation parentModelLoc) {
        return new ModelTemplate(Optional.of(parentModelLoc), Optional.empty(), new TextureSlot[0]);
    }

    public static BlockModelDefinition cubeAll(Supplier<Block> ownerBlockSup, ResourceLocation blockTexLoc) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125692_).withTextureMapping(TextureMapping.m_125776_((ResourceLocation)RegistryUtil.pickBlockPrefix(blockTexLoc)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)ownerBlockSup.get()))));
    }

    public static BlockModelDefinition cubeAll(Supplier<Block> ownerBlockSup) {
        return ModelUtil.cubeAll(ownerBlockSup, RegistryUtil.getTextureLocationOrDefault(ownerBlockSup));
    }

    public static BlockModelDefinition cubeBottomTop(Supplier<Block> ownerBlockSup, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125697_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125875_, RegistryUtil.pickBlockPrefix(sideTexture)).m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topTexture)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)ownerBlockSup.get()))));
    }

    public static BlockModelDefinition cubeBottomTop(Supplier<Block> ownerBlockSup) {
        return ModelUtil.cubeBottomTop(ownerBlockSup, RegistryUtil.getTextureLocationOrDefaultWithSuffix(ownerBlockSup, "_side"), RegistryUtil.getTextureLocationOrDefaultWithSuffix(ownerBlockSup, "_bottom"), RegistryUtil.getTextureLocationOrDefaultWithSuffix(ownerBlockSup, "_top"));
    }

    public static BlockModelDefinition leaves(Supplier<Block> targetBlock, ResourceLocation leavesTexture) {
        return (BlockModelDefinition)ModelUtil.cubeAll(targetBlock, leavesTexture).withRenderType(CUTOUT_MIPPED_RENDER_TYPE);
    }

    public static BlockModelDefinition leaves(Supplier<Block> targetBlock) {
        return ModelUtil.leaves(targetBlock, RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition carpet(Supplier<Block> targetBlock, ResourceLocation carpetTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125665_).withTextureMapping(TextureMapping.m_176486_((ResourceLocation)RegistryUtil.pickBlockPrefix(carpetTexture)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)targetBlock.get()))));
    }

    public static BlockModelDefinition carpet(Supplier<Block> targetBlock) {
        return ModelUtil.carpet(targetBlock, RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition cross(ResourceLocation crossTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125639_).withTextureMapping(TextureMapping.m_125788_((ResourceLocation)RegistryUtil.pickBlockPrefix(crossTexture)))).withOrdinalModelDefinition(ModelUtil.generatedBlock(crossTexture));
    }

    public static BlockModelDefinition cross(Supplier<Block> targetBlock) {
        return ModelUtil.cross(RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition crossCutout(ResourceLocation crossTexture) {
        return (BlockModelDefinition)ModelUtil.cross(crossTexture).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition crossCutout(Supplier<Block> targetBlock) {
        return ModelUtil.crossCutout(RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition tintedCross(Supplier<Block> targetBlock, ResourceLocation tintedCrossTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125640_).withTextureMapping(TextureMapping.m_125788_((ResourceLocation)RegistryUtil.pickBlockPrefix(tintedCrossTexture)))).withOrdinalModelDefinition(ModelUtil.generatedBlock(tintedCrossTexture));
    }

    public static BlockModelDefinition tintedCross(Supplier<Block> targetBlock) {
        return ModelUtil.tintedCross(targetBlock, RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition tintedCrossCutout(Supplier<Block> targetBlock, ResourceLocation tintedCrossTexture) {
        return (BlockModelDefinition)ModelUtil.tintedCross(targetBlock, tintedCrossTexture).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition tintedCrossCutout(Supplier<Block> targetBlock) {
        return ModelUtil.tintedCrossCutout(targetBlock, RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition flowerPotCross(ResourceLocation flowerPotTexture) {
        return (BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125641_).withTextureMapping(TextureMapping.m_125798_((ResourceLocation)RegistryUtil.pickBlockPrefix(flowerPotTexture)));
    }

    public static BlockModelDefinition flowerPotCross(Supplier<Block> targetBlock) {
        return ModelUtil.flowerPotCross(RegistryUtil.getTextureLocationOrDefault(RegistryUtil.pickItemLikeId(targetBlock, parentBlockPath -> parentBlockPath.startsWith("potted_") ? parentBlockPath.substring("potted_".length()) : parentBlockPath)));
    }

    public static BlockModelDefinition sign(ResourceLocation signParticleTexture, ResourceLocation signItemTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(EMPTY_MODEL_TEMPLATE).withTextureMapping(TextureMapping.m_125812_((ResourceLocation)RegistryUtil.pickBlockPrefix(signParticleTexture)))).withOrdinalModelDefinition(ModelUtil.basicGenerated(signItemTexture));
    }

    public static BlockModelDefinition sign(Supplier<Block> targetBlock) {
        return ModelUtil.sign(RegistryUtil.pickBlockTexture(targetBlock), RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition hangingSign(Supplier<Block> targetBlock) {
        return ModelUtil.sign(RegistryUtil.getTextureLocationOrDefault(DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get()).m_246208_("stripped_").m_247266_(curPath -> curPath.replace("_hanging_sign", "_log"))), RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockStateDefinition simpleBlockState(Supplier<Block> targetBlock) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)targetBlock.get(), (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)ModelLocationUtils.m_125576_((Block)targetBlock.get()))));
    }

    public static BlockModelDefinition cubeColumn(Supplier<Block> targetBlock, ResourceLocation sideTexture, ResourceLocation endTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125694_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125875_, RegistryUtil.pickBlockPrefix(sideTexture)).m_125758_(TextureSlot.f_125870_, RegistryUtil.pickBlockPrefix(endTexture)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)targetBlock.get()))));
    }

    public static BlockModelDefinition cubeColumn(Supplier<Block> targetBlock, ResourceLocation baseTexture) {
        return ModelUtil.cubeColumn(targetBlock, baseTexture, baseTexture);
    }

    public static BlockModelDefinition cubeColumn(Supplier<Block> targetBlock) {
        return ModelUtil.cubeColumn(targetBlock, RegistryUtil.getTextureLocationOrDefault(targetBlock), RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_top"));
    }

    public static BlockModelDefinition cubeColumnHorizontal(ResourceLocation sideTexture, ResourceLocation endTexture) {
        return (BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125695_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125875_, RegistryUtil.pickBlockPrefix(sideTexture)).m_125758_(TextureSlot.f_125870_, RegistryUtil.pickBlockPrefix(endTexture)));
    }

    public static BlockModelDefinition cubeColumnHorizontal(ResourceLocation baseTexture) {
        return ModelUtil.cubeColumnHorizontal(baseTexture, baseTexture);
    }

    public static BlockModelDefinition cubeColumnHorizontal(Supplier<Block> targetBlock) {
        return ModelUtil.cubeColumnHorizontal(RegistryUtil.getTextureLocationOrDefault(targetBlock), RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_top"));
    }

    public static BlockModelDefinition cubeColumnMirrored(ResourceLocation sideTexture, ResourceLocation endTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_176473_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125875_, RegistryUtil.pickBlockPrefix(sideTexture)))).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125870_, RegistryUtil.pickBlockPrefix(endTexture)));
    }

    public static BlockModelDefinition cubeColumnMirrored(ResourceLocation baseTexture) {
        return ModelUtil.cubeColumnMirrored(baseTexture, baseTexture);
    }

    public static BlockModelDefinition cubeColumnMirrored(Supplier<Block> targetBlock) {
        return ModelUtil.cubeColumnMirrored(RegistryUtil.getTextureLocationOrDefault(targetBlock), RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_top"));
    }

    public static BlockModelDefinition rotatedPillar(Supplier<Block> targetBlock, ResourceLocation sideTexture, ResourceLocation endTexture) {
        return (BlockModelDefinition)ModelUtil.cubeColumn(targetBlock, sideTexture, endTexture).withOrdinalModelDefinition(ModelUtil.cubeColumnHorizontal(sideTexture, endTexture));
    }

    public static BlockModelDefinition rotatedPillar(Supplier<Block> targetBlock) {
        return ModelUtil.rotatedPillar(targetBlock, RegistryUtil.getTextureLocationOrDefault(targetBlock), RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_top"));
    }

    public static BlockStateDefinition rotatedPillarBlockState(Supplier<Block> targetBlock, ResourceLocation baseModel, ResourceLocation horizontalModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)targetBlock.get()).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125329_((Comparable)Direction.Axis.Y, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)baseModel)).m_125329_((Comparable)Direction.Axis.Z, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModel).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.Axis.X, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)horizontalModel).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90))));
    }

    public static BlockStateDefinition rotatedPillarBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.rotatedPillarBlockState(targetBlock, ModelLocationUtils.m_125576_((Block)targetBlock.get()), ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_horizontal"));
    }

    public static BlockStateDefinition axisAlignedBlock(Supplier<Block> targetBlock, ResourceLocation baseModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)targetBlock.get(), (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)baseModel)).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61365_).m_125329_((Comparable)Direction.Axis.Y, Variant.m_125501_()).m_125329_((Comparable)Direction.Axis.Z, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.Axis.X, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90))));
    }

    public static BlockStateDefinition axisAlignedBlock(Supplier<Block> targetBlock) {
        return ModelUtil.axisAlignedBlock(targetBlock, ModelLocationUtils.m_125576_((Block)targetBlock.get()));
    }

    public static BlockModelDefinition doublePlant(ResourceLocation topTexture, ResourceLocation bottomTexture) {
        return (BlockModelDefinition)ModelUtil.crossCutout(topTexture).withOrdinalModelDefinition(ModelUtil.crossCutout(bottomTexture).setOrdinalModelDefinitions((Collection)ObjectArrayList.of()));
    }

    public static BlockModelDefinition doublePlant(Supplier<Block> targetBlock) {
        return ModelUtil.doublePlant(RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_top"), RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_bottom"));
    }

    public static BlockModelDefinition tintedDoublePlant(Supplier<Block> targetBlock, ResourceLocation topTexture, ResourceLocation bottomTexture) {
        return (BlockModelDefinition)ModelUtil.tintedCrossCutout(targetBlock, topTexture).withOrdinalModelDefinition(ModelUtil.tintedCrossCutout(targetBlock, bottomTexture).setOrdinalModelDefinitions((Collection)ObjectArrayList.of()));
    }

    public static BlockModelDefinition tintedDoublePlant(Supplier<Block> targetBlock) {
        return ModelUtil.tintedDoublePlant(targetBlock, RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_top"), RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_bottom"));
    }

    public static BlockStateDefinition doublePlantBlockState(Supplier<Block> targetBlock, ResourceLocation topModel, ResourceLocation bottomModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)targetBlock.get()).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61401_).m_125329_((Comparable)DoubleBlockHalf.LOWER, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomModel)).m_125329_((Comparable)DoubleBlockHalf.UPPER, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topModel))));
    }

    public static BlockStateDefinition doublePlantBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.doublePlantBlockState(targetBlock, RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_top"), RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_bottom"));
    }

    public static BlockModelDefinition slabBottom(Supplier<Block> targetBlock, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation sideTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125627_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topTexture)).m_125758_(TextureSlot.f_125875_, RegistryUtil.pickBlockPrefix(sideTexture)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)targetBlock.get()))));
    }

    public static BlockModelDefinition slabBottom(Supplier<Block> targetBlock) {
        return ModelUtil.slabBottom(targetBlock, RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_bottom"), RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_top"), RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition slabTop(Supplier<Block> targetBlock, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation sideTexture) {
        ResourceLocation baseSlabId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125628_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topTexture)).m_125758_(TextureSlot.f_125875_, RegistryUtil.pickBlockPrefix(sideTexture)))).withCustomName(baseSlabId.m_135815_().concat("_top"));
    }

    public static BlockModelDefinition slabTop(Supplier<Block> targetBlock) {
        return ModelUtil.slabTop(targetBlock, RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_bottom"), RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_top"), RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition slab(Supplier<Block> targetBlock, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation sideTexture) {
        return (BlockModelDefinition)ModelUtil.slabBottom(targetBlock, bottomTexture, topTexture, sideTexture).withOrdinalModelDefinition(ModelUtil.slabTop(targetBlock, bottomTexture, topTexture, sideTexture));
    }

    public static BlockModelDefinition slab(Supplier<Block> targetBlock) {
        ResourceLocation defaultedTexLoc = RegistryUtil.pickBlockTexture(targetBlock);
        return ModelUtil.slab(targetBlock, defaultedTexLoc, defaultedTexLoc, defaultedTexLoc);
    }

    public static BlockStateDefinition slabBlockState(Supplier<Block> targetBlock, ResourceLocation bottomModel, ResourceLocation topModel, ResourceLocation doubleSlabModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)targetBlock.get()).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61397_).m_125329_((Comparable)SlabType.BOTTOM, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(bottomModel))).m_125329_((Comparable)SlabType.TOP, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(topModel))).m_125329_((Comparable)SlabType.DOUBLE, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(doubleSlabModel)))));
    }

    public static BlockStateDefinition slabBlockState(Supplier<Block> targetBlock, ResourceLocation doubleBlockModel) {
        return ModelUtil.slabBlockState(targetBlock, ModelLocationUtils.m_125576_((Block)targetBlock.get()), ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_top"), doubleBlockModel);
    }

    public static BlockStateDefinition slabBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.slabBlockState(targetBlock, RegistryUtil.pickBlockId(targetBlock));
    }

    public static BlockModelDefinition stairsStraight(Supplier<Block> targetBlock, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125630_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125875_, RegistryUtil.pickBlockPrefix(sideTexture)).m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topTexture)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)targetBlock.get()))));
    }

    public static BlockModelDefinition stairsStraight(Supplier<Block> targetBlock) {
        ResourceLocation defaultedTexLoc = RegistryUtil.pickBlockTexture(targetBlock);
        return ModelUtil.stairsStraight(targetBlock, defaultedTexLoc, defaultedTexLoc, defaultedTexLoc);
    }

    public static BlockModelDefinition stairsInner(Supplier<Block> targetBlock, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        ResourceLocation baseStairsId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125631_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125875_, RegistryUtil.pickBlockPrefix(sideTexture)).m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topTexture)))).withCustomName(baseStairsId.m_135815_().concat("_inner"));
    }

    public static BlockModelDefinition stairsInner(Supplier<Block> targetBlock) {
        ResourceLocation defaultedTexLoc = RegistryUtil.pickBlockTexture(targetBlock);
        return ModelUtil.stairsInner(targetBlock, defaultedTexLoc, defaultedTexLoc, defaultedTexLoc);
    }

    public static BlockModelDefinition stairsOuter(Supplier<Block> targetBlock, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        ResourceLocation baseStairsId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125632_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125875_, RegistryUtil.pickBlockPrefix(sideTexture)).m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topTexture)))).withCustomName(baseStairsId.m_135815_().concat("_outer"));
    }

    public static BlockModelDefinition stairsOuter(Supplier<Block> targetBlock) {
        ResourceLocation defaultedTexLoc = RegistryUtil.pickBlockTexture(targetBlock);
        return ModelUtil.stairsOuter(targetBlock, defaultedTexLoc, defaultedTexLoc, defaultedTexLoc);
    }

    public static BlockModelDefinition stairs(Supplier<Block> targetBlock, ResourceLocation sideTexture, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        return (BlockModelDefinition)ModelUtil.stairsStraight(targetBlock, sideTexture, bottomTexture, topTexture).withOrdinalModelDefinitions(new ModelBasedPropertyWrapper.ModelDefinition[]{ModelUtil.stairsInner(targetBlock, sideTexture, bottomTexture, topTexture), ModelUtil.stairsOuter(targetBlock, sideTexture, bottomTexture, topTexture)});
    }

    public static BlockModelDefinition stairs(Supplier<Block> targetBlock) {
        ResourceLocation defaultedTexLoc = RegistryUtil.pickBlockTexture(targetBlock);
        return ModelUtil.stairs(targetBlock, defaultedTexLoc, defaultedTexLoc, defaultedTexLoc);
    }

    public static BlockStateDefinition stairsBlockState(Supplier<Block> targetBlock, ResourceLocation straightStairsModel, ResourceLocation innerStairsModel, ResourceLocation outerStairsModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)targetBlock.get()).m_125271_((PropertyDispatch)PropertyDispatch.m_125299_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61398_).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(straightStairsModel))).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(straightStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(straightStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(straightStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel))).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel))).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel))).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel))).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(straightStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(straightStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(straightStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.STRAIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(straightStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.OUTER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(outerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_RIGHT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)StairsShape.INNER_LEFT, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(innerStairsModel)).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true))));
    }

    public static BlockStateDefinition stairsBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.stairsBlockState(targetBlock, ModelLocationUtils.m_125576_((Block)targetBlock.get()), ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_inner"), ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_outer"));
    }

    public static BlockModelDefinition wallInventory(Supplier<Block> targetBlock, ResourceLocation wallTexture) {
        ResourceLocation baseWallId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125714_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125884_, RegistryUtil.pickBlockPrefix(wallTexture)))).withCustomName(baseWallId.m_135815_().concat("_inventory"))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_inventory"))));
    }

    public static BlockModelDefinition wallPost(Supplier<Block> targetBlock, ResourceLocation wallTexture) {
        ResourceLocation baseWallId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125711_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125884_, RegistryUtil.pickBlockPrefix(wallTexture)))).withCustomName(baseWallId.m_135815_().concat("_post"));
    }

    public static BlockModelDefinition wallSide(Supplier<Block> targetBlock, ResourceLocation wallTexture) {
        ResourceLocation baseWallId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125712_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125884_, RegistryUtil.pickBlockPrefix(wallTexture)))).withCustomName(baseWallId.m_135815_().concat("_side"));
    }

    public static BlockModelDefinition wallSideTall(Supplier<Block> targetBlock, ResourceLocation wallTexture) {
        ResourceLocation baseWallId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125713_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125884_, RegistryUtil.pickBlockPrefix(wallTexture)))).withCustomName(baseWallId.m_135815_().concat("_side_tall"));
    }

    public static BlockModelDefinition wall(Supplier<Block> targetBlock, ResourceLocation wallTexture) {
        return (BlockModelDefinition)ModelUtil.wallInventory(targetBlock, wallTexture).withOrdinalModelDefinitions(new ModelBasedPropertyWrapper.ModelDefinition[]{ModelUtil.wallPost(targetBlock, wallTexture), ModelUtil.wallSide(targetBlock, wallTexture), ModelUtil.wallSideTall(targetBlock, wallTexture)});
    }

    public static BlockModelDefinition wall(Supplier<Block> targetBlock) {
        return ModelUtil.wall(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockStateDefinition wallBlockState(Supplier<Block> targetBlock, ResourceLocation wallPostModel, ResourceLocation wallSideModel, ResourceLocation wallSideTallModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiPartGenerator.m_125204_((Block)targetBlock.get()).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61366_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallPostModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61379_, (Comparable)WallSide.LOW), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallSideModel).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61378_, (Comparable)WallSide.LOW), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallSideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61380_, (Comparable)WallSide.LOW), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallSideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61381_, (Comparable)WallSide.LOW), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallSideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61379_, (Comparable)WallSide.TALL), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallSideTallModel).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61378_, (Comparable)WallSide.TALL), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallSideTallModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61380_, (Comparable)WallSide.TALL), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallSideTallModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61381_, (Comparable)WallSide.TALL), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)wallSideTallModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)));
    }

    public static BlockStateDefinition wallBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.wallBlockState(targetBlock, ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_post"), ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_side"), ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_side_tall"));
    }

    public static BlockModelDefinition buttonDefault(ResourceLocation buttonTexture) {
        return (BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125701_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125868_, RegistryUtil.pickBlockPrefix(buttonTexture)));
    }

    public static BlockModelDefinition buttonInventory(Supplier<Block> targetBlock, ResourceLocation buttonTexture) {
        ResourceLocation baseButtonId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125703_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125868_, RegistryUtil.pickBlockPrefix(buttonTexture)))).withCustomName(baseButtonId.m_135815_().concat("_inventory"))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_inventory"))));
    }

    public static BlockModelDefinition buttonPressed(Supplier<Block> targetBlock, ResourceLocation buttonTexture) {
        ResourceLocation baseButtonId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125702_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125868_, RegistryUtil.pickBlockPrefix(buttonTexture)))).withCustomName(baseButtonId.m_135815_().concat("_pressed"));
    }

    public static BlockModelDefinition button(Supplier<Block> targetBlock, ResourceLocation buttonTexture) {
        return (BlockModelDefinition)ModelUtil.buttonDefault(buttonTexture).withOrdinalModelDefinitions(new ModelBasedPropertyWrapper.ModelDefinition[]{ModelUtil.buttonInventory(targetBlock, buttonTexture), ModelUtil.buttonPressed(targetBlock, buttonTexture)});
    }

    public static BlockModelDefinition button(Supplier<Block> targetBlock) {
        return ModelUtil.button(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockStateDefinition buttonBlockState(Supplier<Block> targetBlock, ResourceLocation buttonModel, ResourceLocation buttonPressedModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)targetBlock.get()).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61448_).m_125329_((Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(buttonModel))).m_125329_((Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(buttonPressedModel)))).m_125271_((PropertyDispatch)PropertyDispatch.m_125296_((Property)BlockStateProperties.f_61376_, (Property)BlockStateProperties.f_61374_).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.FLOOR, (Comparable)Direction.NORTH, Variant.m_125501_()).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.WALL, (Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125350_((Comparable)AttachFace.CEILING, (Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180))));
    }

    public static BlockStateDefinition buttonBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.buttonBlockState(targetBlock, ModelLocationUtils.m_125576_((Block)targetBlock.get()), ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_pressed"));
    }

    public static BlockModelDefinition pressurePlateUp(Supplier<Block> targetBlock, ResourceLocation pressurePlateTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125624_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(pressurePlateTexture)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)targetBlock.get()))));
    }

    public static BlockModelDefinition pressurePlateDown(Supplier<Block> targetBlock, ResourceLocation pressurePlateTexture) {
        ResourceLocation basePressurePlateId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125625_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(pressurePlateTexture)))).withCustomName(basePressurePlateId.m_135815_().concat("_down"));
    }

    public static BlockModelDefinition pressurePlate(Supplier<Block> targetBlock, ResourceLocation pressurePlateTexture) {
        return (BlockModelDefinition)ModelUtil.pressurePlateUp(targetBlock, pressurePlateTexture).withOrdinalModelDefinition(ModelUtil.pressurePlateDown(targetBlock, pressurePlateTexture));
    }

    public static BlockModelDefinition pressurePlate(Supplier<Block> targetBlock) {
        return ModelUtil.pressurePlate(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockStateDefinition pressurePlateBlockState(Supplier<Block> targetBlock, ResourceLocation pressurePlateDownModel, ResourceLocation pressurePlateUpModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)targetBlock.get()).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61448_).m_125329_((Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(pressurePlateDownModel))).m_125329_((Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)RegistryUtil.pickBlockPrefix(pressurePlateUpModel)))));
    }

    public static BlockStateDefinition pressurePlateBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.pressurePlateBlockState(targetBlock, ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_down"), ModelLocationUtils.m_125576_((Block)targetBlock.get()));
    }

    public static BlockModelDefinition doorBottomLeft(Supplier<Block> targetBlock, ResourceLocation bottomDoorTexture, ResourceLocation topDoorTexture) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_236342_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomDoorTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topDoorTexture)))).withCustomName(baseDoorId.m_135815_().concat("_bottom_left"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition doorBottomLeft(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.doorBottomLeft(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_bottom")), RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_top")));
    }

    public static BlockModelDefinition doorBottomLeftOpen(Supplier<Block> targetBlock, ResourceLocation bottomDoorTexture, ResourceLocation topDoorTexture) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_236343_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomDoorTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topDoorTexture)))).withCustomName(baseDoorId.m_135815_().concat("_bottom_left_open"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition doorBottomLeftOpen(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.doorBottomLeftOpen(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_bottom")), RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_top")));
    }

    public static BlockModelDefinition doorBottomRight(Supplier<Block> targetBlock, ResourceLocation bottomDoorTexture, ResourceLocation topDoorTexture) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_236344_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomDoorTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topDoorTexture)))).withCustomName(baseDoorId.m_135815_().concat("_bottom_right"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition doorBottomRight(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.doorBottomRight(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_bottom")), RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_top")));
    }

    public static BlockModelDefinition doorBottomRightOpen(Supplier<Block> targetBlock, ResourceLocation bottomDoorTexture, ResourceLocation topDoorTexture) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_236345_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomDoorTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topDoorTexture)))).withCustomName(baseDoorId.m_135815_().concat("_bottom_right_open"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition doorBottomRightOpen(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.doorBottomRightOpen(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_bottom")), RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_top")));
    }

    public static BlockModelDefinition doorTopLeft(Supplier<Block> targetBlock, ResourceLocation bottomDoorTexture, ResourceLocation topDoorTexture) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_236346_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomDoorTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topDoorTexture)))).withCustomName(baseDoorId.m_135815_().concat("_top_left"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition doorTopLeft(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.doorTopLeft(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_bottom")), RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_top")));
    }

    public static BlockModelDefinition doorTopLeftOpen(Supplier<Block> targetBlock, ResourceLocation bottomDoorTexture, ResourceLocation topDoorTexture) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_236347_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomDoorTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topDoorTexture)))).withCustomName(baseDoorId.m_135815_().concat("_top_left_open"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition doorTopLeftOpen(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.doorTopLeftOpen(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_bottom")), RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_top")));
    }

    public static BlockModelDefinition doorTopRight(Supplier<Block> targetBlock, ResourceLocation bottomDoorTexture, ResourceLocation topDoorTexture) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_236348_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomDoorTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topDoorTexture)))).withCustomName(baseDoorId.m_135815_().concat("_top_right"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition doorTopRight(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.doorTopRight(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_bottom")), RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_top")));
    }

    public static BlockModelDefinition doorTopRightOpen(Supplier<Block> targetBlock, ResourceLocation bottomDoorTexture, ResourceLocation topDoorTexture) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_236349_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125871_, RegistryUtil.pickBlockPrefix(bottomDoorTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(topDoorTexture)))).withCustomName(baseDoorId.m_135815_().concat("_top_right_open"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition doorTopRightOpen(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.doorTopRightOpen(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_bottom")), RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_top")));
    }

    public static ItemModelDefinition doorItem(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.basicGenerated(RegistryUtil.getTextureLocationOrDefault(baseDoorId));
    }

    public static BlockModelDefinition door(Supplier<Block> targetBlock, ResourceLocation bottomTexture, ResourceLocation topTexture, ResourceLocation itemTexture) {
        return (BlockModelDefinition)ModelUtil.doorBottomLeft(targetBlock, bottomTexture, topTexture).withOrdinalModelDefinitions(new ModelBasedPropertyWrapper.ModelDefinition[]{ModelUtil.doorBottomLeftOpen(targetBlock, bottomTexture, topTexture), ModelUtil.doorBottomRight(targetBlock, bottomTexture, topTexture), ModelUtil.doorBottomRightOpen(targetBlock, bottomTexture, topTexture), ModelUtil.doorTopLeft(targetBlock, bottomTexture, topTexture), ModelUtil.doorTopLeftOpen(targetBlock, bottomTexture, topTexture), ModelUtil.doorTopRight(targetBlock, bottomTexture, topTexture), ModelUtil.doorTopRightOpen(targetBlock, bottomTexture, topTexture), ModelUtil.basicGenerated(itemTexture)});
    }

    public static BlockModelDefinition door(Supplier<Block> targetBlock, ResourceLocation bottomTexture, ResourceLocation topTexture) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.door(targetBlock, bottomTexture, topTexture, RegistryUtil.getTextureLocation(baseDoorId, "item").orElse(baseDoorId));
    }

    public static BlockModelDefinition door(Supplier<Block> targetBlock) {
        ResourceLocation baseDoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.door(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_bottom")), RegistryUtil.getTextureLocationOrDefault(baseDoorId.m_266382_("_top")));
    }

    public static BlockStateDefinition doorBlockState(Supplier<Block> targetBlock, ResourceLocation topLeftDoorModel, ResourceLocation topLeftDoorOpenModel, ResourceLocation bottomLeftDoorModel, ResourceLocation bottomLeftDoorOpenModel, ResourceLocation topRightDoorModel, ResourceLocation topRightDoorOpenModel, ResourceLocation bottomRightDoorModel, ResourceLocation bottomRightDoorOpenModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)targetBlock.get()).m_125271_((PropertyDispatch)PropertyDispatch.m_125303_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61401_, (Property)BlockStateProperties.f_61394_, (Property)BlockStateProperties.f_61446_).m_125429_((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomLeftDoorModel)).m_125429_((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomLeftDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomLeftDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomLeftDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomRightDoorModel)).m_125429_((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomRightDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomRightDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomRightDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomLeftDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomLeftDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomLeftDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomLeftDoorOpenModel)).m_125429_((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomRightDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomRightDoorOpenModel)).m_125429_((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomRightDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)bottomRightDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topLeftDoorModel)).m_125429_((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topLeftDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topLeftDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topLeftDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topRightDoorModel)).m_125429_((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topRightDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topRightDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topRightDoorModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topLeftDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topLeftDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125429_((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topLeftDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topLeftDoorOpenModel)).m_125429_((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topRightDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125429_((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topRightDoorOpenModel)).m_125429_((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topRightDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125429_((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)topRightDoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180))));
    }

    public static BlockStateDefinition doorBlockState(Supplier<Block> targetBlock, ResourceLocation topDoorModel, ResourceLocation bottomDoorModel) {
        return ModelUtil.doorBlockState(targetBlock, topDoorModel.m_266382_("_left"), topDoorModel.m_266382_("_left_open"), bottomDoorModel.m_266382_("_left"), bottomDoorModel.m_266382_("_left_open"), topDoorModel.m_266382_("_right"), topDoorModel.m_266382_("_right_open"), bottomDoorModel.m_266382_("_right"), bottomDoorModel.m_266382_("_right_open"));
    }

    public static BlockStateDefinition doorBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.doorBlockState(targetBlock, ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_top"), ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_bottom"));
    }

    public static BlockModelDefinition trapdoorBottom(Supplier<Block> targetBlock, ResourceLocation trapdoorTexture) {
        ResourceLocation targetTrapdoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125634_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(trapdoorTexture)))).withOrdinalModelDefinitions(new ModelBasedPropertyWrapper.ModelDefinition[]{new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_bottom")))})).withCustomName(targetTrapdoorId.m_135815_().concat("_bottom"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition trapdoorBottom(Supplier<Block> targetBlock) {
        ResourceLocation baseTrapdoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.trapdoorBottom(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseTrapdoorId));
    }

    public static BlockModelDefinition trapdoorOpen(Supplier<Block> targetBlock, ResourceLocation trapdoorTexture) {
        ResourceLocation targetTrapdoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125635_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(trapdoorTexture)))).withCustomName(targetTrapdoorId.m_135815_().concat("_open"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition trapdoorOpen(Supplier<Block> targetBlock) {
        ResourceLocation baseTrapdoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.trapdoorOpen(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseTrapdoorId));
    }

    public static BlockModelDefinition trapdoorTop(Supplier<Block> targetBlock, ResourceLocation trapdoorTexture) {
        ResourceLocation targetTrapdoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125633_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(trapdoorTexture)))).withCustomName(targetTrapdoorId.m_135815_().concat("_top"))).withRenderType(CUTOUT_RENDER_TYPE);
    }

    public static BlockModelDefinition trapdoorTop(Supplier<Block> targetBlock) {
        ResourceLocation baseTrapdoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.trapdoorTop(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseTrapdoorId));
    }

    public static BlockModelDefinition trapdoor(Supplier<Block> targetBlock, ResourceLocation trapdoorTexture) {
        return (BlockModelDefinition)ModelUtil.trapdoorBottom(targetBlock, trapdoorTexture).withOrdinalModelDefinitions(new ModelBasedPropertyWrapper.ModelDefinition[]{ModelUtil.trapdoorOpen(targetBlock, trapdoorTexture), ModelUtil.trapdoorTop(targetBlock, trapdoorTexture)});
    }

    public static BlockModelDefinition trapdoor(Supplier<Block> targetBlock) {
        ResourceLocation baseTrapdoorId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return ModelUtil.trapdoor(targetBlock, RegistryUtil.getTextureLocationOrDefault(baseTrapdoorId));
    }

    public static BlockStateDefinition trapdoorBlockState(Supplier<Block> targetBlock, ResourceLocation trapdoorOpenModel, ResourceLocation trapdoorTopModel, ResourceLocation trapdoorBottomModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)targetBlock.get()).m_125271_((PropertyDispatch)PropertyDispatch.m_125299_((Property)BlockStateProperties.f_61374_, (Property)BlockStateProperties.f_61402_, (Property)BlockStateProperties.f_61446_).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorBottomModel)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorBottomModel)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorBottomModel)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorBottomModel)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorTopModel)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorTopModel)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorTopModel)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorTopModel)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorOpenModel)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.BOTTOM, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125391_((Comparable)Direction.NORTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorOpenModel)).m_125391_((Comparable)Direction.SOUTH, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125391_((Comparable)Direction.EAST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125391_((Comparable)Direction.WEST, (Comparable)Half.TOP, (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)trapdoorOpenModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270))));
    }

    public static BlockStateDefinition trapdoorBlockState(Supplier<Block> targetBlock, ResourceLocation baseTrapdoorId) {
        return ModelUtil.trapdoorBlockState(targetBlock, baseTrapdoorId.m_266382_("_open"), baseTrapdoorId.m_266382_("_top"), baseTrapdoorId.m_266382_("_bottom"));
    }

    public static BlockStateDefinition trapdoorBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.trapdoorBlockState(targetBlock, ModelLocationUtils.m_125576_((Block)targetBlock.get()));
    }

    public static BlockModelDefinition fenceInventory(Supplier<Block> targetBlock, ResourceLocation fenceTexture) {
        ResourceLocation targetFenceId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125710_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(fenceTexture)))).withOrdinalModelDefinitions(new ModelBasedPropertyWrapper.ModelDefinition[]{new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_inventory")))})).withCustomName(targetFenceId.m_135815_().concat("_inventory"));
    }

    public static BlockModelDefinition fenceInventory(Supplier<Block> targetBlock) {
        return ModelUtil.fenceInventory(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockModelDefinition fencePost(Supplier<Block> targetBlock, ResourceLocation fenceTexture) {
        ResourceLocation targetFenceId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125708_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(fenceTexture)))).withCustomName(targetFenceId.m_135815_().concat("_post"));
    }

    public static BlockModelDefinition fencePost(Supplier<Block> targetBlock) {
        return ModelUtil.fencePost(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockModelDefinition fenceSide(Supplier<Block> targetBlock, ResourceLocation fenceTexture) {
        ResourceLocation targetFenceId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125709_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(fenceTexture)))).withCustomName(targetFenceId.m_135815_().concat("_side"));
    }

    public static BlockModelDefinition fenceSide(Supplier<Block> targetBlock) {
        return ModelUtil.fenceSide(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockModelDefinition fence(Supplier<Block> targetBlock, ResourceLocation fenceTexture) {
        return (BlockModelDefinition)ModelUtil.fenceInventory(targetBlock, fenceTexture).withOrdinalModelDefinitions(new ModelBasedPropertyWrapper.ModelDefinition[]{ModelUtil.fencePost(targetBlock, fenceTexture), ModelUtil.fenceSide(targetBlock, fenceTexture)});
    }

    public static BlockModelDefinition fence(Supplier<Block> targetBlock) {
        return ModelUtil.fence(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockStateDefinition fenceBlockState(Supplier<Block> targetBlock, ResourceLocation fencePostModel, ResourceLocation fenceSideModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiPartGenerator.m_125204_((Block)targetBlock.get()).m_125218_(Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fencePostModel)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSideModel).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180).m_125511_(VariantProperties.f_125521_, (Object)true)).m_125209_((Condition)Condition.m_125135_().m_125176_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceSideModel).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270).m_125511_(VariantProperties.f_125521_, (Object)true)));
    }

    public static BlockStateDefinition fenceBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.fenceBlockState(targetBlock, ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_post"), ModelLocationUtils.m_125578_((Block)targetBlock.get(), (String)"_side"));
    }

    public static BlockModelDefinition fenceGateClosed(Supplier<Block> targetBlock, ResourceLocation fenceGateTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125715_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(fenceGateTexture)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)targetBlock.get()))));
    }

    public static BlockModelDefinition fenceGateClosed(Supplier<Block> targetBlock) {
        return ModelUtil.fenceGateClosed(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockModelDefinition fenceGateOpen(Supplier<Block> targetBlock, ResourceLocation fenceGateTexture) {
        ResourceLocation targetFenceGateId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125621_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(fenceGateTexture)))).withCustomName(targetFenceGateId.m_135815_().concat("_open"));
    }

    public static BlockModelDefinition fenceGateOpen(Supplier<Block> targetBlock) {
        return ModelUtil.fenceGateOpen(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockModelDefinition fenceGateWallClosed(Supplier<Block> targetBlock, ResourceLocation fenceGateTexture) {
        ResourceLocation targetFenceGateId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125622_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(fenceGateTexture)))).withCustomName(targetFenceGateId.m_135815_().concat("_wall"));
    }

    public static BlockModelDefinition fenceGateWallClosed(Supplier<Block> targetBlock) {
        return ModelUtil.fenceGateWallClosed(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockModelDefinition fenceGateWallOpen(Supplier<Block> targetBlock, ResourceLocation fenceGateTexture) {
        ResourceLocation targetFenceGateId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetBlock.get());
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125623_).withTextureMapping(TextureMapping.m_125761_((ResourceLocation)RegistryUtil.pickBlockPrefix(fenceGateTexture)))).withCustomName(targetFenceGateId.m_135815_().concat("_wall_open"));
    }

    public static BlockModelDefinition fenceGateWallOpen(Supplier<Block> targetBlock) {
        return ModelUtil.fenceGateWallOpen(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockModelDefinition fenceGate(Supplier<Block> targetBlock, ResourceLocation fenceGateTexture) {
        return (BlockModelDefinition)ModelUtil.fenceGateClosed(targetBlock, fenceGateTexture).withOrdinalModelDefinitions(new ModelBasedPropertyWrapper.ModelDefinition[]{ModelUtil.fenceGateOpen(targetBlock, fenceGateTexture), ModelUtil.fenceGateWallClosed(targetBlock, fenceGateTexture), ModelUtil.fenceGateWallOpen(targetBlock, fenceGateTexture)});
    }

    public static BlockModelDefinition fenceGate(Supplier<Block> targetBlock) {
        return ModelUtil.fenceGate(targetBlock, RegistryUtil.pickBlockTexture(targetBlock));
    }

    public static BlockStateDefinition fenceGateBlockState(Supplier<Block> targetBlock, ResourceLocation fenceGateModel, ResourceLocation fenceGateOpenModel, ResourceLocation fenceGateWallModel, ResourceLocation fenceGateWallOpenModel, boolean uvLock) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125256_((Block)targetBlock.get(), (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125521_, (Object)uvLock)).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_).m_125329_((Comparable)Direction.SOUTH, Variant.m_125501_()).m_125329_((Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R180)).m_125329_((Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270))).m_125271_((PropertyDispatch)PropertyDispatch.m_125296_((Property)BlockStateProperties.f_61442_, (Property)BlockStateProperties.f_61446_).m_125350_((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceGateModel)).m_125350_((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(false), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceGateWallModel)).m_125350_((Comparable)Boolean.valueOf(false), (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceGateOpenModel)).m_125350_((Comparable)Boolean.valueOf(true), (Comparable)Boolean.valueOf(true), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)fenceGateWallOpenModel))));
    }

    public static BlockStateDefinition fenceGateBlockState(Supplier<Block> targetBlock, ResourceLocation fenceGateModel, ResourceLocation fenceGateOpenModel, ResourceLocation fenceGateWallModel, ResourceLocation fenceGateWallOpenModel) {
        return ModelUtil.fenceGateBlockState(targetBlock, fenceGateModel, fenceGateOpenModel, fenceGateWallModel, fenceGateWallOpenModel, true);
    }

    public static BlockStateDefinition fenceGateBlockState(Supplier<Block> targetBlock, ResourceLocation fenceGateModel) {
        return ModelUtil.fenceGateBlockState(targetBlock, fenceGateModel, fenceGateModel.m_266382_("_open"), fenceGateModel.m_266382_("_wall"), fenceGateModel.m_266382_("_wall_open"));
    }

    public static BlockStateDefinition fenceGateBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.fenceGateBlockState(targetBlock, ModelLocationUtils.m_125576_((Block)targetBlock.get()));
    }

    public static BlockModelDefinition farmlandDry(Supplier<Block> targetBlock, ResourceLocation dryFarmlandTexture, ResourceLocation dirtTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125681_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125857_, RegistryUtil.pickBlockPrefix(dirtTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(dryFarmlandTexture)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)targetBlock.get()))));
    }

    public static BlockModelDefinition farmlandDry(Supplier<Block> targetBlock, ResourceLocation dryFarmlandTexture) {
        return ModelUtil.farmlandDry(targetBlock, dryFarmlandTexture, RegistryUtil.getTextureLocationOrDefault(dryFarmlandTexture.m_247449_(dryFarmlandTexture.m_135815_().replace("_farmland", "_dirt")), RegistryUtil.getTextureLocationOrDefault(dryFarmlandTexture.m_247449_(dryFarmlandTexture.m_135815_().replace("_farmland", "")))));
    }

    public static BlockModelDefinition farmlandDry(Supplier<Block> targetBlock) {
        return ModelUtil.farmlandDry(targetBlock, RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static BlockModelDefinition farmlandMoist(Supplier<Block> targetBlock, ResourceLocation moistFarmlandTexture, ResourceLocation dirtTexture) {
        return (BlockModelDefinition)((BlockModelDefinition)new BlockModelDefinition(ModelTemplates.f_125681_).withTextureMapping(new TextureMapping().m_125758_(TextureSlot.f_125857_, RegistryUtil.pickBlockPrefix(dirtTexture)).m_125758_(TextureSlot.f_125872_, RegistryUtil.pickBlockPrefix(moistFarmlandTexture)))).withOrdinalModelDefinition(new ItemModelDefinition(ModelUtil.fromLocation(ModelLocationUtils.m_125576_((Block)targetBlock.get()))));
    }

    public static BlockModelDefinition farmlandMoist(Supplier<Block> targetBlock, ResourceLocation moistFarmlandTexture) {
        return ModelUtil.farmlandMoist(targetBlock, moistFarmlandTexture, RegistryUtil.getTextureLocationOrDefault(moistFarmlandTexture.m_247449_(moistFarmlandTexture.m_135815_().replace("_farmland_moist", "_dirt")), RegistryUtil.getTextureLocationOrDefault(moistFarmlandTexture.m_247449_(moistFarmlandTexture.m_135815_().replace("_farmland_moist", "")))));
    }

    public static BlockModelDefinition farmlandMoist(Supplier<Block> targetBlock) {
        return ModelUtil.farmlandMoist(targetBlock, RegistryUtil.getTextureLocationOrDefaultWithSuffix(targetBlock, "_moist"));
    }

    public static BlockModelDefinition farmland(Supplier<Block> targetBlock, ResourceLocation dryFarmlandTexture, ResourceLocation moistFarmlandTexture, ResourceLocation dirtTexture) {
        return (BlockModelDefinition)ModelUtil.farmlandDry(targetBlock, dryFarmlandTexture, dirtTexture).withOrdinalModelDefinition(ModelUtil.farmlandMoist(targetBlock, moistFarmlandTexture, dirtTexture));
    }

    public static BlockModelDefinition farmland(Supplier<Block> targetBlock, ResourceLocation dryFarmlandTexture, ResourceLocation moistFarmlandTexture) {
        return (BlockModelDefinition)ModelUtil.farmlandDry(targetBlock, dryFarmlandTexture).withOrdinalModelDefinition(ModelUtil.farmlandMoist(targetBlock, moistFarmlandTexture));
    }

    public static BlockModelDefinition farmland(Supplier<Block> targetBlock) {
        return (BlockModelDefinition)ModelUtil.farmlandDry(targetBlock).withOrdinalModelDefinition(ModelUtil.farmlandMoist(targetBlock));
    }

    public static BlockStateDefinition farmlandBlockState(Supplier<Block> targetBlock, ResourceLocation dryFarmlandModel, ResourceLocation moistFarmlandModel) {
        return new BlockStateDefinition(targetBlock).withBlockStateSupplier((BlockStateGenerator)MultiVariantGenerator.m_125254_((Block)targetBlock.get()).m_125271_(PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61423_).m_125335_(moistureLevel -> moistureLevel.compareTo(7) >= 0 ? Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)moistFarmlandModel) : Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)dryFarmlandModel))));
    }

    public static BlockStateDefinition farmlandBlockState(Supplier<Block> targetBlock) {
        return ModelUtil.farmlandBlockState(targetBlock, ModelLocationUtils.m_125576_((Block)targetBlock.get()), ModelLocationUtils.m_125576_((Block)targetBlock.get()).m_266382_("_moist"));
    }

    public static ItemModelDefinition basicGenerated(ResourceLocation texLoc) {
        return (ItemModelDefinition)new ItemModelDefinition(ModelTemplates.f_125658_).withTextureMapping(TextureMapping.m_125820_((ResourceLocation)RegistryUtil.pickItemPrefix(texLoc)));
    }

    public static ItemModelDefinition basicGenerated(Supplier<Item> targetItem) {
        return ModelUtil.basicGenerated(RegistryUtil.getTextureLocationOrDefault(targetItem, "item"));
    }

    public static ItemModelDefinition generatedBlock(ResourceLocation texLoc) {
        return (ItemModelDefinition)new ItemModelDefinition(ModelTemplates.f_125658_).withTextureMapping(TextureMapping.m_125820_((ResourceLocation)RegistryUtil.pickBlockPrefix(texLoc)));
    }

    public static ItemModelDefinition generatedBlock(Supplier<Block> targetBlock) {
        return ModelUtil.generatedBlock(RegistryUtil.getTextureLocationOrDefault(targetBlock));
    }

    public static ItemModelDefinition basicHandheld(ResourceLocation texLoc) {
        return (ItemModelDefinition)new ItemModelDefinition(ModelTemplates.f_125659_).withTextureMapping(TextureMapping.m_125820_((ResourceLocation)RegistryUtil.pickItemPrefix(texLoc)));
    }

    public static ItemModelDefinition basicHandheld(Supplier<Item> targetItem) {
        return ModelUtil.basicHandheld(RegistryUtil.getTextureLocationOrDefault(targetItem, "item"));
    }

    public static ItemModelDefinition handheldRod(ResourceLocation texLoc) {
        return (ItemModelDefinition)new ItemModelDefinition(ModelTemplates.f_125660_).withTextureMapping(TextureMapping.m_125820_((ResourceLocation)RegistryUtil.pickItemPrefix(texLoc)));
    }

    public static ItemModelDefinition handheldRod(Supplier<Item> targetItem) {
        return ModelUtil.handheldRod(RegistryUtil.getTextureLocationOrDefault(targetItem, "item"));
    }
}

