/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;

public final class PathUtil {
    private PathUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (PathUtil)");
    }

    public static Path removePathComponent(Path path, String componentToRemove, int specificIndexBound) {
        if (path == null) {
            return null;
        }
        ObjectArrayList separatePathComponents = new ObjectArrayList();
        AtomicInteger removedInstances = specificIndexBound <= 0 ? new AtomicInteger(-1) : new AtomicInteger();
        for (int i = 0; i < path.getNameCount(); ++i) {
            separatePathComponents.add((Object)path.getName(i));
        }
        separatePathComponents.removeIf(targetComponent -> {
            if (removedInstances.get() >= 0 && targetComponent.toString().equals(componentToRemove)) {
                removedInstances.getAndIncrement();
            }
            return targetComponent.toString().equals(componentToRemove) && (removedInstances.get() < 0 || removedInstances.get() < specificIndexBound);
        });
        if (separatePathComponents.isEmpty()) {
            return path.getRoot() != null ? path.getRoot() : path.getFileSystem().getPath("", new String[0]);
        }
        Path resultPath = (Path)separatePathComponents.get(0);
        for (int i = 1; i < separatePathComponents.size(); ++i) {
            resultPath = resultPath.resolve((Path)separatePathComponents.get(i));
        }
        if (path.isAbsolute()) {
            Path pathRoot = path.getRoot();
            return pathRoot != null ? pathRoot.resolve(resultPath) : resultPath;
        }
        return resultPath;
    }
}

