/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.property_wrapper.base.generic.PropertyWrapper;
import com.mememan.nexus.property_wrapper.def.block.BlockPropertyWrapper;
import com.mememan.nexus.util.PredicateUtil;
import com.mememan.nexus.util.RegistryUtil;
import com.mememan.nexus.util.StringUtil;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public final class RecipeUtil {
    private RecipeUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (RecipeUtil)");
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromTag(Consumer<FinishedRecipe> finishedRecipe, TagKey<Item> componentTag, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            if (componentTag != null) {
                ResourceLocation componentTagIdPath = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentTag);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike, (int)4).m_206419_(componentTag).m_126145_("planks").m_126132_("has_any_" + componentTagIdPath.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has(componentTag)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromTag(Consumer<FinishedRecipe> finishedRecipe, TagKey<Item> componentTag) {
        return RecipeUtil.woodenPlanksRecipeFromTag(finishedRecipe, componentTag, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromComponent(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> planksComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)planksComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike, (int)4).m_126209_((ItemLike)componentItemLike).m_126145_("planks").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_176500_(finishedRecipe, String.valueOf(baseRecipeId) + "_from_" + componentItemLikeId.m_135815_());
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromLog(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenPlanksRecipeFromComponent(finishedRecipe, parentPlanks -> RegistryUtil.getObjectFrom(parentPlanks, parentPlanksId -> parentPlanksId.m_247449_(parentPlanksId.m_135815_().replace("_planks", "_log"))).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromLog(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenPlanksRecipeFromLog(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromStrippedLog(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenPlanksRecipeFromComponent(finishedRecipe, parentPlanks -> RegistryUtil.getObjectFrom(parentPlanks, parentPlanksId -> parentPlanksId.m_247449_(parentPlanksId.m_135815_().replace("_planks", "_log")).m_246208_("stripped_")).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromStrippedLog(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenPlanksRecipeFromStrippedLog(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromWood(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenPlanksRecipeFromComponent(finishedRecipe, parentPlanks -> RegistryUtil.getObjectFrom(parentPlanks, parentPlanksId -> parentPlanksId.m_247449_(parentPlanksId.m_135815_().replace("_planks", "_wood"))).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromWood(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenPlanksRecipeFromWood(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPlanksRecipeFromComponents(Consumer<FinishedRecipe> finishedRecipe) {
        return parentItemLikeSup -> {
            Runnable componentRecipeGenerator = () -> RecipeUtil.lambda$woodenPlanksRecipeFromComponents$8(finishedRecipe, (Supplier)parentItemLikeSup);
            PropertyWrapper.PropertyWrappersContainer.getWrapperFor(RegistryUtil.getSuppliedObjectFrom(parentItemLikeSup, parentItemLikeId -> parentItemLikeId.m_247449_(parentItemLikeId.m_135815_().replace("_planks", "_log"))).orElse(null)).map(curPW -> (BlockPropertyWrapper)curPW).ifPresentOrElse(arg_0 -> RecipeUtil.lambda$woodenPlanksRecipeFromComponents$15((Supplier)parentItemLikeSup, finishedRecipe, componentRecipeGenerator, arg_0), componentRecipeGenerator);
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> woodComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)woodComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike, (int)3).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("##").m_126130_("##").m_126145_("bark").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodRecipeFrom(finishedRecipe, parentWood -> RegistryUtil.getObjectFrom(parentWood, parentWoodId -> parentWoodId.m_247449_(parentWoodId.m_135815_().replace("_wood", "_log"))).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> slabRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> slabComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)slabComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("###").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
                SingleItemRecipeBuilder.m_246944_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{componentItemLike}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike, (int)2).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_" + componentItemLikeId.m_135815_() + "_stonecutting"));
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> slabRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.slabRecipeFrom(finishedRecipe, parentSlab -> RegistryUtil.getObjectFrom(parentSlab, parentSlabId -> RegistryUtil.pickBlockId(() -> parentSlab)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> slabRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.slabRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenSlabRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> slabComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)slabComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("###").m_126145_("wooden_slab").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenSlabRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenSlabRecipeFrom(finishedRecipe, parentSlab -> RegistryUtil.getObjectFrom(parentSlab, parentSlabId -> RegistryUtil.pickBlockId(() -> parentSlab)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenSlabRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenSlabRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> stairsRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> stairsComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)stairsComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike, (int)4).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
                SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{componentItemLike}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_" + componentItemLikeId.m_135815_() + "_stonecutting"));
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> stairsRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.stairsRecipeFrom(finishedRecipe, parentStairs -> RegistryUtil.getObjectFrom(parentStairs, parentStairsId -> RegistryUtil.pickBlockId(() -> parentStairs)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> stairsRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.stairsRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenStairsRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> stairsComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)stairsComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126145_("wooden_stairs").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenStairsRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenStairsRecipeFrom(finishedRecipe, parentStairs -> RegistryUtil.getObjectFrom(parentStairs, parentStairsId -> RegistryUtil.pickBlockId(() -> parentStairs)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenStairsRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenStairsRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> wallRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> wallComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)wallComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("###").m_126130_("###").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
                SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{componentItemLike}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_" + componentItemLikeId.m_135815_() + "_stonecutting"));
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> wallRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.wallRecipeFrom(finishedRecipe, parentWall -> RegistryUtil.getObjectFrom(parentWall, parentWallId -> RegistryUtil.pickBlockId(() -> parentWall)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> wallRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.wallRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> doorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> doorComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)doorComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)parentItemLike).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("##").m_126130_("##").m_126130_("##").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> doorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.doorRecipeFrom(finishedRecipe, parentDoor -> RegistryUtil.getObjectFrom(parentDoor, parentDoorId -> RegistryUtil.pickBlockId(() -> parentDoor)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> doorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.doorRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenDoorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> doorComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)doorComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)parentItemLike, (int)3).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("##").m_126130_("##").m_126130_("##").m_126145_("wooden_door").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenDoorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenDoorRecipeFrom(finishedRecipe, parentDoor -> RegistryUtil.getObjectFrom(parentDoor, parentDoorId -> RegistryUtil.pickBlockId(() -> parentDoor)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenDoorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenDoorRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> trapdoorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> trapdoorComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)trapdoorComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)parentItemLike).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("##").m_126130_("##").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> trapdoorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.trapdoorRecipeFrom(finishedRecipe, parentTrapdoor -> RegistryUtil.getObjectFrom(parentTrapdoor, parentTrapdoorId -> RegistryUtil.pickBlockId(() -> parentTrapdoor)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> trapdoorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.trapdoorRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenTrapdoorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> woodenTrapdoorComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)woodenTrapdoorComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)parentItemLike, (int)2).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("##").m_126130_("##").m_126145_("wooden_trapdoor").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenTrapdoorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenTrapdoorRecipeFrom(finishedRecipe, parentWoodenTrapdoor -> RegistryUtil.getObjectFrom(parentWoodenTrapdoor, parentWoodenTrapdoorId -> RegistryUtil.pickBlockId(() -> parentWoodenTrapdoor)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenTrapdoorRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenTrapdoorRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> fenceRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> fenceComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)fenceComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (int)3).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_("#S#").m_126130_("#S#").m_126145_("wooden_fence").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> fenceRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.fenceRecipeFrom(finishedRecipe, parentFence -> RegistryUtil.getObjectFrom(parentFence, parentFenceId -> RegistryUtil.pickBlockId(() -> parentFence)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> fenceRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.fenceRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> fenceGateRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> fenceGateComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)fenceGateComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)parentItemLike).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_("S#S").m_126130_("S#S").m_126145_("wooden_fence_gate").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> fenceGateRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.fenceGateRecipeFrom(finishedRecipe, parentFenceGate -> RegistryUtil.getObjectFrom(parentFenceGate, parentFenceGateId -> RegistryUtil.pickBlockId(() -> parentFenceGate)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> fenceGateRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.fenceGateRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> buttonRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> buttonComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)buttonComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)parentItemLike).m_126209_((ItemLike)componentItemLike).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> buttonRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.buttonRecipeFrom(finishedRecipe, parentButton -> RegistryUtil.getObjectFrom(parentButton, parentButtonId -> RegistryUtil.pickBlockId(() -> parentButton)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> buttonRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.buttonRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenButtonRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> buttonComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)buttonComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)parentItemLike).m_126209_((ItemLike)componentItemLike).m_126145_("wooden_button").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenButtonRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenButtonRecipeFrom(finishedRecipe, parentButton -> RegistryUtil.getObjectFrom(parentButton, parentButtonId -> RegistryUtil.pickBlockId(() -> parentButton)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenButtonRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenButtonRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> pressurePlateRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> pressurePlateComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)pressurePlateComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)parentItemLike).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("##").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> pressurePlateRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.pressurePlateRecipeFrom(finishedRecipe, parentPressurePlate -> RegistryUtil.getObjectFrom(parentPressurePlate, parentPressurePlateId -> RegistryUtil.pickBlockId(() -> parentPressurePlate)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> pressurePlateRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.pressurePlateRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPressurePlateRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> pressurePlateComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)pressurePlateComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)parentItemLike).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("##").m_126145_("wooden_pressure_plate").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPressurePlateRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenPressurePlateRecipeFrom(finishedRecipe, parentPressurePlate -> RegistryUtil.getObjectFrom(parentPressurePlate, parentPressurePlateId -> RegistryUtil.pickBlockId(() -> parentPressurePlate)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenPressurePlateRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenPressurePlateRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenSignRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> woodenSignComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)woodenSignComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (int)3).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" S ").m_126145_("wooden_sign").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenSignRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenSignRecipeFrom(finishedRecipe, parentWoodenSign -> RegistryUtil.getObjectFrom(parentWoodenSign, parentWoodenSignId -> RegistryUtil.pickBlockId(() -> parentWoodenSign)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenSignRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenSignRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenHangingSignRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> woodenHangingSignComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)woodenHangingSignComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (int)6).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42026_).m_126130_("C C").m_126130_("###").m_126130_("###").m_126145_("hanging_sign").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenHangingSignRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenHangingSignRecipeFrom(finishedRecipe, parentHangingWoodenSign -> RegistryUtil.getObjectFrom(parentHangingWoodenSign, parentWoodenHangingSignId -> RegistryUtil.pickBlockId(() -> parentHangingWoodenSign)).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woodenHangingSignRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenHangingSignRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block> Consumer<Supplier<B>> woolCarpetRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, B> woolCarpetComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)woolCarpetComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (int)3).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("##").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> woolCarpetRecipeFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woolCarpetRecipeFrom(finishedRecipe, parentWoolCarpet -> RegistryUtil.getObjectFrom(parentWoolCarpet, parentWoolCarpetId -> RegistryUtil.pickItemLikeId(() -> parentWoolCarpet, parentWoolCarpetPath -> parentWoolCarpetPath.replace("_carpet", "_wool"))).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> woolCarpetRecipeFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woolCarpetRecipeFrom(finishedRecipe, Function.identity());
    }

    public static <B extends Block, I extends Item> Consumer<Supplier<B>> materialBlockFrom(Consumer<FinishedRecipe> finishedRecipe, Function<B, I> materialComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Block parentItemLike = (Block)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Item componentItemLike = (Item)materialComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)parentItemLike).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId);
            }
        };
    }

    public static <B extends Block> Consumer<Supplier<B>> materialBlockFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.materialBlockFrom(finishedRecipe, parentBlock -> RegistryUtil.getObjectFrom(parentBlock.m_5456_(), parentBlockId -> RegistryUtil.pickMaterialIngotId(() -> ((Block)parentBlock).m_5456_())).or(() -> RegistryUtil.getObjectFrom(parentBlock.m_5456_(), parentBlockId -> RegistryUtil.pickMaterialId(() -> ((Block)parentBlock).m_5456_(), "_lump"))).or(() -> RegistryUtil.getObjectFrom(parentBlock.m_5456_(), parentBlockId -> RegistryUtil.pickMaterialId(() -> ((Block)parentBlock).m_5456_(), "_gem"))).or(() -> RegistryUtil.getObjectFrom(parentBlock.m_5456_(), parentBlockId -> RegistryUtil.pickMaterialId(() -> ((Block)parentBlock).m_5456_(), "_crystal"))).or(() -> RegistryUtil.getObjectFrom(parentBlock.m_5456_(), parentBlockId -> RegistryUtil.pickMaterialId(() -> ((Block)parentBlock).m_5456_()))).orElse(null), recipeIdMapper);
    }

    public static <B extends Block> Consumer<Supplier<B>> materialBlockFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.materialBlockFrom(finishedRecipe, Function.identity());
    }

    public static <I extends Item, B extends Block> Consumer<Supplier<I>> materialFromOre(Consumer<FinishedRecipe> finishedRecipe, Function<I, B> materialComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Item parentItemLike = (Item)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)materialComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                Block deepslateComponentItemLike = RegistryUtil.getObjectFrom(componentItemLike, parentComponentItemLikeId -> RegistryUtil.pickMaterialDeepslateOreId(() -> componentItemLike)).orElse(null);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{componentItemLike}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (float)0.35f, (int)200).m_126145_(parentItemLikeId.m_135827_()).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_smelting_" + componentItemLikeId.m_135815_()));
                SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{componentItemLike}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (float)0.7f, (int)100).m_126145_(parentItemLikeId.m_135827_()).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_blasting_" + componentItemLikeId.m_135815_()));
                if (deepslateComponentItemLike != null) {
                    ResourceLocation deepslateComponentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(deepslateComponentItemLike);
                    SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{deepslateComponentItemLike}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (float)0.35f, (int)200).m_126145_(parentItemLikeId.m_135827_()).m_126132_("has_" + deepslateComponentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)deepslateComponentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_smelting_" + deepslateComponentItemLikeId.m_135815_()));
                    SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{deepslateComponentItemLike}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (float)0.7f, (int)100).m_126145_(parentItemLikeId.m_135827_()).m_126132_("has_" + deepslateComponentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)deepslateComponentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_blasting_" + deepslateComponentItemLikeId.m_135815_()));
                }
            }
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> materialFromOre(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.materialFromOre(finishedRecipe, parentMaterial -> BuiltInRegistries.f_256975_.m_6612_(RegistryUtil.pickMaterialOreId(() -> parentMaterial)).orElse(null), recipeIdMapper);
    }

    public static <I extends Item> Consumer<Supplier<I>> materialFromOre(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.materialFromOre(finishedRecipe, Function.identity());
    }

    public static <I extends Item, B extends Block> Consumer<Supplier<I>> materialFromBlock(Consumer<FinishedRecipe> finishedRecipe, Function<I, B> materialComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Item parentItemLike = (Item)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Block componentItemLike = (Block)materialComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (int)9).m_126209_((ItemLike)componentItemLike).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_" + componentItemLikeId.m_135815_()));
            }
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> materialFromBlock(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.materialFromBlock(finishedRecipe, parentMaterial -> BuiltInRegistries.f_256975_.m_6612_(RegistryUtil.pickMaterialBlockId(() -> parentMaterial)).orElse(null), recipeIdMapper);
    }

    public static <I extends Item> Consumer<Supplier<I>> materialFromBlock(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.materialFromBlock(finishedRecipe, Function.identity());
    }

    public static <I extends Item> Consumer<Supplier<I>> materialFromNugget(Consumer<FinishedRecipe> finishedRecipe, Function<I, I> materialComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Item parentItemLike = (Item)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Item componentItemLike = (Item)materialComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("###").m_126130_("###").m_126130_("###").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_" + componentItemLikeId.m_135815_()));
            }
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> materialFromNugget(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.materialFromNugget(finishedRecipe, parentMaterial -> RegistryUtil.getObjectFrom(parentMaterial, parentMaterialId -> RegistryUtil.pickMaterialNuggetId(() -> parentMaterial)).orElse(null), recipeIdMapper);
    }

    public static <I extends Item> Consumer<Supplier<I>> materialFromNugget(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.materialFromNugget(finishedRecipe, Function.identity());
    }

    public static <I extends Item> Consumer<Supplier<I>> materialFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return parentItemLikeSup -> {
            RecipeUtil.materialFromNugget(finishedRecipe).accept((Supplier)parentItemLikeSup);
            RecipeUtil.materialFromBlock(finishedRecipe).accept((Supplier)parentItemLikeSup);
            RecipeUtil.materialFromOre(finishedRecipe).accept((Supplier)parentItemLikeSup);
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> materialPieceFrom(Consumer<FinishedRecipe> finishedRecipe, Function<I, I> materialPieceComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Item parentItemLike = (Item)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Item componentItemLike = (Item)materialPieceComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike, (int)9).m_126209_((ItemLike)componentItemLike).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_" + componentItemLikeId.m_135815_()));
            }
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> materialPieceFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.materialPieceFrom(finishedRecipe, parentMaterialPiece -> RegistryUtil.getObjectFrom(parentMaterialPiece, parentMaterialPieceId -> RegistryUtil.pickMaterialId(() -> parentMaterialPiece)).orElse(null), recipeIdMapper);
    }

    public static <I extends Item> Consumer<Supplier<I>> materialPieceFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.materialPieceFrom(finishedRecipe, Function.identity());
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFromSmelting(Consumer<FinishedRecipe> finishedRecipe, Function<I, I> cookedFoodComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Item parentItemLike = (Item)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Item componentItemLike = (Item)cookedFoodComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{componentItemLike}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)parentItemLike, (float)0.35f, (int)200).m_126145_(parentItemLikeId.m_135827_()).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_smelting_" + componentItemLikeId.m_135815_()));
            }
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFromSmelting(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.cookedFoodFromSmelting(finishedRecipe, parentCookedFood -> RegistryUtil.getObjectFrom(parentCookedFood, parentCookedFoodId -> parentCookedFoodId.m_247449_(parentCookedFoodId.m_135815_().replace("cooked_", "raw_"))).or(() -> RegistryUtil.getObjectFrom(parentCookedFood, parentCookedFoodId -> parentCookedFoodId.m_247449_(parentCookedFoodId.m_135815_().replace("cooked_", "")))).orElse(null), recipeIdMapper);
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFromSmelting(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.cookedFoodFromSmelting(finishedRecipe, Function.identity());
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFromSmoking(Consumer<FinishedRecipe> finishedRecipe, Function<I, I> cookedFoodComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Item parentItemLike = (Item)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Item componentItemLike = (Item)cookedFoodComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{componentItemLike}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)parentItemLike, (float)0.35f, (int)100).m_126145_(parentItemLikeId.m_135827_()).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_smoking_" + componentItemLikeId.m_135815_()));
            }
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFromSmoking(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.cookedFoodFromSmoking(finishedRecipe, parentCookedFood -> RegistryUtil.getObjectFrom(parentCookedFood, parentCookedFoodId -> parentCookedFoodId.m_247449_(parentCookedFoodId.m_135815_().replace("cooked_", "raw_"))).or(() -> RegistryUtil.getObjectFrom(parentCookedFood, parentCookedFoodId -> parentCookedFoodId.m_247449_(parentCookedFoodId.m_135815_().replace("cooked_", "")))).orElse(null), recipeIdMapper);
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFromSmoking(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.cookedFoodFromSmoking(finishedRecipe, Function.identity());
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFromCampfireCooking(Consumer<FinishedRecipe> finishedRecipe, Function<I, I> cookedFoodComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Item parentItemLike = (Item)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Item componentItemLike = (Item)cookedFoodComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                SimpleCookingRecipeBuilder.m_247020_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{componentItemLike}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)parentItemLike, (float)0.35f, (int)600).m_126145_(parentItemLikeId.m_135827_()).m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_campfire_cooking_" + componentItemLikeId.m_135815_()));
            }
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFromCampfireCooking(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.cookedFoodFromCampfireCooking(finishedRecipe, parentCookedFood -> RegistryUtil.getObjectFrom(parentCookedFood, parentCookedFoodId -> parentCookedFoodId.m_247449_(parentCookedFoodId.m_135815_().replace("cooked_", "raw_"))).or(() -> RegistryUtil.getObjectFrom(parentCookedFood, parentCookedFoodId -> parentCookedFoodId.m_247449_(parentCookedFoodId.m_135815_().replace("cooked_", "")))).orElse(null), recipeIdMapper);
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFromCampfireCooking(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.cookedFoodFromCampfireCooking(finishedRecipe, Function.identity());
    }

    public static <I extends Item> Consumer<Supplier<I>> cookedFoodFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return parentItemLikeSup -> {
            RecipeUtil.cookedFoodFromSmelting(finishedRecipe).accept((Supplier)parentItemLikeSup);
            RecipeUtil.cookedFoodFromSmoking(finishedRecipe).accept((Supplier)parentItemLikeSup);
            RecipeUtil.cookedFoodFromCampfireCooking(finishedRecipe).accept((Supplier)parentItemLikeSup);
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> woodenBoatFrom(Consumer<FinishedRecipe> finishedRecipe, Function<I, I> woodenBoatComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Item parentItemLike = (Item)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Item componentItemLike = (Item)woodenBoatComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike).m_126127_(Character.valueOf('#'), (ItemLike)componentItemLike).m_126130_("# #").m_126130_("###").m_126145_("boat").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_" + componentItemLikeId.m_135815_()));
            }
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> woodenBoatFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenBoatFrom(finishedRecipe, parentWoodenBoat -> RegistryUtil.getObjectFrom(parentWoodenBoat, parentWoodenBoatId -> parentWoodenBoatId.m_247266_(curPath -> StringUtil.subLastToken(curPath).concat("_planks"))).orElse(null), recipeIdMapper);
    }

    public static <I extends Item> Consumer<Supplier<I>> woodenBoatFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenBoatFrom(finishedRecipe, Function.identity());
    }

    public static <I extends Item> Consumer<Supplier<I>> woodenChestBoatFrom(Consumer<FinishedRecipe> finishedRecipe, Function<I, I> woodenChestBoatComponentMapper, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return parentItemLikeSup -> {
            Item parentItemLike = (Item)parentItemLikeSup.get();
            ResourceLocation parentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(parentItemLike);
            Item componentItemLike = (Item)woodenChestBoatComponentMapper.apply(parentItemLike);
            if (componentItemLike != null) {
                ResourceLocation componentItemLikeId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(componentItemLike);
                ResourceLocation baseRecipeId = (ResourceLocation)recipeIdMapper.apply(parentItemLikeId);
                ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)parentItemLike).m_126209_((ItemLike)componentItemLike).m_126209_((ItemLike)Items.f_42009_).m_126145_("chest_boat").m_126132_("has_" + componentItemLikeId.m_135815_(), (CriterionTriggerInstance)PredicateUtil.has((ItemLike)componentItemLike)).m_126140_(finishedRecipe, baseRecipeId.m_247449_(baseRecipeId.m_135815_() + "_from_" + componentItemLikeId.m_135815_()));
            }
        };
    }

    public static <I extends Item> Consumer<Supplier<I>> woodenChestBoatFrom(Consumer<FinishedRecipe> finishedRecipe, Function<ResourceLocation, ResourceLocation> recipeIdMapper) {
        return RecipeUtil.woodenChestBoatFrom(finishedRecipe, parentWoodenChestBoat -> RegistryUtil.getObjectFrom(parentWoodenChestBoat, parentWoodenBoatId -> parentWoodenBoatId.m_247266_(curPath -> curPath.replace("_chest_boat", "_boat"))).orElse(null), recipeIdMapper);
    }

    public static <I extends Item> Consumer<Supplier<I>> woodenChestBoatFrom(Consumer<FinishedRecipe> finishedRecipe) {
        return RecipeUtil.woodenChestBoatFrom(finishedRecipe, Function.identity());
    }

    private static /* synthetic */ void lambda$woodenPlanksRecipeFromComponents$15(Supplier parentItemLikeSup, Consumer finishedRecipe, Runnable componentRecipeGenerator, BlockPropertyWrapper curPW) {
        curPW.getAdditionalTags().stream().filter(curTagKey -> ((TagKey)curTagKey.get()).m_207645_(Registries.f_256913_)).map(curTagKey -> (TagKey)curTagKey.get()).filter(arg_0 -> RecipeUtil.lambda$woodenPlanksRecipeFromComponents$13((Supplier)parentItemLikeSup, arg_0)).findFirst().ifPresentOrElse(arg_0 -> RecipeUtil.lambda$woodenPlanksRecipeFromComponents$14(finishedRecipe, (Supplier)parentItemLikeSup, arg_0), componentRecipeGenerator);
    }

    private static /* synthetic */ void lambda$woodenPlanksRecipeFromComponents$14(Consumer finishedRecipe, Supplier parentItemLikeSup, TagKey curTagKey) {
        RecipeUtil.woodenPlanksRecipeFromTag(finishedRecipe, (TagKey<Item>)curTagKey).accept(parentItemLikeSup);
    }

    private static /* synthetic */ boolean lambda$woodenPlanksRecipeFromComponents$13(Supplier parentItemLikeSup, TagKey curTagKey) {
        String objRegName = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow((Block)parentItemLikeSup.get()).m_135815_();
        return curTagKey.f_203868_().m_135815_().equals(objRegName.substring(0, objRegName.lastIndexOf(95)).concat("_logs"));
    }

    private static /* synthetic */ void lambda$woodenPlanksRecipeFromComponents$8(Consumer finishedRecipe, Supplier parentItemLikeSup) {
        RecipeUtil.woodenPlanksRecipeFromLog(finishedRecipe).accept(parentItemLikeSup);
        RecipeUtil.woodenPlanksRecipeFromStrippedLog(finishedRecipe).accept(parentItemLikeSup);
        RecipeUtil.woodenPlanksRecipeFromWood(finishedRecipe).accept(parentItemLikeSup);
    }
}

