/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import com.mememan.nexus.NexusConstants;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class ReflectionUtil {
    private ReflectionUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (ReflectionUtil)");
    }

    public static <T> Class<T> getFunctionalInterfaceClass(T lambda) {
        if (lambda == null) {
            throw new NullPointerException("Attempted to evaluate functional interface for null lambda!");
        }
        if (lambda instanceof Class) {
            return (Class)lambda;
        }
        Class<?>[] pertainingImplementedInterfaces = lambda.getClass().getInterfaces();
        if (pertainingImplementedInterfaces.length == 1) {
            return pertainingImplementedInterfaces[0];
        }
        Class<?> superclass = lambda.getClass().getSuperclass();
        if (superclass != null && superclass != Object.class && (pertainingImplementedInterfaces = superclass.getInterfaces()).length == 1) {
            return pertainingImplementedInterfaces[0];
        }
        throw new IllegalArgumentException(String.format("Could not determine functional interface for lambda function: %s", lambda));
    }

    public static boolean compareGenericInterfaceType(Class<?> baseInterface, Class<?> targetGenericType) {
        if (!baseInterface.isInterface()) {
            return false;
        }
        try {
            Type[] genericInterfaces;
            for (Type genericInterface : genericInterfaces = baseInterface.getGenericInterfaces()) {
                ParameterizedType paramType;
                if (!(genericInterface instanceof ParameterizedType) || (paramType = (ParameterizedType)genericInterface).getRawType() != baseInterface) continue;
                Type typeArg = paramType.getActualTypeArguments()[0];
                if (typeArg instanceof Class) {
                    return typeArg == targetGenericType;
                }
                if (!(typeArg instanceof ParameterizedType)) continue;
                ParameterizedType paramTypeArg = (ParameterizedType)typeArg;
                return paramTypeArg.getRawType() == targetGenericType;
            }
            return false;
        }
        catch (Exception e) {
            NexusConstants.LOGGER.warn("Failed to find generic type for interface '{}' (generic type being compared against: {}). Skipping...", new Object[]{baseInterface.getName(), targetGenericType.getName(), e});
            return false;
        }
    }
}

