/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import com.google.common.base.Suppliers;
import com.mememan.nexus.NexusConstants;
import com.mememan.nexus.platform.NexusServices;
import com.mememan.nexus.property_wrapper.base.generic.DataGenPropertyWrapper;
import com.mememan.nexus.property_wrapper.def.block.BlockPropertyWrapperBuilder;
import com.mememan.nexus.template.object.block.entity.sign.DefaultableCeilingHangingSignBlock;
import com.mememan.nexus.template.object.block.entity.sign.DefaultableStandingSignBlock;
import com.mememan.nexus.template.object.block.entity.sign.DefaultableWallHangingSignBlock;
import com.mememan.nexus.template.object.block.entity.sign.DefaultableWallSignBlock;
import com.mememan.nexus.template.object.block.misc.WoodenBlockGroup;
import com.mememan.nexus.template.object.block_entity.sign.DefaultableHangingSignBlockEntity;
import com.mememan.nexus.template.object.block_entity.sign.DefaultableSignBlockEntity;
import com.mememan.nexus.template.object.entity.misc.vehicle.DefaultableBoat;
import com.mememan.nexus.template.object.entity.misc.vehicle.DefaultableChestBoat;
import com.mememan.nexus.template.object.item.entity.boat.BoatType;
import com.mememan.nexus.template.object.item.entity.boat.DefaultableBoatItem;
import com.mememan.nexus.template.property_wrapper.BlockEntityTypePropertyWrapperTemplates;
import com.mememan.nexus.template.property_wrapper.BlockPropertyWrapperTemplates;
import com.mememan.nexus.template.property_wrapper.EntityTypePropertyWrapperTemplates;
import com.mememan.nexus.template.property_wrapper.ItemPropertyWrapperTemplates;
import com.mememan.nexus.util.StringUtil;
import com.mojang.datafixers.DSL;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegistryUtil {
    private static final ObjectArrayList<ResourceLocation> CACHED_TEXTURE_LOOKUP = (ObjectArrayList)Util.m_137469_((Object)new ObjectArrayList(), texLookup -> NexusServices.PLATFORM_MANAGER.getModData().stream().flatMap(curModData -> curModData.getAllResourcePaths(".png").stream()).filter(curPath -> curPath.contains("assets/")).forEach(curPath -> {
        if (curPath.contains("/textures/") && curPath.endsWith(".png")) {
            String assumedModId = curPath.substring(curPath.indexOf("assets/") + "assets/".length(), curPath.indexOf("/textures/"));
            String formattedTexturePath = curPath.substring(curPath.indexOf("/textures/") + "/textures/".length(), curPath.indexOf(".png"));
            texLookup.add((Object)new ResourceLocation(assumedModId, formattedTexturePath));
        }
    }));
    private static final String[] DERIVED_BLOCK_SUFFIXES = new String[]{"_hanging_sign", "_pressure_plate", "_fence_gate", "_trapdoor", "_button", "_stairs", "_slab", "_fence", "_wall", "_door", "_sign"};
    private static final String[] WOOD_COMPONENT_SUFFIXES = new String[]{"_pressure_plate", "_hanging_sign", "_fence_gate", "_trapdoor", "_stairs", "_button", "_fence", "_door", "_slab", "_sign"};
    private static final String[] VANILLA_WOOD_MATERIALS = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "mangrove", "cherry", "bamboo", "crimson", "warped"};
    private static final String[] NORMALIZABLE_SUFFIXES = new String[]{"_brick", "_plank"};
    private static final String[] MATERIAL_SUFFIXES = new String[]{"_ingot", "_nugget", "_gem", "_shard", "_dust", "_crystal", "_ore", "_block"};

    private RegistryUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (RegistryUtil)");
    }

    public static Optional<ResourceLocation> getTextureLocation(ResourceLocation textureName, @Nullable String rawObjectRegistryKey) {
        return textureName == null ? Optional.empty() : CACHED_TEXTURE_LOOKUP.stream().filter(curLoc -> curLoc.m_135827_().equals(textureName.m_135827_()) && (rawObjectRegistryKey == null || curLoc.m_135815_().contains("/" + rawObjectRegistryKey + "/") || curLoc.m_135815_().contains(rawObjectRegistryKey + "/")) && curLoc.m_135815_().substring(curLoc.m_135815_().lastIndexOf(47) + 1).equals(textureName.m_135815_())).findFirst();
    }

    public static Optional<ResourceLocation> getTextureLocation(ResourceLocation textureName) {
        return RegistryUtil.getTextureLocation(textureName, null);
    }

    @NotNull
    public static ResourceLocation getTextureLocationOrDefault(ResourceLocation textureName, @NotNull ResourceLocation defaultTextureLocation) {
        return RegistryUtil.getTextureLocation(textureName).orElseGet(() -> {
            NexusConstants.LOGGER.warn("Attempted to locate non-existent texture '{}', falling back to provided default texture '{}'", (Object)textureName, (Object)defaultTextureLocation);
            return defaultTextureLocation;
        });
    }

    @NotNull
    public static ResourceLocation getTextureLocationOrDefault(ResourceLocation textureName, String dirPrefix, @NotNull ResourceLocation defaultTextureLocation) {
        return RegistryUtil.getTextureLocation(textureName, dirPrefix).orElseGet(() -> {
            NexusConstants.LOGGER.warn("Attempted to locate non-existent texture '{}' (under directory containing '{}'), falling back to provided default texture '{}'", new Object[]{textureName, dirPrefix, defaultTextureLocation});
            return defaultTextureLocation;
        });
    }

    @NotNull
    public static ResourceLocation getTextureLocationOrDefault(ResourceLocation textureName) {
        return RegistryUtil.getTextureLocationOrDefault(textureName, textureName);
    }

    @NotNull
    public static ResourceLocation getTextureLocationOrDefault(ResourceLocation textureName, String dirPrefix) {
        return RegistryUtil.getTextureLocationOrDefault(textureName, dirPrefix, textureName);
    }

    public static <T> Optional<ResourceLocation> getTextureLocation(Supplier<T> targetObj) {
        return RegistryUtil.getTextureLocation(DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetObj.get()));
    }

    public static <T> Optional<ResourceLocation> getTextureLocation(Supplier<T> targetObj, String dirPrefix) {
        return RegistryUtil.getTextureLocation(DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetObj.get()), dirPrefix);
    }

    @NotNull
    public static <T> ResourceLocation getTextureLocationOrDefault(Supplier<T> targetObj, @NotNull ResourceLocation defaultTextureLocation) {
        return RegistryUtil.getTextureLocation(targetObj).orElseGet(() -> {
            NexusConstants.LOGGER.warn("Attempted to locate non-existent texture for {} '{}', falling back to provided default texture '{}'", new Object[]{targetObj.get().getClass().getSimpleName(), DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetObj.get()), defaultTextureLocation});
            return defaultTextureLocation;
        });
    }

    @NotNull
    public static <T> ResourceLocation getTextureLocationOrDefault(Supplier<T> targetObj, String dirPrefix, @NotNull ResourceLocation defaultTextureLocation) {
        return RegistryUtil.getTextureLocation(targetObj, dirPrefix).orElseGet(() -> {
            NexusConstants.LOGGER.warn("Attempted to locate non-existent texture for {} '{}' (under directory containing '{}'), falling back to provided default texture '{}'", new Object[]{targetObj.get().getClass().getSimpleName(), DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(targetObj.get()), dirPrefix, defaultTextureLocation});
            return defaultTextureLocation;
        });
    }

    @NotNull
    public static <T> ResourceLocation getTextureLocationOrDefault(Supplier<T> targetObj) {
        return RegistryUtil.getTextureLocationOrDefault(targetObj, new ResourceLocation("invalid"));
    }

    @NotNull
    public static <T> ResourceLocation getTextureLocationOrDefault(Supplier<T> targetObj, String dirPrefix) {
        return RegistryUtil.getTextureLocationOrDefault(targetObj, dirPrefix, new ResourceLocation("invalid"));
    }

    @NotNull
    public static <T> ResourceLocation getTextureLocationOrDefaultWithPrefix(Supplier<T> targetObj, String prefix) {
        return RegistryUtil.pickPrefix(RegistryUtil.getTextureLocationOrDefault(targetObj), prefix);
    }

    @NotNull
    public static <T> ResourceLocation getTextureLocationOrDefaultWithSuffix(Supplier<T> targetObj, String suffix) {
        return RegistryUtil.pickSuffix(RegistryUtil.getTextureLocationOrDefault(targetObj), suffix);
    }

    @NotNull
    public static <T> ResourceLocation getTextureLocationOrDefaultWithPrefix(ResourceLocation baseLoc, String prefix) {
        return RegistryUtil.pickPrefix(RegistryUtil.getTextureLocationOrDefault(baseLoc), prefix);
    }

    @NotNull
    public static <T> ResourceLocation getTextureLocationOrDefaultWithSuffix(ResourceLocation baseLoc, String suffix) {
        return RegistryUtil.pickSuffix(RegistryUtil.getTextureLocationOrDefault(baseLoc), suffix);
    }

    public static ResourceLocation pickPrefix(ResourceLocation baseLoc, String prefix) {
        return baseLoc.m_135815_().startsWith(prefix) ? baseLoc : baseLoc.m_246208_(prefix);
    }

    public static ResourceLocation pickSuffix(ResourceLocation baseLoc, String suffix) {
        return baseLoc.m_135815_().endsWith(suffix) ? baseLoc : baseLoc.m_266382_(suffix);
    }

    public static ResourceLocation pickBlockPrefix(ResourceLocation baseBlockLoc) {
        return RegistryUtil.pickPrefix(baseBlockLoc, "block/");
    }

    public static ResourceLocation pickItemPrefix(ResourceLocation baseItemLoc) {
        return RegistryUtil.pickPrefix(baseItemLoc, "item/");
    }

    public static Function<ResourceLocation, ResourceLocation> pickPrefix(String prefix) {
        return baseLoc -> RegistryUtil.pickPrefix(baseLoc, prefix);
    }

    public static Function<ResourceLocation, ResourceLocation> pickSuffix(String suffix) {
        return baseLoc -> RegistryUtil.pickSuffix(baseLoc, suffix);
    }

    public static Function<ResourceLocation, ResourceLocation> pickPrefixAndSuffix(String prefix, String suffix) {
        return baseLoc -> baseLoc.m_135815_().startsWith(prefix) && baseLoc.m_135815_().endsWith(suffix) ? baseLoc : baseLoc.m_246208_(prefix).m_266382_(suffix);
    }

    public static Function<ResourceLocation, ResourceLocation> replacePrefix(String replacedPrefix) {
        return baseLoc -> {
            String baseLocPath = baseLoc.m_135815_();
            return baseLocPath.startsWith(replacedPrefix) || !baseLocPath.contains("_") ? baseLoc : baseLoc.m_247449_(baseLocPath.replace(StringUtils.substringBefore((String)baseLocPath, (int)baseLoc.m_135815_().indexOf(95)), replacedPrefix));
        };
    }

    public static Function<ResourceLocation, ResourceLocation> replaceSuffix(String replacedSuffix) {
        return baseLoc -> {
            String baseLocPath = baseLoc.m_135815_();
            return baseLocPath.endsWith(replacedSuffix) || !baseLocPath.contains("_") ? baseLoc : baseLoc.m_247449_(baseLocPath.replace(baseLocPath.substring(baseLoc.m_135815_().lastIndexOf(95) + 1), replacedSuffix));
        };
    }

    public static <T> Optional<Supplier<T>> getSuppliedObjectFrom(Supplier<T> baseObjSup, Function<ResourceLocation, ResourceLocation> targetObjIdMapper, boolean throwIfMissing) {
        Object baseObj = baseObjSup.get();
        String targetObjClassName = baseObj.getClass().getSimpleName();
        Registry baseObjRegistry = DataGenPropertyWrapper.RegistryLookupContainer.getRegistryForObject(baseObj).orElseThrow(() -> new IllegalArgumentException(String.format("Attempted to find registry for unregistered or unmapped object of type %s: %s", targetObjClassName, baseObj)));
        ResourceLocation baseObjLoc = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow(baseObj);
        ResourceLocation targetObjLoc = targetObjIdMapper.apply(baseObjLoc);
        Supplier<Object> targetObj = () -> {
            DefaultedRegistry defReg;
            return baseObjRegistry instanceof DefaultedRegistry && Objects.equals((defReg = (DefaultedRegistry)baseObjRegistry).m_7745_(targetObjLoc), defReg.m_7745_(defReg.m_122315_())) ? null : baseObjRegistry.m_7745_(targetObjLoc);
        };
        if (throwIfMissing && targetObj.get() == null) {
            throw new IllegalArgumentException(String.format("Attempted to compute invalid object '%s' from %s '%s'", targetObjLoc, targetObjClassName, baseObjLoc));
        }
        return Optional.ofNullable(targetObj);
    }

    public static <T> Optional<T> getObjectFrom(Supplier<T> baseObjSup, Function<ResourceLocation, ResourceLocation> targetObjIdMapper, boolean throwIfMissing) {
        return RegistryUtil.getSuppliedObjectFrom(baseObjSup, targetObjIdMapper, throwIfMissing).map(Supplier::get);
    }

    public static <T> Optional<T> getObjectFrom(T baseObj, Function<ResourceLocation, ResourceLocation> targetObjIdMapper, boolean throwIfMissing) {
        return RegistryUtil.getObjectFrom(() -> baseObj, targetObjIdMapper, throwIfMissing);
    }

    public static <T> Optional<Supplier<T>> getSuppliedObjectFrom(Supplier<T> baseObjSup, Function<ResourceLocation, ResourceLocation> targetObjIdMapper) {
        return RegistryUtil.getSuppliedObjectFrom(baseObjSup, targetObjIdMapper, false);
    }

    public static <T> Optional<T> getObjectFrom(Supplier<T> baseObjSup, Function<ResourceLocation, ResourceLocation> targetObjIdMapper) {
        return RegistryUtil.getObjectFrom(baseObjSup, targetObjIdMapper, false);
    }

    public static <T> Optional<T> getObjectFrom(T baseObj, Function<ResourceLocation, ResourceLocation> targetObjIdMapper) {
        return RegistryUtil.getObjectFrom(baseObj, targetObjIdMapper, false);
    }

    public static <T> Supplier<T> getSuppliedObjectFromOrThrow(Supplier<T> baseObjSup, Function<ResourceLocation, ResourceLocation> targetObjIdMapper) {
        return RegistryUtil.getSuppliedObjectFrom(baseObjSup, targetObjIdMapper, true).get();
    }

    public static <T> T getObjectFromOrThrow(Supplier<T> baseObjSup, Function<ResourceLocation, ResourceLocation> targetObjIdMapper) {
        return (T)RegistryUtil.getObjectFrom(baseObjSup, targetObjIdMapper, true).get();
    }

    public static <T> T getObjectFromOrThrow(T baseObj, Function<ResourceLocation, ResourceLocation> targetObjIdMapper) {
        return RegistryUtil.getObjectFrom(baseObj, targetObjIdMapper, true).get();
    }

    public static <IL extends ItemLike> ResourceLocation pickItemLikeId(Supplier<IL> targetItemLike, Function<String, String> pathIdMapper) {
        ResourceLocation baseILId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow((ItemLike)targetItemLike.get());
        String baseILPath = baseILId.m_135815_();
        String chosenILId = pathIdMapper.apply(baseILPath);
        return baseILId.m_247449_(chosenILId);
    }

    public static ResourceLocation pickBlockId(Supplier<Block> targetBlock) {
        return RegistryUtil.pickItemLikeId(targetBlock, baseBlockPath -> {
            boolean endsWithFamilyBase;
            String work = baseBlockPath;
            String removedSuffix = null;
            boolean sourceContainedBlockToken = baseBlockPath.contains("_block");
            for (String suffix : DERIVED_BLOCK_SUFFIXES) {
                if (!work.endsWith(suffix)) continue;
                work = work.substring(0, work.length() - suffix.length());
                removedSuffix = suffix;
                break;
            }
            for (String suffix : NORMALIZABLE_SUFFIXES) {
                if (!work.endsWith(suffix)) continue;
                work = work.substring(0, work.length() - suffix.length()).concat(StringUtil.pluralize(suffix));
                break;
            }
            boolean woodFamilyBaseDetected = work.endsWith("_planks");
            if (removedSuffix != null && StringUtil.containsSuffix(WOOD_COMPONENT_SUFFIXES, removedSuffix)) {
                String lastToken = StringUtil.lastToken(work);
                ResourceLocation targetBlockId = DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow((Block)targetBlock.get());
                if (StringUtil.containsSuffix(VANILLA_WOOD_MATERIALS, work) || StringUtil.containsSuffix(VANILLA_WOOD_MATERIALS, lastToken) || BuiltInRegistries.f_256975_.m_6612_(targetBlockId.m_247449_(work.concat("_planks"))).isPresent() || ((Block)targetBlock.get()).m_204297_().m_203616_().anyMatch(curTag -> curTag.f_203868_().m_135815_().contains("wooden"))) {
                    if (!work.endsWith("_planks") && !work.contains("plank")) {
                        work = work.concat("_planks");
                    }
                    woodFamilyBaseDetected = true;
                }
            }
            boolean bl = endsWithFamilyBase = work.endsWith("_bricks") || woodFamilyBaseDetected;
            if (!endsWithFamilyBase) {
                boolean expectBlockBase;
                boolean bl2 = expectBlockBase = BuiltInRegistries.f_256975_.m_6612_(DataGenPropertyWrapper.RegistryLookupContainer.getObjectRegistryIdOrThrow((Block)targetBlock.get()).m_247449_(work)).isEmpty() && (sourceContainedBlockToken || removedSuffix != null && !woodFamilyBaseDetected);
                if (expectBlockBase && !work.endsWith("_block")) {
                    work = work.concat("_block");
                }
            }
            return work;
        });
    }

    public static ResourceLocation pickBlockTexture(Supplier<Block> targetBlock) {
        return RegistryUtil.getTextureLocationOrDefault(targetBlock, RegistryUtil.getTextureLocationOrDefault(RegistryUtil.pickBlockId(targetBlock)));
    }

    public static <IL extends ItemLike> ResourceLocation pickMaterialId(Supplier<IL> targetMaterialObject, String addedPrefix, String addedSuffix) {
        return RegistryUtil.pickItemLikeId(targetMaterialObject, baseMaterialPath -> {
            String work = baseMaterialPath;
            for (String potentiallyRemovableSuffix : MATERIAL_SUFFIXES) {
                if (!work.endsWith(potentiallyRemovableSuffix)) continue;
                work = work.substring(0, work.length() - potentiallyRemovableSuffix.length());
                break;
            }
            if (!addedPrefix.isBlank() && !work.startsWith(addedPrefix)) {
                work = addedPrefix.concat(work);
            }
            if (!addedSuffix.isBlank() && !work.endsWith(addedSuffix)) {
                work = work.concat(addedSuffix);
            }
            return work;
        });
    }

    public static <IL extends ItemLike> ResourceLocation pickMaterialId(Supplier<IL> targetMaterialObject, String addedSuffix) {
        return RegistryUtil.pickMaterialId(targetMaterialObject, "", addedSuffix);
    }

    public static <IL extends ItemLike> ResourceLocation pickMaterialId(Supplier<IL> targetMaterialObject) {
        return RegistryUtil.pickMaterialId(targetMaterialObject, "");
    }

    public static <IL extends ItemLike> ResourceLocation pickMaterialBlockId(Supplier<IL> targetMaterialObject) {
        return RegistryUtil.pickMaterialId(targetMaterialObject, "_block");
    }

    public static <IL extends ItemLike> ResourceLocation pickMaterialOreId(Supplier<IL> targetMaterialObject) {
        return RegistryUtil.pickMaterialId(targetMaterialObject, "_ore");
    }

    public static <IL extends ItemLike> ResourceLocation pickMaterialDeepslateOreId(Supplier<IL> targetMaterialObject) {
        return RegistryUtil.pickMaterialId(targetMaterialObject, "deepslate_", "_ore");
    }

    public static <IL extends ItemLike> ResourceLocation pickMaterialIngotId(Supplier<IL> targetMaterialObject) {
        return RegistryUtil.pickMaterialId(targetMaterialObject, "_ingot");
    }

    public static <IL extends ItemLike> ResourceLocation pickMaterialNuggetId(Supplier<IL> targetMaterialObject) {
        return RegistryUtil.pickMaterialId(targetMaterialObject, "_nugget");
    }

    public static BlockSetType getOrCreateBlockSetType(BlockSetType blockSetType) {
        return BlockSetType.m_271801_().filter(curBlockSetType -> Objects.equals(curBlockSetType.f_271253_(), blockSetType.f_271253_())).findFirst().orElseGet(() -> BlockSetType.m_272115_((BlockSetType)blockSetType));
    }

    public static BlockSetType getOrCreateBlockSetType(String blockSetTypeName) {
        return RegistryUtil.getOrCreateBlockSetType(new BlockSetType(blockSetTypeName));
    }

    public static WoodType getOrCreateWoodType(String typeName, BlockSetType parentBlockSetType) {
        return WoodType.m_61843_().filter(curWoodType -> Objects.equals(curWoodType.f_61839_(), typeName) && Objects.equals(curWoodType.f_271340_().f_271253_(), parentBlockSetType.f_271253_())).findFirst().orElseGet(() -> WoodType.m_61844_((WoodType)new WoodType(typeName, parentBlockSetType)));
    }

    public static WoodType getOrCreateWoodType(String typeName) {
        return RegistryUtil.getOrCreateWoodType(typeName, RegistryUtil.getOrCreateBlockSetType(typeName));
    }

    public static WoodenBlockGroup registerStandardWoodFamily(ResourceLocation familyId, Supplier<TagKey<Item>> logTag, @Nullable Collection<Supplier<Item>> itemSupCol, @Nullable Collection<Supplier<Block>> blockSupCol, @Nullable Collection<Supplier<BlockEntityType<BlockEntity>>> blockEntityTypeSupCol, @Nullable Collection<Supplier<EntityType<Entity>>> entityTypeSupCol) {
        return (WoodenBlockGroup)Util.m_137537_(() -> {
            ObjectOpenHashSet woodBlockFamilySet = new ObjectOpenHashSet();
            ObjectOpenHashSet woodItemFamilySet = new ObjectOpenHashSet();
            ObjectOpenHashSet woodBlockEntityFamilySet = new ObjectOpenHashSet();
            ObjectOpenHashSet woodEntityTypeFamilySet = new ObjectOpenHashSet();
            BlockSetType woodBlockSetType = BlockSetType.m_272115_((BlockSetType)new BlockSetType(familyId.toString()));
            WoodType woodBlockType = WoodType.m_61844_((WoodType)new WoodType(familyId.toString(), woodBlockSetType));
            ResourceLocation standardSignId = familyId.m_266382_("_sign");
            ResourceLocation standardHangingSignId = familyId.m_266382_("_hanging_sign");
            Supplier woodenLog = ((BlockPropertyWrapperBuilder)BlockPropertyWrapperTemplates.registerWithItemAndReflectAndChain(familyId.m_266382_("_log"), () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_)), BlockPropertyWrapperTemplates.WOODEN_LOG, blockSupCol, itemSupCol).withAdditionalTag(((Supplier)logTag)::get)).buildAndGet();
            Supplier woodBlock = ((BlockPropertyWrapperBuilder)BlockPropertyWrapperTemplates.registerWithItemAndChain(familyId.m_266382_("_wood"), () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)), BlockPropertyWrapperTemplates.WOOD, blockSupCol, itemSupCol).withAdditionalTag(((Supplier)logTag)::get)).buildAndGet();
            Supplier woodenStrippedLog = ((BlockPropertyWrapperBuilder)BlockPropertyWrapperTemplates.registerWithItemAndChain(familyId.m_246208_("stripped_").m_266382_("_log"), () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50010_)), BlockPropertyWrapperTemplates.STRIPPED_WOODEN_LOG, blockSupCol, itemSupCol).withAdditionalTag(((Supplier)logTag)::get)).buildAndGet();
            Supplier<Block> woodenPlanks = BlockPropertyWrapperTemplates.registerBlockWithItemFromTemplate(familyId.m_266382_("_planks"), () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_)), BlockPropertyWrapperTemplates.WOODEN_PLANKS, blockSupCol, itemSupCol);
            Supplier<Block> woodenSlab = BlockPropertyWrapperTemplates.registerBlockWithItemFromTemplate(familyId.m_266382_("_slab"), () -> new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50398_)), BlockPropertyWrapperTemplates.WOODEN_SLAB, blockSupCol, itemSupCol);
            Supplier<Block> woodenStairs = BlockPropertyWrapperTemplates.registerBlockWithItemFromTemplate(familyId.m_266382_("_stairs"), () -> new StairBlock(((Block)woodenPlanks.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50086_)), BlockPropertyWrapperTemplates.WOODEN_STAIRS, blockSupCol, itemSupCol);
            Supplier<Block> woodenFence = BlockPropertyWrapperTemplates.registerBlockWithItemFromTemplate(familyId.m_266382_("_fence"), () -> new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50132_)), BlockPropertyWrapperTemplates.WOODEN_FENCE, blockSupCol, itemSupCol);
            Supplier<Block> woodenFenceGate = BlockPropertyWrapperTemplates.registerBlockWithItemFromTemplate(familyId.m_266382_("_fence_gate"), () -> new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50192_), woodBlockType), BlockPropertyWrapperTemplates.WOODEN_FENCE_GATE, blockSupCol, itemSupCol);
            Supplier<Block> woodenDoor = BlockPropertyWrapperTemplates.registerBlockWithItemFromTemplate(familyId.m_266382_("_door"), () -> new DoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50154_), woodBlockSetType), BlockPropertyWrapperTemplates.WOODEN_DOOR, blockSupCol, itemSupCol);
            Supplier<Block> woodenTrapdoor = BlockPropertyWrapperTemplates.registerBlockWithItemFromTemplate(familyId.m_266382_("_trapdoor"), () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50216_), woodBlockSetType), BlockPropertyWrapperTemplates.WOODEN_TRAPDOOR, blockSupCol, itemSupCol);
            Supplier<Block> woodenPressurePlate = BlockPropertyWrapperTemplates.registerBlockWithItemFromTemplate(familyId.m_266382_("_pressure_plate"), () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50167_), woodBlockSetType), BlockPropertyWrapperTemplates.WOODEN_PRESSURE_PLATE, blockSupCol, itemSupCol);
            Supplier<Block> woodenButton = BlockPropertyWrapperTemplates.registerBlockWithItemFromTemplate(familyId.m_266382_("_button"), () -> new ButtonBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50251_), woodBlockSetType, 30, true), BlockPropertyWrapperTemplates.WOODEN_BUTTON, blockSupCol, itemSupCol);
            Supplier<Block> woodenStandingSign = BlockPropertyWrapperTemplates.registerBlockFromTemplate(standardSignId, () -> new DefaultableStandingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50095_), woodBlockType), BlockPropertyWrapperTemplates.WOODEN_STANDING_SIGN, blockSupCol);
            Supplier<Block> woodenWallSign = BlockPropertyWrapperTemplates.registerBlockFromTemplate(familyId.m_266382_("_wall_sign"), () -> new DefaultableWallSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50158_), woodBlockType), BlockPropertyWrapperTemplates.WOODEN_WALL_SIGN, blockSupCol);
            Supplier<Block> woodenCeilingHangingSign = BlockPropertyWrapperTemplates.registerBlockFromTemplate(standardHangingSignId, () -> new DefaultableCeilingHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244319_), woodBlockType), BlockPropertyWrapperTemplates.WOODEN_CEILING_HANGING_SIGN, blockSupCol);
            Supplier<Block> woodenWallHangingSign = BlockPropertyWrapperTemplates.registerBlockFromTemplate(familyId.m_266382_("_wall_hanging_sign"), () -> new DefaultableWallHangingSignBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_244093_), woodBlockType), BlockPropertyWrapperTemplates.WOODEN_WALL_HANGING_SIGN, blockSupCol);
            Supplier<SignItem> woodenSignItem = ItemPropertyWrapperTemplates.registerItem(standardSignId, () -> new SignItem(new Item.Properties().m_41487_(16), (Block)woodenStandingSign.get(), (Block)woodenWallSign.get()), itemSupCol);
            Supplier<HangingSignItem> woodenHangingSignItem = ItemPropertyWrapperTemplates.registerItem(standardHangingSignId, () -> new HangingSignItem((Block)woodenCeilingHangingSign.get(), (Block)woodenWallHangingSign.get(), new Item.Properties().m_41487_(16)), itemSupCol);
            Supplier<Item> woodenBoatItem = ItemPropertyWrapperTemplates.registerItemFromTemplate(familyId.m_266382_("_boat"), () -> new DefaultableBoatItem(false, BoatType.register(familyId.toString().replace(':', '-'), woodenPlanks), new Item.Properties().m_41487_(1)), ItemPropertyWrapperTemplates.BOAT, itemSupCol);
            Supplier<Item> woodenChestBoatItem = ItemPropertyWrapperTemplates.registerItemFromTemplate(familyId.m_266382_("_chest_boat"), () -> new DefaultableBoatItem(true, BoatType.register(familyId.toString().replace(':', '-'), woodenPlanks), new Item.Properties().m_41487_(1)), ItemPropertyWrapperTemplates.CHEST_BOAT, itemSupCol);
            BuiltInRegistries.f_257049_.m_6612_(familyId.m_247449_("sign")).ifPresentOrElse(arg_0 -> RegistryUtil.lambda$registerStandardWoodFamily$46(woodenStandingSign, woodenWallSign, (Set)woodBlockEntityFamilySet, arg_0), () -> RegistryUtil.lambda$registerStandardWoodFamily$50(familyId, woodenStandingSign, woodenWallSign, standardSignId, blockEntityTypeSupCol, (Set)woodBlockEntityFamilySet));
            BuiltInRegistries.f_257049_.m_6612_(familyId.m_247449_("hanging_sign")).ifPresentOrElse(arg_0 -> RegistryUtil.lambda$registerStandardWoodFamily$53(woodenCeilingHangingSign, woodenWallHangingSign, (Set)woodBlockEntityFamilySet, arg_0), () -> RegistryUtil.lambda$registerStandardWoodFamily$57(familyId, woodenCeilingHangingSign, woodenWallHangingSign, standardHangingSignId, blockEntityTypeSupCol, (Set)woodBlockEntityFamilySet));
            BuiltInRegistries.f_256780_.m_6612_(familyId.m_247449_("boat")).ifPresentOrElse(arg_0 -> RegistryUtil.lambda$registerStandardWoodFamily$59((Set)woodEntityTypeFamilySet, arg_0), () -> RegistryUtil.lambda$registerStandardWoodFamily$61(familyId, entityTypeSupCol, (Set)woodEntityTypeFamilySet));
            BuiltInRegistries.f_256780_.m_6612_(familyId.m_247449_("chest_boat")).ifPresentOrElse(arg_0 -> RegistryUtil.lambda$registerStandardWoodFamily$63((Set)woodEntityTypeFamilySet, arg_0), () -> RegistryUtil.lambda$registerStandardWoodFamily$65(familyId, entityTypeSupCol, (Set)woodEntityTypeFamilySet));
            woodBlockFamilySet.add(woodenLog);
            woodBlockFamilySet.add(woodBlock);
            woodBlockFamilySet.add(woodenStrippedLog);
            woodBlockFamilySet.add(woodenPlanks);
            woodBlockFamilySet.add(woodenSlab);
            woodBlockFamilySet.add(woodenStairs);
            woodBlockFamilySet.add(woodenFence);
            woodBlockFamilySet.add(woodenFenceGate);
            woodBlockFamilySet.add(woodenDoor);
            woodBlockFamilySet.add(woodenTrapdoor);
            woodBlockFamilySet.add(woodenPressurePlate);
            woodBlockFamilySet.add(woodenButton);
            woodBlockFamilySet.add(woodenStandingSign);
            woodBlockFamilySet.add(woodenWallSign);
            woodBlockFamilySet.add(woodenCeilingHangingSign);
            woodBlockFamilySet.add(woodenWallHangingSign);
            woodItemFamilySet.add(woodenSignItem);
            woodItemFamilySet.add(woodenHangingSignItem);
            woodItemFamilySet.add(woodenBoatItem);
            woodItemFamilySet.add(woodenChestBoatItem);
            return new WoodenBlockGroup(woodBlockSetType, woodBlockType, (Set<Supplier<? extends Block>>)woodBlockFamilySet, (Set<Supplier<? extends Item>>)woodItemFamilySet, (Set<Supplier<? extends BlockEntityType<? extends BlockEntity>>>)woodBlockEntityFamilySet, (Set<Supplier<? extends EntityType<? extends Entity>>>)woodEntityTypeFamilySet);
        });
    }

    public static WoodenBlockGroup registerStandardWoodFamily(ResourceLocation familyId, Supplier<TagKey<Item>> logTag) {
        return RegistryUtil.registerStandardWoodFamily(familyId, logTag, null, null, null, null);
    }

    public static WoodenBlockGroup registerStandardWoodFamily(ResourceLocation familyId) {
        return RegistryUtil.registerStandardWoodFamily(familyId, (Supplier<TagKey<Item>>)Suppliers.ofInstance(null));
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$65(ResourceLocation familyId, Collection entityTypeSupCol, Set woodEntityTypeFamilySet) {
        Supplier<EntityType<Boat>> woodenChestBoatEntityType = EntityTypePropertyWrapperTemplates.registerEntityTypeFromTemplateAndReflect(familyId.m_247449_("chest_boat"), () -> EntityType.Builder.m_20704_(DefaultableChestBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_(familyId.m_247449_("chest_boat").toString()), EntityTypePropertyWrapperTemplates.CHEST_BOAT, entityTypeSupCol);
        woodEntityTypeFamilySet.add(woodenChestBoatEntityType);
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$63(Set woodEntityTypeFamilySet, EntityType alreadyRegisteredBaseChestBoatEntity) {
        woodEntityTypeFamilySet.add(() -> alreadyRegisteredBaseChestBoatEntity);
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$61(ResourceLocation familyId, Collection entityTypeSupCol, Set woodEntityTypeFamilySet) {
        Supplier<EntityType<Boat>> woodenBoatEntityType = EntityTypePropertyWrapperTemplates.registerEntityTypeFromTemplateAndReflect(familyId.m_247449_("boat"), () -> EntityType.Builder.m_20704_(DefaultableBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_(familyId.m_247449_("boat").toString()), EntityTypePropertyWrapperTemplates.BOAT, entityTypeSupCol);
        woodEntityTypeFamilySet.add(woodenBoatEntityType);
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$59(Set woodEntityTypeFamilySet, EntityType alreadyRegisteredBaseBoatEntity) {
        woodEntityTypeFamilySet.add(() -> alreadyRegisteredBaseBoatEntity);
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$57(ResourceLocation familyId, Supplier woodenCeilingHangingSign, Supplier woodenWallHangingSign, ResourceLocation standardHangingSignId, Collection blockEntityTypeSupCol, Set woodBlockEntityFamilySet) {
        Supplier<BlockEntityType<SignBlockEntity>> woodenHangingSignBlockEntityType = BlockEntityTypePropertyWrapperTemplates.registerBlockEntityTypeFromTemplateAndReflect(familyId.m_247449_("hanging_sign"), () -> RegistryUtil.lambda$registerStandardWoodFamily$56(familyId, (Supplier)woodenCeilingHangingSign, (Supplier)woodenWallHangingSign, standardHangingSignId), BlockEntityTypePropertyWrapperTemplates.HANGING_SIGN, blockEntityTypeSupCol);
        woodBlockEntityFamilySet.add(woodenHangingSignBlockEntityType);
    }

    private static /* synthetic */ BlockEntityType lambda$registerStandardWoodFamily$56(ResourceLocation familyId, Supplier woodenCeilingHangingSign, Supplier woodenWallHangingSign, ResourceLocation standardHangingSignId) {
        return BlockEntityType.Builder.m_155273_((targetPos, targetState) -> new DefaultableHangingSignBlockEntity(() -> (BlockEntityType)BuiltInRegistries.f_257049_.m_6612_(familyId.m_247449_("hanging_sign")).orElseThrow(), targetPos, targetState), (Block[])new Block[]{(Block)woodenCeilingHangingSign.get(), (Block)woodenWallHangingSign.get()}).m_58966_(Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)standardHangingSignId.m_135815_()));
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$53(Supplier woodenCeilingHangingSign, Supplier woodenWallHangingSign, Set woodBlockEntityFamilySet, BlockEntityType alreadyRegisteredBaseHangingSignBlockEntity) {
        Supplier<BlockEntityType> mappedHangingSignBlockEntitySup = () -> alreadyRegisteredBaseHangingSignBlockEntity;
        BlockEntityType mappedHangingSignBlockEntity = mappedHangingSignBlockEntitySup.get();
        mappedHangingSignBlockEntity.f_58915_ = (Set)Util.m_137469_((Object)new ObjectOpenHashSet((Collection)mappedHangingSignBlockEntity.f_58915_), arg_0 -> RegistryUtil.lambda$registerStandardWoodFamily$52((Supplier)woodenCeilingHangingSign, (Supplier)woodenWallHangingSign, arg_0));
        woodBlockEntityFamilySet.add(mappedHangingSignBlockEntitySup);
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$52(Supplier woodenCeilingHangingSign, Supplier woodenWallHangingSign, ObjectOpenHashSet existingValidBlocks) {
        existingValidBlocks.add((Object)((Block)woodenCeilingHangingSign.get()));
        existingValidBlocks.add((Object)((Block)woodenWallHangingSign.get()));
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$50(ResourceLocation familyId, Supplier woodenStandingSign, Supplier woodenWallSign, ResourceLocation standardSignId, Collection blockEntityTypeSupCol, Set woodBlockEntityFamilySet) {
        Supplier<BlockEntityType<SignBlockEntity>> woodenSignBlockEntityType = BlockEntityTypePropertyWrapperTemplates.registerBlockEntityTypeFromTemplateAndReflect(familyId.m_247449_("sign"), () -> RegistryUtil.lambda$registerStandardWoodFamily$49(familyId, (Supplier)woodenStandingSign, (Supplier)woodenWallSign, standardSignId), BlockEntityTypePropertyWrapperTemplates.SIGN, blockEntityTypeSupCol);
        woodBlockEntityFamilySet.add(woodenSignBlockEntityType);
    }

    private static /* synthetic */ BlockEntityType lambda$registerStandardWoodFamily$49(ResourceLocation familyId, Supplier woodenStandingSign, Supplier woodenWallSign, ResourceLocation standardSignId) {
        return BlockEntityType.Builder.m_155273_((targetPos, targetState) -> new DefaultableSignBlockEntity(() -> (BlockEntityType)BuiltInRegistries.f_257049_.m_6612_(familyId.m_247449_("sign")).orElseThrow(), targetPos, targetState), (Block[])new Block[]{(Block)woodenStandingSign.get(), (Block)woodenWallSign.get()}).m_58966_(Util.m_137456_((DSL.TypeReference)References.f_16781_, (String)standardSignId.m_135815_()));
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$46(Supplier woodenStandingSign, Supplier woodenWallSign, Set woodBlockEntityFamilySet, BlockEntityType alreadyRegisteredBaseSignBlockEntity) {
        Supplier<BlockEntityType> mappedSignBlockEntitySup = () -> alreadyRegisteredBaseSignBlockEntity;
        BlockEntityType mappedSignBlockEntity = mappedSignBlockEntitySup.get();
        mappedSignBlockEntity.f_58915_ = (Set)Util.m_137469_((Object)new ObjectOpenHashSet((Collection)mappedSignBlockEntity.f_58915_), arg_0 -> RegistryUtil.lambda$registerStandardWoodFamily$45((Supplier)woodenStandingSign, (Supplier)woodenWallSign, arg_0));
        woodBlockEntityFamilySet.add(mappedSignBlockEntitySup);
    }

    private static /* synthetic */ void lambda$registerStandardWoodFamily$45(Supplier woodenStandingSign, Supplier woodenWallSign, ObjectOpenHashSet existingValidBlocks) {
        existingValidBlocks.add((Object)((Block)woodenStandingSign.get()));
        existingValidBlocks.add((Object)((Block)woodenWallSign.get()));
    }
}

