/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import java.util.List;
import java.util.Locale;

public final class StringUtil {
    private StringUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (StringUtil)");
    }

    public static String toTitleCase(String targetString, char ... delimiters) {
        if (targetString == null || targetString.isBlank() || delimiters.length == 0) {
            return targetString;
        }
        boolean[] isDelimiter = new boolean[65536];
        for (char delimiter : delimiters) {
            isDelimiter[delimiter] = true;
        }
        char[] inputChars = targetString.toCharArray();
        boolean capitalizeNext = true;
        int writeIndex = 0;
        for (int i = 0; i < inputChars.length; ++i) {
            char current = inputChars[i];
            if (capitalizeNext && Character.isLetter(current)) {
                inputChars[writeIndex++] = Character.toTitleCase(current);
                capitalizeNext = false;
                continue;
            }
            if (current < isDelimiter.length && isDelimiter[current]) {
                if (!(writeIndex <= 0 || writeIndex < inputChars.length && isDelimiter[inputChars[writeIndex - 1]])) {
                    inputChars[writeIndex++] = 32;
                }
                capitalizeNext = true;
                continue;
            }
            inputChars[writeIndex++] = current;
            capitalizeNext = false;
        }
        if (writeIndex > 0 && inputChars[writeIndex - 1] == ' ') {
            --writeIndex;
        }
        return new String(inputChars, 0, writeIndex);
    }

    public static String toTitleCase(String targetString) {
        return StringUtil.toTitleCase(targetString, '_', '-', ' ');
    }

    public static String literallyLocalize(String unlocalizedInput, List<String> separatorWords) {
        if (unlocalizedInput == null || unlocalizedInput.isBlank() || !unlocalizedInput.contains(".")) {
            return unlocalizedInput;
        }
        String transformedPrunedInput = StringUtil.toTitleCase(unlocalizedInput.substring(unlocalizedInput.lastIndexOf(".") + 1));
        for (String separatorWord : separatorWords) {
            transformedPrunedInput = transformedPrunedInput.replaceAll("\\b" + separatorWord + "\\b", separatorWord.toLowerCase(Locale.ROOT));
        }
        return transformedPrunedInput;
    }

    public static String localizeWithDefaultAssertions(String unlocalizedInput, List<String> separatorWords) {
        Object localizedInput = StringUtil.literallyLocalize(unlocalizedInput, separatorWords);
        if (((String)localizedInput).endsWith(" Block")) {
            localizedInput = "Block of " + ((String)localizedInput).substring(0, ((String)localizedInput).length() - " Block".length());
        }
        return localizedInput;
    }

    public static String pluralize(String word) {
        if (!(!word.endsWith("y") || word.endsWith("ay") || word.endsWith("ey") || word.endsWith("iy") || word.endsWith("oy") || word.endsWith("uy"))) {
            return word.substring(0, word.length() - 1) + "ies";
        }
        if (word.endsWith("s") || word.endsWith("x") || word.endsWith("z") || word.endsWith("ch") || word.endsWith("sh")) {
            return word + "es";
        }
        return word + "s";
    }

    public static boolean containsSuffix(String[] suffixes, String suffix) {
        if (suffixes == null || suffix == null) {
            return false;
        }
        for (String s : suffixes) {
            if (!s.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    public static String lastToken(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        int targetIdx = path.lastIndexOf(95);
        return targetIdx == -1 ? path : path.substring(targetIdx + 1);
    }

    public static String firstToken(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        int targetIdx = path.indexOf(95);
        return targetIdx == -1 ? path : path.substring(0, targetIdx);
    }

    public static String subLastToken(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        int targetIdx = path.lastIndexOf(95);
        return targetIdx == -1 ? path : path.substring(0, targetIdx);
    }
}

