/*
 * Decompiled with CFR 0.152.
 */
package com.mememan.nexus.util;

import com.mememan.nexus.client.block.WrappedBlockColor;
import com.mememan.nexus.template.object.item.dispense_item_behaviour.DefaultableBoatDispenseItemBehaviour;
import com.mememan.nexus.template.object.item.entity.boat.BoatType;
import com.mememan.nexus.template.object.item.entity.boat.DefaultableBoatItem;
import com.mememan.nexus.util.RegistryUtil;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public final class VanillaUtil {
    private VanillaUtil() {
        throw new IllegalAccessError("Attempted to construct instance of utility class! (VanillaUtil)");
    }

    public static IntIntMutablePair standardFlammability(Supplier<Block> targetBlock) {
        Block targetBlockObj = targetBlock.get();
        return targetBlockObj instanceof TallGrassBlock || targetBlockObj instanceof FlowerBlock || targetBlockObj instanceof TallFlowerBlock ? IntIntMutablePair.of((int)60, (int)100) : (targetBlockObj.m_7705_().endsWith("_leaves") || targetBlockObj instanceof LeavesBlock || targetBlockObj.m_7705_().endsWith("_wool") ? IntIntMutablePair.of((int)30, (int)60) : (targetBlockObj.m_7705_().endsWith("_carpet") || targetBlockObj instanceof CarpetBlock ? IntIntMutablePair.of((int)60, (int)20) : (targetBlockObj.m_7705_().endsWith("_log") ? IntIntMutablePair.of((int)5, (int)5) : IntIntMutablePair.of((int)5, (int)20))));
    }

    public static BlockState standardWoodLogStrippingState(BlockState targetBlockState) {
        return RegistryUtil.getObjectFrom(targetBlockState.m_60734_(), parentBlockId -> parentBlockId.m_135815_().endsWith("_wood") ? RegistryUtil.pickPrefix(parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_wood", "_log")), "stripped_") : RegistryUtil.pickPrefix(parentBlockId, "stripped_")).map(strippedState -> (BlockState)strippedState.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)targetBlockState.m_61143_((Property)RotatedPillarBlock.f_55923_)))).orElse(null);
    }

    public static Pair<Predicate<UseOnContext>, Consumer<UseOnContext>> dirtFarmlandTillingAction(Supplier<Block> targetBlock) {
        Function<Block, Pair> tillingBehaviourMapper = parentBlock -> Pair.of(HoeItem::m_150856_, (Object)HoeItem.m_150858_((BlockState)parentBlock.m_49966_()));
        return RegistryUtil.getObjectFrom(targetBlock, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_dirt", "_farmland"))).or(() -> RegistryUtil.getObjectFrom(targetBlock, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_farmland", "")))).map(tillingBehaviourMapper).orElse(null);
    }

    public static Pair<Predicate<UseOnContext>, Consumer<UseOnContext>> grassBlockFarmlandTillingAction(Supplier<Block> targetBlock) {
        Function<Block, Pair> tillingBehaviourMapper = parentBlock -> Pair.of(HoeItem::m_150856_, (Object)HoeItem.m_150858_((BlockState)parentBlock.m_49966_()));
        return RegistryUtil.getObjectFrom(targetBlock, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_grass_block", "_farmland"))).or(() -> RegistryUtil.getObjectFrom(targetBlock, parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_farmland", "")))).map(tillingBehaviourMapper).orElse(null);
    }

    public static BlockState dirtPathFlatteningAction(BlockState targetBlockState) {
        return RegistryUtil.getObjectFrom(targetBlockState.m_60734_(), parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_dirt", "_path"))).or(() -> RegistryUtil.getObjectFrom(targetBlockState.m_60734_(), parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_path", "")))).map(Block::m_49966_).orElse(null);
    }

    public static BlockState grassBlockPathFlatteningAction(BlockState targetBlockState) {
        return RegistryUtil.getObjectFrom(targetBlockState.m_60734_(), parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_grass_block", "_path"))).or(() -> RegistryUtil.getObjectFrom(targetBlockState.m_60734_(), parentBlockId -> parentBlockId.m_247449_(parentBlockId.m_135815_().replace("_grass_block", "")))).map(Block::m_49966_).orElse(null);
    }

    @NotNull
    public static WrappedBlockColor standardGrassColor(Supplier<Block> targetBlock) {
        return (targetState, tintGetter, targetPos, tint) -> tintGetter != null && targetPos != null ? BiomeColors.m_108793_((BlockAndTintGetter)tintGetter, (BlockPos)targetPos) : GrassColor.m_46415_((double)0.5, (double)1.0);
    }

    public static <IL extends ItemLike> DispenseItemBehavior standardBoatDispenseBehavior(Supplier<IL> targetItemLike) {
        BoatType boatType;
        IL IL = targetItemLike.get();
        if (IL instanceof DefaultableBoatItem) {
            DefaultableBoatItem defBoatItem = (DefaultableBoatItem)((Object)IL);
            boatType = defBoatItem.getBoatType();
        } else {
            boatType = BoatType.OAK;
        }
        return new DefaultableBoatDispenseItemBehaviour(boatType);
    }

    public static <IL extends ItemLike> DispenseItemBehavior standardChestBoatDispenseBehavior(Supplier<IL> targetItemLike) {
        BoatType boatType;
        IL IL = targetItemLike.get();
        if (IL instanceof DefaultableBoatItem) {
            DefaultableBoatItem defBoatItem = (DefaultableBoatItem)((Object)IL);
            boatType = defBoatItem.getBoatType();
        } else {
            boatType = BoatType.OAK;
        }
        return new DefaultableBoatDispenseItemBehaviour(boatType, true);
    }
}

